/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLAlert;
import COM.claymoresystems.ptls.SSLAlertException;
import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLCipherState;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLException;
import COM.claymoresystems.ptls.SSLHandshake;
import COM.claymoresystems.ptls.SSLHandshakeClient;
import COM.claymoresystems.ptls.SSLHandshakeFailedException;
import COM.claymoresystems.ptls.SSLHandshakeServer;
import COM.claymoresystems.ptls.SSLReHandshakeException;
import COM.claymoresystems.ptls.SSLRecord;
import COM.claymoresystems.ptls.SSLRecordReader;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.ptls.SSLThrewAlertException;
import COM.claymoresystems.sslg.SSLPolicyInt;
import COM.claymoresystems.util.Util;
import cryptix.util.core.ArrayUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Vector;

public class SSLConn {
    public static final int SSL_CLIENT = 1;
    public static final int SSL_SERVER = 2;
    static int debugVal = 0;
    int ssl_version = 0;
    int max_ssl_version = 0;
    SSLContext ctx;
    SSLSocket s = null;
    SSLPolicyInt policy;
    PushbackInputStream sock_in;
    InputStream sock_in_hp;
    InputStream sock_in_data;
    OutputStream _sock_out;
    BufferedOutputStream sock_out;
    OutputStream sock_out_external;
    boolean sentClose = false;
    boolean recvdClose = false;
    Vector peerCertificateChain = null;
    String sessionLookupKey = null;
    int how;
    byte[] session_id;
    SSLCipherState write_cipher_state = null;
    SSLCipherState read_cipher_state = null;
    SSLCipherState next_write_cipher_state;
    SSLCipherState next_read_cipher_state;
    long write_sequence_num;
    long read_sequence_num;
    boolean secureMode = false;
    boolean invalid = false;
    SSLHandshake hs;
    SSLRecordReader reader;

    public SSLConn(SSLSocket sock, InputStream in, OutputStream out, SSLContext c, int how) throws IOException {
        this.s = sock;
        this.how = how;
        this.ctx = c;
        this.policy = c.getPolicy();
        this.sock_in = new PushbackInputStream(in);
        this._sock_out = out;
        this.sock_out = new BufferedOutputStream(this._sock_out);
        this.reader = new SSLRecordReader(this);
    }

    void renegotiate(SSLPolicyInt p) throws IOException {
        this.policy = p;
        this.handshake();
    }

    void handshake() throws IOException {
        this.init();
        this.finishHandshake();
    }

    public void init() {
        if (this.read_cipher_state == null) {
            this.max_ssl_version = this.policy.negotiateTLSP() ? 769 : 768;
            this.ssl_version = this.policy.negotiateTLSP() ? 769 : 768;
        }
        this.hs = this.how == 1 ? new SSLHandshakeClient(this) : new SSLHandshakeServer(this);
    }

    public void finishHandshake() throws IOException {
        try {
            this.hs.handshake();
            if (this.sock_in_hp.available() != 0) {
                this.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
            }
            this.secureMode = true;
        }
        catch (IOException e) {
            if ((SSLDebug.debugVal & 0x40) > 0) {
                e.printStackTrace();
            }
            if (!(e instanceof SSLAlertException)) {
                throw new SSLHandshakeFailedException(e.toString());
            }
            throw e;
        }
    }

    public int getCipherSuite() throws IOException {
        if (!this.hs.finishedP()) {
            throw new SSLException("Handshake not finished");
        }
        return this.write_cipher_state.cipher_suite.getValue();
    }

    SSLPolicyInt getPolicy() {
        return this.policy;
    }

    byte[] getSessionID() throws IOException {
        if (!this.hs.finishedP()) {
            throw new SSLException("Handshake not finished");
        }
        return this.session_id;
    }

    int getVersion() throws IOException {
        if (!this.hs.finishedP()) {
            throw new SSLException("Handshake not finished");
        }
        return this.ssl_version;
    }

    public SSLRecordReader getRecordReader() {
        return this.reader;
    }

    public SSLCipherState getReadCipherState() {
        return this.read_cipher_state;
    }

    public SSLCipherState getWriteCipherState() {
        return this.write_cipher_state;
    }

    public long getWriteSequence() {
        return this.write_sequence_num;
    }

    public long getReadSequence() {
        return this.read_sequence_num;
    }

    public void incrementReadSequence() {
        ++this.read_sequence_num;
    }

    public void incrementWriteSequence() {
        ++this.write_sequence_num;
    }

    public SSLHandshake getHandshake() {
        return this.hs;
    }

    public Vector getCertificateChain() throws IOException {
        if (!this.hs.finishedP()) {
            throw new SSLException("Handshake not finished");
        }
        return this.peerCertificateChain;
    }

    void alert(int a) throws IOException {
        this.sendAlertNoException(a, true);
        throw new SSLThrewAlertException(new SSLAlertX(this.ssl_version, a, true));
    }

    void alert(int a, String msg) throws IOException {
        this.sendAlertNoException(a, true);
        throw new SSLThrewAlertException(new SSLAlertX(this.ssl_version, a, true), msg);
    }

    void sendAlertNoException(int a, boolean fatal) throws IOException {
        SSLAlertX alertx = new SSLAlertX(this.ssl_version, a, fatal);
        if (fatal) {
            SSLDebug.debug(4, "Throwing a fatal alert, lookup key " + this.sessionLookupKey);
            this.makeUnresumable();
            this.invalid = true;
        }
        SSLAlert alert = new SSLAlert(alertx);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        alert.encode(this, bos);
        SSLRecord r = new SSLRecord(this, 21, bos.toByteArray());
        r.send(this);
        this.sock_out.flush();
    }

    boolean processIncomingHandshakeRecord(byte[] data) throws IOException {
        byte[] helloRequest = new byte[]{0, 0, 0, 0};
        if (this.hs.finishedP()) {
            switch (data[0]) {
                case 0: {
                    if (this.how != 1) {
                        this.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
                    }
                    if (!ArrayUtil.areEqual((byte[])data, (byte[])helloRequest)) {
                        this.alert(SSLAlertX.TLS_ALERT_ILLEGAL_PARAMETER);
                    }
                    throw new SSLReHandshakeException();
                }
                case 1: {
                    if (this.how != 2) {
                        this.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
                    }
                    return true;
                }
            }
            this.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
        } else if (data[0] == 0) {
            this.alert(SSLAlertX.TLS_ALERT_UNEXPECTED_MESSAGE);
        }
        return false;
    }

    static boolean isDebugEnabled(int type) {
        return (debugVal & type) > 0;
    }

    static void debug(int type, String val) {
        if ((debugVal & type) > 0) {
            System.out.println(val);
        }
    }

    static void debug(int type, String label, byte[] hd) {
        if ((debugVal & type) > 0) {
            Util.xdump(label, hd);
        }
    }

    public InputStream getInStream() {
        if (!this.hs.finishedP()) {
            return null;
        }
        if (this.read_cipher_state == null) {
            return null;
        }
        return this.sock_in_data;
    }

    public OutputStream getOutStream() {
        if (!this.hs.finishedP()) {
            return null;
        }
        if (this.write_cipher_state == null) {
            return null;
        }
        return this.sock_out_external;
    }

    void makeUnresumable() {
        if (this.sessionLookupKey != null) {
            SSLDebug.debug(4, "Making session " + this.sessionLookupKey + "Unresumable");
            this.ctx.destroySession(this.sessionLookupKey);
        }
    }

    void sendClose() throws IOException {
        if (!this.sentClose) {
            this.sendAlertNoException(SSLAlertX.TLS_ALERT_CLOSE_NOTIFY, false);
            this.sentClose = true;
        }
    }

    void recvClose(boolean enforceFinished) throws IOException {
        InputStream in = this.getInStream();
        byte[] buf = new byte[1024];
        while (in.read(buf) >= 0) {
            if (!enforceFinished) continue;
            throw new SSLException("Excess data in pipe when closed");
        }
    }

    void close() throws IOException {
        this.sendClose();
        if (this.policy.waitOnCloseP()) {
            this.recvClose(false);
        }
        if (this.s != null) {
            this.s.hardClose();
        }
    }

    public static void setDebug(int flag) {
        debugVal = flag;
    }
}

