/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import org.opensaml.XML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class QName {
    private String namespace = null;
    private String localName = null;

    public QName(String string, String string2) {
        this.namespace = string;
        this.localName = string2;
    }

    public static QName getQNameAttribute(Element element, String string, String string2) {
        String string3 = element.getAttributeNS(string, string2);
        if (string3 == null) {
            return null;
        }
        return new QName(QName.getNamespaceForQName(string3, element), string3.substring(string3.indexOf(58) + 1));
    }

    public static QName getQNameTextNode(Text text) {
        String string = text.getNodeValue();
        Node node = text.getParentNode();
        if (string == null || node == null || node.getNodeType() != 1) {
            return null;
        }
        return new QName(QName.getNamespaceForQName(string, (Element)node), string.substring(string.indexOf(58) + 1));
    }

    public static String getNamespaceForQName(String string, Element element) {
        String string2 = "";
        if (string != null && string.indexOf(58) >= 0) {
            string2 = string.substring(0, string.indexOf(58));
        }
        return QName.getNamespaceForPrefix(string2, element);
    }

    public static String getNamespaceForPrefix(String string, Element element) {
        Node node = element;
        String string2 = null;
        if (string != null) {
            if (string.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if (string.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
        }
        while ((string2 == null || string2.length() == 0) && node != null && node.getNodeType() == 1) {
            string2 = node.getAttributeNS("http://www.w3.org/2000/xmlns/", string != null ? string : "xmlns");
            node = node.getParentNode();
        }
        return string2;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean equals(Object object) {
        return object instanceof QName && XML.safeCompare(this.namespace, ((QName)object).getNamespaceURI()) && XML.safeCompare(this.localName, ((QName)object).getLocalName());
    }

    public int hashCode() {
        return (this.namespace == null ? 0 : this.namespace.hashCode()) + (this.localName == null ? 0 : this.localName.hashCode());
    }

    public String toString() {
        return '{' + (this.namespace == null ? "none" : this.namespace) + "}:" + this.localName;
    }
}

