/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.resources.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.resources.service.Dependency;

public class Package {
    protected String description;
    private String name;
    private String version;
    private List<String> installScripts = new ArrayList<String>();
    private List<String> uninstallScripts = new ArrayList<String>();
    private List<String> rebootScripts = new ArrayList<String>();
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private ScopeLevel mandatoryLevel;
    private ScopeLevel sharingLevel = ScopeLevel.VO;
    private List<GHNRequirement> requirements = new ArrayList<GHNRequirement>();
    private Boolean multiVersion;
    private String specificData;
    private PlatformDescription targetPlatform;
    protected Map<MavenCoordinate, String> coordinates = new HashMap<MavenCoordinate, String>();

    public String getName() {
        return this.name;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<GHNRequirement> getGHNRequirements() {
        return this.requirements;
    }

    public List<String> getInstallScripts() {
        return this.installScripts;
    }

    public Boolean getMultiVersion() {
        return this.multiVersion;
    }

    public void setMultiVersion(Boolean support) {
        this.multiVersion = support;
    }

    public List<String> getRebootScripts() {
        return this.rebootScripts;
    }

    public List<String> getUninstallScripts() {
        return this.uninstallScripts;
    }

    public String getVersion() {
        return this.version;
    }

    public ScopeLevel getMandatoryLevel() {
        return this.mandatoryLevel;
    }

    public void setMandatoryLevel(ScopeLevel level) {
        this.mandatoryLevel = level;
    }

    public ScopeLevel getSharingLevel() {
        return this.sharingLevel;
    }

    public void setSharingLevel(ScopeLevel level) {
        this.sharingLevel = level;
    }

    public void setGHNRequirements(List<GHNRequirement> arg0) {
        this.requirements = arg0;
    }

    public void setName(String arg0) {
        this.name = arg0;
    }

    public void setMavenCoordinates(String groupId, String artifactId, String version, String ... classifier) {
        this.coordinates.put(MavenCoordinate.groupId, groupId);
        this.coordinates.put(MavenCoordinate.artifactId, artifactId);
        this.coordinates.put(MavenCoordinate.version, version);
        if (classifier != null && classifier.length > 0 && classifier[0] != null) {
            this.coordinates.put(MavenCoordinate.classifier, classifier[0]);
        }
    }

    public String getMavenCoordinate(MavenCoordinate name) {
        return this.coordinates.get((Object)name);
    }

    public void setUninstallScripts(List<String> scripts) {
        this.uninstallScripts = scripts;
    }

    public void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Attempt to change version of gCube package with an invalid version " + version);
        }
        this.version = version;
    }

    public void setInstallScripts(List<String> installScripts) {
        this.installScripts = installScripts;
    }

    public void setRebootScripts(List<String> rebootScripts) {
        this.rebootScripts = rebootScripts;
    }

    public String getSpecificData() {
        return this.specificData;
    }

    public void setSpecificData(String data) {
        this.specificData = data;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTargetPlatform(PlatformDescription targetPlatform) {
        this.targetPlatform = targetPlatform;
    }

    public PlatformDescription getTargetPlatform() {
        return this.targetPlatform;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Package other = (Package)obj;
        if (this.specificData == null ? other.specificData != null : !this.specificData.equals(other.specificData)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
            return false;
        }
        if (this.requirements == null ? other.requirements != null : !this.requirements.equals(other.requirements)) {
            return false;
        }
        if (this.installScripts == null ? other.installScripts != null : !this.installScripts.equals(other.installScripts)) {
            return false;
        }
        if (this.multiVersion == null ? other.multiVersion != null : !this.multiVersion.equals(other.multiVersion)) {
            return false;
        }
        if (this.rebootScripts == null ? other.rebootScripts != null : !this.rebootScripts.equals(other.rebootScripts)) {
            return false;
        }
        if (this.uninstallScripts == null ? other.uninstallScripts != null : !this.uninstallScripts.equals(other.uninstallScripts)) {
            return false;
        }
        if (this.mandatoryLevel == null ? other.mandatoryLevel != null : !this.mandatoryLevel.equals((Object)other.mandatoryLevel)) {
            return false;
        }
        if (this.sharingLevel == null ? other.sharingLevel != null : !this.sharingLevel.equals((Object)other.sharingLevel)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }

    public static class GHNRequirement {
        protected Category category;
        protected String scategory;
        protected OpType operator;
        protected String requirement;
        protected String value;
        protected String key;

        public Category getCategory() {
            return this.category;
        }

        @Deprecated
        public void setCategory(String category) {
            this.scategory = category;
        }

        public void setCategory(Category category) {
            this.category = category;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public OpType getOperator() {
            return this.operator;
        }

        public void setOperator(OpType operator) {
            this.operator = operator;
        }

        public String getRequirement() {
            return this.requirement;
        }

        public void setRequirement(String requirement) {
            this.requirement = requirement;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GHNRequirement other = (GHNRequirement)obj;
            if (this.category == null ? other.category != null : !this.category.equals((Object)other.category)) {
                return false;
            }
            if (this.operator == null ? other.operator != null : !this.operator.equals((Object)other.operator)) {
                return false;
            }
            if (this.requirement == null ? other.requirement != null : !this.requirement.equals(other.requirement)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public static enum OpType {
            EQ("eq"),
            EXIST("exist"),
            GE("ge"),
            GT("gt"),
            LE("le"),
            LT("lt"),
            NE("ne"),
            CONTAINS("contains");

            private final String value;

            private OpType(String v) {
                this.value = v;
            }

            public String value() {
                return this.value;
            }

            public static OpType fromValue(String v) {
                for (OpType c : OpType.values()) {
                    if (!c.value.equals(v)) continue;
                    return c;
                }
                throw new IllegalArgumentException(v.toString());
            }
        }

        public static enum Category {
            MEM_RAM_AVAILABLE,
            MEM_RAM_SIZE,
            MEM_VIRTUAL_AVAILABLE,
            MEM_VIRTUAL_SIZE,
            HOST,
            OS,
            DISK_SPACE,
            LOAD1MIN,
            LOAD5MIN,
            LOAD15MIN,
            PLATFORM,
            PROCESSOR_NUM,
            PROCESSOR_BOGOMIPS,
            SITE_LOCATION,
            SITE_COUNTRY,
            SITE_DOMAIN,
            RUNTIME_ENV_STRING,
            RUNTIME_ENV_NUMBER;


            public static boolean hasValue(String v) {
                for (Category c : Category.values()) {
                    if (c.toString().compareTo(v) != 0) continue;
                    return true;
                }
                return false;
            }
        }
    }

    public static enum MavenCoordinate {
        groupId,
        artifactId,
        version,
        classifier;

    }

    public static enum ScopeLevel {
        NONE,
        GHN,
        VRE,
        VO;

    }
}

