/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators;

import java.util.HashMap;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.operators.DeployerOperator;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntRunner;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Downloader;
import org.gcube.common.vremanagement.deployer.impl.operators.patch.PatchExtractor;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;

public class PatchOperator
extends GCUBEHandler<GCUBEHandler<?>> {
    private PackageInfo packageinfo;
    private URI uri;
    private static final String SCRIPT = "apply.sh";
    private String callbackID = "";
    private boolean restart = false;
    private EndpointReferenceType callbackEPR = null;
    private GCUBEScope callerScope = null;

    public PatchOperator(PackageInfo packageinfo, URI uri, EndpointReferenceType callbackEPR, String callbackID, boolean restart, GCUBEScope callerScope) {
        this.packageinfo = packageinfo;
        this.uri = uri;
        this.callbackID = callbackID;
        this.callbackEPR = callbackEPR;
        this.restart = restart;
        this.callerScope = callerScope;
    }

    public void run() throws Exception {
        this.logger.info((Object)"Starting the patcher");
        Report finalreport = new Report(this.callbackEPR, this.callbackID, 1, Report.TYPE.PATCH, this.callerScope);
        DeployerOperator.deployLock.lock();
        try {
            Downloader downloader = new Downloader(this.packageinfo, true);
            downloader.downloadPatch(new java.net.URI(this.uri.toString()));
            this.apply(Configuration.BASESOURCEDIR, new PatchExtractor(downloader).getPatchFolder());
            this.logger.info((Object)("patch succcessfully applied to " + this.packageinfo.getName()));
        }
        catch (Exception e) {
            this.logger.error((Object)("failed to apply the patch to " + this.packageinfo.getName()), (Throwable)e);
            finalreport.addPackage(this.packageinfo, Report.PACKAGESTATUS.FAILED, 0, new String[0]);
        }
        try {
            finalreport.addPackage(this.packageinfo, Report.PACKAGESTATUS.PATCHED, 0, new String[0]);
            finalreport.close();
            finalreport.send();
            finalreport.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.restart) {
            GHNContext.getContext().restart(new String[0]);
        }
        DeployerOperator.deployLock.unlock();
    }

    private void apply(String srcDir, String destDir) throws DeployException {
        AntRunner local_run;
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            local_run = new AntRunner();
            local_run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
        }
        catch (Exception e) {
            this.logger.error((Object)"Deployer is unable to initialize the patching environment", (Throwable)e);
            throw new DeployException("Deployer is unable to initialize the patching environment");
        }
        properties = new HashMap();
        properties.put("base.script.dir", destDir);
        properties.put("exec.name", SCRIPT);
        try {
            local_run.setProperties(properties, true);
            local_run.runTarget("runScript");
        }
        catch (AntInterfaceException aie) {
            throw new DeployException(aie.getMessage());
        }
        properties = new HashMap();
        properties.put("folder", destDir);
        try {
            local_run.setProperties(properties, true);
            local_run.runTarget("deleteFolder");
        }
        catch (AntInterfaceException aie) {
            throw new DeployException(aie.getMessage());
        }
        properties = new HashMap();
        properties.put("folder", srcDir);
        try {
            local_run.setProperties(properties, true);
            local_run.runTarget("deleteFolder");
        }
        catch (AntInterfaceException aie) {
            throw new DeployException(aie.getMessage());
        }
        properties = new HashMap();
        properties.put("base.deploy.dir", Configuration.BASESOURCEDIR);
        properties.put("package.source.dir", Configuration.BASESOURCEDIR);
        try {
            local_run.setProperties(properties, true);
            local_run.runTarget("deleteTempFiles");
        }
        catch (AntInterfaceException aie) {
            throw new DeployException(aie.getMessage());
        }
    }
}

