/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.handlers;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBEServiceAuthenticationController;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;

public class GCUBEHandler
extends BasicHandler {
    public static final String SERVICECONTEXT_PROPERTY = "receiver";
    public static final String CALLER_PROPERTY = "caller";
    protected static GCUBELog logger = new GCUBELog(GCUBEHandler.class);
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<Long> startCallThreadLocal = new ThreadLocal();

    public void invoke(MessageContext mc) throws GCUBEFault {
        GCUBEServiceContext context;
        logger.debug("GCube Handler invoked");
        if (mc.getPastPivot()) {
            logger.trace("Past Pivot");
            this.onResponse(mc, new boolean[0]);
            return;
        }
        startCallThreadLocal.set(System.currentTimeMillis());
        SOAPHeader header = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            logger.trace("Getting headers");
            header = MessageContext.getCurrentContext().getCurrentMessage().getSOAPHeader();
        }
        catch (SOAPException e1) {
            throw new GCUBEUnrecoverableFault("call is malformed: could not process headers");
        }
        Iterator i = header.getChildElements();
        while (i.hasNext()) {
            SOAPElement child = (SOAPElement)i.next();
            String name = child.getElementName().getLocalName();
            String value = child.getValue();
            logger.trace("Header name = " + name + " value " + value);
            headers.put(name, value);
        }
        String calledMethod = headers.get("gcube-method") != null ? (String)headers.get("gcube-method") : "UNKNOWN";
        CalledMethodProvider.instance.set(calledMethod);
        if (!(headers.get("serviceClass") != null && headers.get("serviceName") != null || GHNContext.getContext().isSecurityEnabled())) {
            logger.debug("Security not enabled: the call without service header passes");
            return;
        }
        if ((headers.get("serviceClass") == null || headers.get("serviceName") == null) && GHNContext.getContext().isSecurityEnabled()) {
            logger.error("Unable to determine the correct service security configuration and to find the correct security controller: the calla will not pass");
            throw new GCUBEUnrecoverableException("Unable to determine the service").toFault(new String[0]);
        }
        try {
            context = GHNContext.getContext().getServiceContext((String)headers.get("serviceClass"), (String)headers.get("serviceName"));
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableException(e).toFault("Could not dispatch gCube call to service " + (String)headers.get("serviceName"));
        }
        if (context.getStatus() == GCUBEServiceContext.Status.FAILED || context.getStatus() == GCUBEServiceContext.Status.DOWN) {
            throw new GCUBERetryEquivalentFault("Service " + (String)headers.get("serviceName") + " is not operational");
        }
        if (context.getStatus() != GCUBEServiceContext.Status.READIED) {
            throw new GCUBERetrySameFault("Service " + (String)headers.get("serviceName") + " is not ready yet");
        }
        mc.setProperty(SERVICECONTEXT_PROPERTY, (Object)context);
        logger.trace("Service context set");
        try {
            String caller = (String)headers.get(CALLER_PROPERTY);
            mc.setProperty(CALLER_PROPERTY, (Object)caller);
            String target = context.getServiceClass() + ":" + context.getName() + ":" + CalledMethodProvider.instance.get();
            logger.info("START CALL FROM (" + caller + ") TO (" + target + ")," + (String)headers.get("scope") + "," + Thread.currentThread());
            String token = (String)headers.get("gcube-token");
            if (!this.validateToken(token, caller, context)) {
                if (headers.get("scope") == null) {
                    throw new Exception("gCube call is unscoped");
                }
                context.getTiming();
                if (caller == null) {
                    caller = "UNKNOWN";
                }
                GCUBEScope scope = GCUBEScope.getScope((String)headers.get("scope"));
                logger.trace("Scope = " + scope);
                context.setScope(scope);
                if (GHNContext.getContext().isSecurityEnabled()) {
                    logger.trace("peer subject " + mc.getProperty("callerSubject"));
                    logger.trace("Setting security");
                    HashMap<String, Object> securityParameterMap = new HashMap<String, Object>();
                    securityParameterMap.put("CONTEXT", context);
                    securityParameterMap.put("HEADERS", headers);
                    securityParameterMap.put("MESSAGE_CONTEXT", mc);
                    GCUBEServiceAuthenticationController authenticationManager = context.getAuthenticationManager();
                    GCUBEServiceAuthorizationController authorizationManager = context.getAuthorizationManager();
                    authenticationManager.authenticateCall(securityParameterMap);
                    authorizationManager.authoriseCall(securityParameterMap);
                    logger.trace("Security set");
                }
            }
        }
        catch (GCUBEException e) {
            logger.error("Error in GCubeHandler", e);
            this.onResponse(mc, new boolean[0]);
            throw e.toFault(new String[0]);
        }
        catch (Exception e) {
            logger.error("General exception in GCubeHandler", e);
            this.onResponse(mc, new boolean[0]);
            throw new GCUBEUnrecoverableException(e).toFault(new String[0]);
        }
    }

    private boolean validateToken(String token, String caller, GCUBEServiceContext context) throws Exception {
        if (token != null) {
            ScopeProvider.instance.set(context.getStartScopes()[0].getInfrastructure().toString());
            AuthorizationEntry info = ((AuthorizationProxy)Constants.authorizationService().build()).get(token);
            if (info == null) {
                logger.info("rejecting call to " + caller + ", invalid token " + token);
                throw new Exception("invalid token " + token);
            }
            AuthorizationProvider.instance.set(new UserInfo(info.getUserName(), info.getRoles(), info.getBannedServices()));
            GCUBEScope scope = GCUBEScope.getScope(info.getScope());
            logger.trace("Scope = " + scope);
            context.setScope(scope);
            logger.info("retrieved request authorization info " + AuthorizationProvider.instance.get() + " in scope " + ScopeProvider.instance.get());
            SecurityTokenProvider.instance.set(token);
            return true;
        }
        logger.info("token not found");
        return false;
    }

    public void onFault(MessageContext mc) {
        super.onFault(mc);
        this.onResponse(mc, true);
    }

    private void onResponse(MessageContext mc, boolean ... failure) {
        if (!mc.isPropertyTrue(SERVICECONTEXT_PROPERTY)) {
            return;
        }
        GCUBEServiceContext context = (GCUBEServiceContext)mc.getProperty(SERVICECONTEXT_PROPERTY);
        String caller = (String)mc.getProperty(CALLER_PROPERTY);
        String target = context.getServiceClass() + ":" + context.getName() + ":" + CalledMethodProvider.instance.get();
        String currentScope = ScopeProvider.instance.get();
        logger.info("END CALL FROM (" + caller + ") TO (" + target + ")," + (currentScope == null ? "INVALID" : currentScope + "," + Thread.currentThread() + ",[" + context.getTiming() + "]"));
        if (AuthorizationProvider.instance.get() != null) {
            this.generateAccounting(AuthorizationProvider.instance.get().getUserName(), caller, context);
        } else {
            this.generateAccounting("UNKNOWN", caller, context);
        }
        context.getManagementBean().setLastResponseTime(context.getTiming());
        context.getManagementBean().addCall();
        if (failure != null && failure.length > 0 && failure[0]) {
            context.getManagementBean().addFailedCall();
        }
        context.resetTimer();
        ScopeProvider.instance.reset();
        startCallThreadLocal.remove();
        SecurityTokenProvider.instance.reset();
        CalledMethodProvider.instance.reset();
        AuthorizationProvider.instance.reset();
    }

    void generateAccounting(String caller, String remoteHost, GCUBEServiceContext serviceContext) {
        AccountingPersistenceFactory.setFallbackLocation((String)GHNContext.getContext().getStorageRoot());
        AccountingPersistence persistence = AccountingPersistenceFactory.getPersistence();
        ServiceUsageRecord serviceUsageRecord = new ServiceUsageRecord();
        try {
            serviceUsageRecord.setConsumerId(caller);
            serviceUsageRecord.setScope(ScopeProvider.instance.get());
            serviceUsageRecord.setServiceClass(serviceContext.getServiceClass());
            serviceUsageRecord.setServiceName(serviceContext.getName());
            serviceUsageRecord.setHost(GHNContext.getContext().getHostnameAndPort());
            serviceUsageRecord.setCalledMethod(CalledMethodProvider.instance.get());
            serviceUsageRecord.setCallerHost(remoteHost);
            serviceUsageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            serviceUsageRecord.setDuration(Long.valueOf(System.currentTimeMillis() - startCallThreadLocal.get()));
            persistence.account((SingleUsageRecord)serviceUsageRecord);
        }
        catch (Exception ex) {
            logger.warn("invalid record passed to accounting ", ex);
        }
    }
}

