/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.condition;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class DateTimeDifference
implements Condition {
    private String date1;
    private String date2;
    private String format = null;
    private boolean lenient = true;
    private int value = 0;
    private String unit = null;

    public void setDatetime1(String date) {
        if (date == null) {
            return;
        }
        if (this.date1 == null) {
            this.date1 = date;
        }
    }

    public void setDatetime2(String date) {
        if (date == null) {
            return;
        }
        if (this.date2 == null) {
            this.date2 = date;
        }
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setLenient(boolean b) {
        this.lenient = b;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setUnit(String unit) {
        if (unit == null) {
            return;
        }
        this.unit = unit;
    }

    public boolean eval() throws BuildException {
        try {
            if (this.format == null) {
                throw new BuildException("format is required");
            }
            SimpleDateFormat df = new SimpleDateFormat(this.format);
            df.setLenient(this.lenient);
            if (this.date1 == null || this.date2 == null) {
                throw new BuildException("Both datetime1 and datetime2 must be set.");
            }
            Date d1 = df.parse(this.date1);
            Date d2 = df.parse(this.date2);
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(d1);
            cal2.setTime(d2);
            Calendar before = cal1.before(cal2) ? cal1 : cal2;
            Calendar after = cal1.before(cal2) ? cal2 : cal1;
            int cal_unit = 5;
            if (this.unit.equals("second")) {
                cal_unit = 13;
            } else if (this.unit.equals("millisecond")) {
                cal_unit = 14;
            } else if (this.unit.equals("minute")) {
                cal_unit = 12;
            } else if (this.unit.equals("hour")) {
                cal_unit = 10;
            } else if (this.unit.equals("day")) {
                cal_unit = 5;
            } else if (this.unit.equals("week")) {
                cal_unit = 3;
            } else if (this.unit.equals("month")) {
                cal_unit = 2;
            } else if (this.unit.equals("year")) {
                cal_unit = 1;
            } else {
                throw new BuildException("Unknown unit: " + this.unit);
            }
            int count = 0;
            while (before.before(after)) {
                before.add(cal_unit, 1);
                ++count;
            }
            return count == this.value;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
    }
}

