/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.StringCharacterIterator;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.LineTokenizer;

public class FileUtils {
    private static final FileUtils PRIMARY_INSTANCE = new FileUtils();
    private static Random rand = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
    private static boolean onNetWare = Os.isFamily("netware");
    private static boolean onDos = Os.isFamily("dos");
    private static final int BUF_SIZE = 8192;
    private static boolean[] isSpecial = new boolean[256];
    private static char[] escapedChar1 = new char[256];
    private static char[] escapedChar2 = new char[256];
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    public static final long UNIX_FILE_TIMESTAMP_GRANULARITY = 1000L;

    public static FileUtils newFileUtils() {
        return new FileUtils();
    }

    public static FileUtils getFileUtils() {
        return PRIMARY_INSTANCE;
    }

    protected FileUtils() {
    }

    public URL getFileURL(File file) throws MalformedURLException {
        return new URL(this.toURI(file.getAbsolutePath()));
    }

    public void copyFile(String sourceFile, String destFile) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), null, false, false);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, false, false);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, boolean overwrite) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, overwrite, false);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, overwrite, preserveLastModified);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified, String encoding) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, overwrite, preserveLastModified, encoding);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String encoding, Project project) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, filterChains, overwrite, preserveLastModified, encoding, project);
    }

    public void copyFile(String sourceFile, String destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String inputEncoding, String outputEncoding, Project project) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), filters, filterChains, overwrite, preserveLastModified, inputEncoding, outputEncoding, project);
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        this.copyFile(sourceFile, destFile, null, false, false);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters) throws IOException {
        this.copyFile(sourceFile, destFile, filters, false, false);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, boolean overwrite) throws IOException {
        this.copyFile(sourceFile, destFile, filters, overwrite, false);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.copyFile(sourceFile, destFile, filters, overwrite, preserveLastModified, null);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, boolean overwrite, boolean preserveLastModified, String encoding) throws IOException {
        this.copyFile(sourceFile, destFile, filters, null, overwrite, preserveLastModified, encoding, null);
    }

    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String encoding, Project project) throws IOException {
        this.copyFile(sourceFile, destFile, filters, filterChains, overwrite, preserveLastModified, encoding, encoding, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(File sourceFile, File destFile, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String inputEncoding, String outputEncoding, Project project) throws IOException {
        if (overwrite || !destFile.exists() || destFile.lastModified() < sourceFile.lastModified()) {
            block23: {
                boolean filterChainsAvailable;
                File parent;
                if (destFile.exists() && destFile.isFile()) {
                    destFile.delete();
                }
                if ((parent = destFile.getParentFile()) != null && !parent.exists()) {
                    parent.mkdirs();
                }
                boolean filterSetsAvailable = filters != null && filters.hasFilters();
                boolean bl = filterChainsAvailable = filterChains != null && filterChains.size() > 0;
                if (filterSetsAvailable) {
                    BufferedReader in = null;
                    BufferedWriter out = null;
                    try {
                        if (inputEncoding == null) {
                            in = new BufferedReader(new FileReader(sourceFile));
                        } else {
                            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(sourceFile), inputEncoding);
                            in = new BufferedReader(isr);
                        }
                        if (outputEncoding == null) {
                            out = new BufferedWriter(new FileWriter(destFile));
                        } else {
                            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), outputEncoding);
                            out = new BufferedWriter(osw);
                        }
                        if (filterChainsAvailable) {
                            ChainReaderHelper crh = new ChainReaderHelper();
                            crh.setBufferSize(8192);
                            crh.setPrimaryReader(in);
                            crh.setFilterChains(filterChains);
                            crh.setProject(project);
                            Reader rdr = crh.getAssembledReader();
                            in = new BufferedReader(rdr);
                        }
                        LineTokenizer lineTokenizer = new LineTokenizer();
                        lineTokenizer.setIncludeDelims(true);
                        String newline = null;
                        String line = lineTokenizer.getToken(in);
                        while (line != null) {
                            if (line.length() == 0) {
                                out.newLine();
                            } else {
                                newline = filters.replaceTokens(line);
                                out.write(newline);
                            }
                            line = lineTokenizer.getToken(in);
                        }
                        Object var19_27 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_28 = null;
                        FileUtils.close(out);
                        FileUtils.close(in);
                        throw throwable;
                    }
                    FileUtils.close(out);
                    FileUtils.close(in);
                    {
                        break block23;
                    }
                }
                if (filterChainsAvailable || inputEncoding != null && !inputEncoding.equals(outputEncoding) || inputEncoding == null && outputEncoding != null) {
                    BufferedReader in = null;
                    BufferedWriter out = null;
                    try {
                        int nRead;
                        in = inputEncoding == null ? new BufferedReader(new FileReader(sourceFile)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFile), inputEncoding));
                        out = outputEncoding == null ? new BufferedWriter(new FileWriter(destFile)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), outputEncoding));
                        if (filterChainsAvailable) {
                            ChainReaderHelper crh = new ChainReaderHelper();
                            crh.setBufferSize(8192);
                            crh.setPrimaryReader(in);
                            crh.setFilterChains(filterChains);
                            crh.setProject(project);
                            Reader rdr = crh.getAssembledReader();
                            in = new BufferedReader(rdr);
                        }
                        char[] buffer = new char[8192];
                        while ((nRead = in.read(buffer, 0, buffer.length)) != -1) {
                            out.write(buffer, 0, nRead);
                        }
                        Object var21_30 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_31 = null;
                        FileUtils.close(out);
                        FileUtils.close(in);
                        throw throwable;
                    }
                    FileUtils.close(out);
                    FileUtils.close(in);
                    {
                        break block23;
                    }
                }
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    in = new FileInputStream(sourceFile);
                    out = new FileOutputStream(destFile);
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        out.write(buffer, 0, count);
                    } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                    Object var23_33 = null;
                }
                catch (Throwable throwable) {
                    Object var23_34 = null;
                    FileUtils.close(out);
                    FileUtils.close(in);
                    throw throwable;
                }
                FileUtils.close(out);
                FileUtils.close(in);
                {
                }
            }
            if (preserveLastModified) {
                this.setFileLastModified(destFile, sourceFile.lastModified());
            }
        }
    }

    public void setFileLastModified(File file, long time) {
        file.setLastModified(time < 0L ? System.currentTimeMillis() : time);
    }

    public File resolveFile(File file, String filename) {
        if (FileUtils.isAbsolutePath(filename = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar))) {
            return this.normalize(filename);
        }
        if (file == null) {
            return new File(filename);
        }
        File helpFile = new File(file.getAbsolutePath());
        StringTokenizer tok = new StringTokenizer(filename, File.separator);
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            if (part.equals("..")) {
                if ((helpFile = helpFile.getParentFile()) != null) continue;
                String msg = "The file or path you specified (" + filename + ") is invalid relative to " + file.getPath();
                throw new BuildException(msg);
            }
            if (part.equals(".")) continue;
            helpFile = new File(helpFile, part);
        }
        return new File(helpFile.getAbsolutePath());
    }

    public static boolean isAbsolutePath(String filename) {
        if (filename.startsWith(File.separator)) {
            return true;
        }
        if (onDos && filename.length() >= 2 && Character.isLetter(filename.charAt(0)) && filename.charAt(1) == ':') {
            return true;
        }
        return onNetWare && filename.indexOf(":") > -1;
    }

    public File normalize(String path) {
        String orig = path;
        path = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int colon = path.indexOf(":");
        if (!FileUtils.isAbsolutePath(path)) {
            String msg = path + " is not an absolute path";
            throw new BuildException(msg);
        }
        boolean dosWithDrive = false;
        String root = null;
        if (onDos && path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' || onNetWare && colon > -1) {
            dosWithDrive = true;
            char[] ca = path.replace('/', '\\').toCharArray();
            StringBuffer sbRoot = new StringBuffer();
            int i = 0;
            while (i < colon) {
                sbRoot.append(Character.toUpperCase(ca[i]));
                ++i;
            }
            sbRoot.append(':');
            if (colon + 1 < path.length()) {
                sbRoot.append(File.separatorChar);
            }
            root = sbRoot.toString();
            StringBuffer sbPath = new StringBuffer();
            int i2 = colon + 1;
            while (i2 < ca.length) {
                if (ca[i2] != '\\' || ca[i2] == '\\' && ca[i2 - 1] != '\\') {
                    sbPath.append(ca[i2]);
                }
                ++i2;
            }
            path = sbPath.toString().replace('\\', File.separatorChar);
        } else if (path.length() == 1) {
            root = File.separator;
            path = "";
        } else if (path.charAt(1) == File.separatorChar) {
            root = File.separator + File.separator;
            path = path.substring(2);
        } else {
            root = File.separator;
            path = path.substring(1);
        }
        Stack<String> s = new Stack<String>();
        s.push(root);
        StringTokenizer tok = new StringTokenizer(path, File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    throw new BuildException("Cannot resolve path " + orig);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.size()) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append(s.elementAt(i));
            ++i;
        }
        path = sb.toString();
        if (dosWithDrive) {
            path = path.replace('/', '\\');
        }
        return new File(path);
    }

    public String toVMSPath(File f) {
        String path = this.normalize(f.getAbsolutePath()).getPath();
        String name = f.getName();
        boolean isAbsolute = path.charAt(0) == File.separatorChar;
        boolean isDirectory = f.isDirectory() && !name.regionMatches(true, name.length() - 4, ".DIR", 0, 4);
        String device = null;
        StringBuffer directory = null;
        String file = null;
        int index = 0;
        if (isAbsolute) {
            index = path.indexOf(File.separatorChar, 1);
            if (index == -1) {
                return path.substring(1) + ":[000000]";
            }
            device = path.substring(1, index++);
        }
        if (isDirectory) {
            directory = new StringBuffer(path.substring(index).replace(File.separatorChar, '.'));
        } else {
            int dirEnd = path.lastIndexOf(File.separatorChar, path.length());
            if (dirEnd == -1 || dirEnd < index) {
                file = path.substring(index);
            } else {
                directory = new StringBuffer(path.substring(index, dirEnd).replace(File.separatorChar, '.'));
                index = dirEnd + 1;
                if (path.length() > index) {
                    file = path.substring(index);
                }
            }
        }
        if (!isAbsolute && directory != null) {
            directory.insert(0, '.');
        }
        String osPath = (device != null ? device + ":" : "") + (directory != null ? "[" + directory + "]" : "") + (file != null ? file : "");
        return osPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(String prefix, String suffix, File parentDir) {
        File result = null;
        String parent = parentDir == null ? System.getProperty("java.io.tmpdir") : parentDir.getPath();
        DecimalFormat fmt = new DecimalFormat("#####");
        Random random = rand;
        synchronized (random) {
            while ((result = new File(parent, prefix + fmt.format(Math.abs(rand.nextInt())) + suffix)).exists()) {
            }
        }
        return result;
    }

    public boolean contentEquals(File f1, File f2) throws IOException {
        return this.contentEquals(f1, f2, false);
    }

    public boolean contentEquals(File f1, File f2, boolean textfile) throws IOException {
        if (f1.exists() != f2.exists()) {
            return false;
        }
        if (!f1.exists()) {
            return true;
        }
        if (f1.isDirectory() || f2.isDirectory()) {
            return false;
        }
        if (this.fileNameEquals(f1, f2)) {
            return true;
        }
        return textfile ? this.textEquals(f1, f2) : this.binaryEquals(f1, f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean binaryEquals(File f1, File f2) throws IOException {
        boolean bl;
        BufferedInputStream in2;
        BufferedInputStream in1;
        block8: {
            boolean bl2;
            block6: {
                boolean bl3;
                block7: {
                    if (f1.length() != f2.length()) {
                        return false;
                    }
                    in1 = null;
                    in2 = null;
                    try {
                        in1 = new BufferedInputStream(new FileInputStream(f1));
                        in2 = new BufferedInputStream(new FileInputStream(f2));
                        int expectedByte = ((InputStream)in1).read();
                        while (true) {
                            if (expectedByte == -1) {
                                if (((InputStream)in2).read() == -1) break;
                                bl2 = false;
                                break block6;
                            }
                            if (expectedByte != ((InputStream)in2).read()) {
                                bl3 = false;
                                Object var8_9 = null;
                                break block7;
                            }
                            expectedByte = ((InputStream)in1).read();
                        }
                        bl = true;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        FileUtils.close(in1);
                        FileUtils.close(in2);
                        throw throwable;
                    }
                }
                FileUtils.close(in1);
                FileUtils.close(in2);
                return bl3;
            }
            Object var8_10 = null;
            FileUtils.close(in1);
            FileUtils.close(in2);
            return bl2;
        }
        Object var8_11 = null;
        FileUtils.close(in1);
        FileUtils.close(in2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean textEquals(File f1, File f2) throws IOException {
        boolean bl;
        BufferedReader in2;
        BufferedReader in1;
        block7: {
            boolean bl2;
            block5: {
                boolean bl3;
                block6: {
                    in1 = null;
                    in2 = null;
                    try {
                        in1 = new BufferedReader(new FileReader(f1));
                        in2 = new BufferedReader(new FileReader(f2));
                        String expected = in1.readLine();
                        while (true) {
                            if (expected == null) {
                                if (in2.readLine() == null) break;
                                bl2 = false;
                                break block5;
                            }
                            if (!expected.equals(in2.readLine())) {
                                bl3 = false;
                                Object var8_9 = null;
                                break block6;
                            }
                            expected = in1.readLine();
                        }
                        bl = true;
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        FileUtils.close(in1);
                        FileUtils.close(in2);
                        throw throwable;
                    }
                }
                FileUtils.close(in1);
                FileUtils.close(in2);
                return bl3;
            }
            Object var8_10 = null;
            FileUtils.close(in1);
            FileUtils.close(in2);
            return bl2;
        }
        Object var8_11 = null;
        FileUtils.close(in1);
        FileUtils.close(in2);
        return bl;
    }

    public File getParentFile(File f) {
        return f == null ? null : f.getParentFile();
    }

    public static final String readFully(Reader rdr) throws IOException {
        return FileUtils.readFully(rdr, 8192);
    }

    public static final String readFully(Reader rdr, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        char[] buffer = new char[bufferSize];
        int bufferLength = 0;
        StringBuffer textBuffer = null;
        while (bufferLength != -1) {
            bufferLength = rdr.read(buffer);
            if (bufferLength <= 0) continue;
            textBuffer = textBuffer == null ? new StringBuffer() : textBuffer;
            textBuffer.append(new String(buffer, 0, bufferLength));
        }
        return textBuffer == null ? null : textBuffer.toString();
    }

    public boolean createNewFile(File f) throws IOException {
        return f.createNewFile();
    }

    public boolean createNewFile(File f, boolean mkdirs) throws IOException {
        File parent = f.getParentFile();
        if (mkdirs && !parent.exists()) {
            parent.mkdirs();
        }
        return f.createNewFile();
    }

    public boolean isSymbolicLink(File parent, String name) throws IOException {
        File toTest;
        if (parent == null) {
            File f = new File(name);
            parent = f.getParentFile();
            name = f.getName();
        }
        return !(toTest = new File(parent.getCanonicalPath(), name)).getAbsolutePath().equals(toTest.getCanonicalPath());
    }

    public String removeLeadingPath(File leading, File path) {
        String p;
        String l = this.normalize(leading.getAbsolutePath()).getAbsolutePath();
        if (l.equals(p = this.normalize(path.getAbsolutePath()).getAbsolutePath())) {
            return "";
        }
        if (!l.endsWith(File.separator)) {
            l = l + File.separator;
        }
        return p.startsWith(l) ? p.substring(l.length()) : p;
    }

    public String toURI(String path) {
        boolean isDir = new File(path).isDirectory();
        StringBuffer sb = new StringBuffer("file:");
        try {
            path = this.normalize(path).getAbsolutePath();
            sb.append("//");
            if (!path.startsWith(File.separator)) {
                sb.append("/");
            }
        }
        catch (BuildException e) {
            // empty catch block
        }
        path = path.replace('\\', '/');
        StringCharacterIterator iter = new StringCharacterIterator(path);
        char c = iter.first();
        while (c != '\uffff') {
            if (c < '\u0100' && isSpecial[c]) {
                sb.append('%');
                sb.append(escapedChar1[c]);
                sb.append(escapedChar2[c]);
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        if (isDir && !path.endsWith("/")) {
            sb.append('/');
        }
        return sb.toString();
    }

    public String fromURI(String uri) {
        String path = Locator.fromURI(uri);
        try {
            path = this.normalize(path).getAbsolutePath();
        }
        catch (BuildException e) {}
        return path;
    }

    public boolean fileNameEquals(File f1, File f2) {
        return this.normalize(f1.getAbsolutePath()).equals(this.normalize(f2.getAbsolutePath()));
    }

    public void rename(File from, File to) throws IOException {
        if (to.exists() && !to.delete()) {
            throw new IOException("Failed to delete " + to + " while trying to rename " + from);
        }
        File parent = to.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory " + parent + " while trying to rename " + from);
        }
        if (!from.renameTo(to)) {
            this.copyFile(from, to);
            if (!from.delete()) {
                throw new IOException("Failed to delete " + from + " while trying to rename it.");
            }
        }
    }

    public long getFileTimestampGranularity() {
        return onDos ? 2000L : 1000L;
    }

    public boolean isUpToDate(File source, File dest, long granularity) {
        if (!dest.exists()) {
            return false;
        }
        long sourceTime = source.lastModified();
        long destTime = dest.lastModified();
        return this.isUpToDate(sourceTime, destTime, granularity);
    }

    public boolean isUpToDate(File source, File dest) {
        return this.isUpToDate(source, dest, this.getFileTimestampGranularity());
    }

    public boolean isUpToDate(long sourceTime, long destTime, long granularity) {
        if (destTime == -1L) {
            return false;
        }
        return destTime >= sourceTime + granularity;
    }

    public boolean isUpToDate(long sourceTime, long destTime) {
        return this.isUpToDate(sourceTime, destTime, this.getFileTimestampGranularity());
    }

    public static void close(Writer device) {
        block2: {
            if (device == null) break block2;
            try {
                device.close();
            }
            catch (IOException ioex) {}
        }
    }

    public static void close(Reader device) {
        block2: {
            if (device == null) break block2;
            try {
                device.close();
            }
            catch (IOException ioex) {}
        }
    }

    public static void close(OutputStream device) {
        block2: {
            if (device == null) break block2;
            try {
                device.close();
            }
            catch (IOException ioex) {}
        }
    }

    public static void close(InputStream device) {
        block2: {
            if (device == null) break block2;
            try {
                device.close();
            }
            catch (IOException ioex) {}
        }
    }

    public static void delete(File file) {
        if (file != null) {
            file.delete();
        }
    }

    static {
        int i = 0;
        while (i <= 32) {
            FileUtils.isSpecial[i] = true;
            FileUtils.escapedChar1[i] = Character.forDigit(i >> 4, 16);
            FileUtils.escapedChar2[i] = Character.forDigit(i & 0xF, 16);
            ++i;
        }
        FileUtils.isSpecial[127] = true;
        FileUtils.escapedChar1[127] = 55;
        FileUtils.escapedChar2[127] = 70;
        char[] escChs = new char[]{'<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int len = escChs.length;
        int i2 = 0;
        while (i2 < len) {
            char ch = escChs[i2];
            FileUtils.isSpecial[ch] = true;
            FileUtils.escapedChar1[ch] = Character.forDigit(ch >> 4, 16);
            FileUtils.escapedChar2[ch] = Character.forDigit(ch & 0xF, 16);
            ++i2;
        }
    }
}

