/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Base64 {
    static Log log;
    public static final int BASE64DEFAULTLENGTH = 76;
    static int _base64length;
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final boolean fDebug = false;
    private static final byte[] base64Alphabet;
    private static final char[] lookUpBase64Alphabet;
    static /* synthetic */ Class class$org$apache$xml$security$utils$Base64;

    private Base64() {
    }

    static byte[] getBytes(BigInteger bigInteger, int n) {
        if ((n = n + 7 >> 3 << 3) < bigInteger.bitLength()) {
            throw new IllegalArgumentException(I18n.translate("utils.Base64.IllegalBitlength"));
        }
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }

    public static String encode(BigInteger bigInteger) {
        return Base64.encode(Base64.getBytes(bigInteger, bigInteger.bitLength()));
    }

    public static byte[] encode(BigInteger bigInteger, int n) {
        if ((n = n + 7 >> 3 << 3) < bigInteger.bitLength()) {
            throw new IllegalArgumentException(I18n.translate("utils.Base64.IllegalBitlength"));
        }
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }

    public static BigInteger decodeBigIntegerFromElement(Element element) throws Base64DecodingException {
        return new BigInteger(1, Base64.decode(element));
    }

    public static BigInteger decodeBigIntegerFromText(Text text) throws Base64DecodingException {
        return new BigInteger(1, Base64.decode(text.getData()));
    }

    public static void fillElementWithBigInteger(Element element, BigInteger bigInteger) {
        String string = Base64.encode(bigInteger);
        if (string.length() > 76) {
            string = "\n" + string + "\n";
        }
        Document document = element.getOwnerDocument();
        Text text = document.createTextNode(string);
        element.appendChild(text);
    }

    public static byte[] decode(Element element) throws Base64DecodingException {
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            Text text = (Text)node;
            stringBuffer.append(text.getData());
        }
        return Base64.decode(stringBuffer.toString());
    }

    public static Element encodeToElement(Document document, String string, byte[] byArray) {
        Element element = XMLUtils.createElementInSignatureSpace(document, string);
        Text text = document.createTextNode(Base64.encode(byArray));
        element.appendChild(text);
        return element;
    }

    public static byte[] decode(byte[] byArray) throws Base64DecodingException {
        return Base64.decodeInternal(byArray);
    }

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray, 76);
    }

    public static byte[] decode(BufferedReader bufferedReader) throws IOException, Base64DecodingException {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (null != (string = bufferedReader.readLine())) {
            byte[] byArray = Base64.decode(string);
            byteArrayOutputStream.write(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        String string = "<container><base64 value=\"Should be 'Hallo'\">SGFsbG8=</base64></container>";
        InputSource inputSource = new InputSource(new StringReader(string));
        Document document = documentBuilder.parse(inputSource);
        Element element = (Element)document.getDocumentElement().getChildNodes().item(0);
        System.out.println(new String(Base64.decode(element)));
    }

    protected static final boolean isWhiteSpace(byte by) {
        return by == 32 || by == 13 || by == 10 || by == 9;
    }

    protected static final boolean isPad(byte by) {
        return by == 61;
    }

    protected static final boolean isData(byte by) {
        return base64Alphabet[by] != -1;
    }

    public static String encode(byte[] byArray, int n) {
        byte by;
        int n2;
        int n3;
        if (n < 4) {
            n = Integer.MAX_VALUE;
        }
        if (byArray == null) {
            return null;
        }
        int n4 = byArray.length * 8;
        if (n4 == 0) {
            return "";
        }
        int n5 = n4 % 24;
        int n6 = n4 / 24;
        int n7 = n5 != 0 ? n6 + 1 : n6;
        int n8 = n / 4;
        int n9 = (n7 - 1) / n8;
        char[] cArray = null;
        cArray = new char[n7 * 4 + n9];
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (n3 = 0; n3 < n9; ++n3) {
            for (n2 = 0; n2 < 19; ++n2) {
                by4 = byArray[n11++];
                by5 = byArray[n11++];
                by6 = byArray[n11++];
                by3 = (byte)(by5 & 0xF);
                by2 = (byte)(by4 & 3);
                by = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
                byte by7 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
                byte by8 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 6) : (byte)(by6 >> 6 ^ 0xFC);
                cArray[n10++] = lookUpBase64Alphabet[by];
                cArray[n10++] = lookUpBase64Alphabet[by7 | by2 << 4];
                cArray[n10++] = lookUpBase64Alphabet[by3 << 2 | by8];
                cArray[n10++] = lookUpBase64Alphabet[by6 & 0x3F];
                ++n12;
            }
            cArray[n10++] = 10;
        }
        while (n12 < n6) {
            by4 = byArray[n11++];
            by5 = byArray[n11++];
            by6 = byArray[n11++];
            by3 = (byte)(by5 & 0xF);
            by2 = (byte)(by4 & 3);
            n3 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 6) : (byte)(by6 >> 6 ^ 0xFC);
            cArray[n10++] = lookUpBase64Alphabet[n3];
            cArray[n10++] = lookUpBase64Alphabet[n2 | by2 << 4];
            cArray[n10++] = lookUpBase64Alphabet[by3 << 2 | by];
            cArray[n10++] = lookUpBase64Alphabet[by6 & 0x3F];
            ++n12;
        }
        if (n5 == 8) {
            by4 = byArray[n11];
            by2 = (byte)(by4 & 3);
            n3 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            cArray[n10++] = lookUpBase64Alphabet[n3];
            cArray[n10++] = lookUpBase64Alphabet[by2 << 4];
            cArray[n10++] = 61;
            cArray[n10++] = 61;
        } else if (n5 == 16) {
            by4 = byArray[n11];
            by5 = byArray[n11 + 1];
            by3 = (byte)(by5 & 0xF);
            by2 = (byte)(by4 & 3);
            n3 = (by4 & 0xFFFFFF80) == 0 ? (byte)(by4 >> 2) : (byte)(by4 >> 2 ^ 0xC0);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 4) : (byte)(by5 >> 4 ^ 0xF0);
            cArray[n10++] = lookUpBase64Alphabet[n3];
            cArray[n10++] = lookUpBase64Alphabet[n2 | by2 << 4];
            cArray[n10++] = lookUpBase64Alphabet[by3 << 2];
            cArray[n10++] = 61;
        }
        return new String(cArray);
    }

    public static final byte[] decode(String string) throws Base64DecodingException {
        if (string == null) {
            return null;
        }
        return Base64.decodeInternal(string.getBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final byte[] decodeInternal(byte[] byArray) throws Base64DecodingException {
        int n = Base64.removeWhiteSpace(byArray);
        if (n % 4 != 0) {
            throw new Base64DecodingException("It should be dived by four");
        }
        int n2 = n / 4;
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray2 = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n5 = (n2 - 1) * 4;
        n4 = (n2 - 1) * 3;
        if (!Base64.isData(by5 = byArray[n5++]) || !Base64.isData(by6 = byArray[n5++])) {
            throw new Base64DecodingException("decoding.general");
        }
        by = base64Alphabet[by5];
        by2 = base64Alphabet[by6];
        by7 = byArray[n5++];
        by8 = byArray[n5++];
        if (!Base64.isData(by7) || !Base64.isData(by8)) {
            if (Base64.isPad(by7) && Base64.isPad(by8)) {
                if ((by2 & 0xF) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                byArray2 = new byte[n4 + 1];
                byArray2[n4] = (byte)(by << 2 | by2 >> 4);
            } else {
                if (Base64.isPad(by7) || !Base64.isPad(by8)) throw new Base64DecodingException("decoding.general");
                by3 = base64Alphabet[by7];
                if ((by3 & 3) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                byArray2 = new byte[n4 + 2];
                byArray2[n4++] = (byte)(by << 2 | by2 >> 4);
                byArray2[n4] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            }
        } else {
            byArray2 = new byte[n4 + 3];
            by3 = base64Alphabet[by7];
            by4 = base64Alphabet[by8];
            byArray2[n4++] = (byte)(by << 2 | by2 >> 4);
            byArray2[n4++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray2[n4++] = (byte)(by3 << 6 | by4);
        }
        n4 = 0;
        n5 = 0;
        while (n3 < n2 - 1) {
            if (!(Base64.isData(by5 = byArray[n5++]) && Base64.isData(by6 = byArray[n5++]) && Base64.isData(by7 = byArray[n5++]) && Base64.isData(by8 = byArray[n5++]))) {
                throw new Base64DecodingException("decoding.general");
            }
            by = base64Alphabet[by5];
            by2 = base64Alphabet[by6];
            by3 = base64Alphabet[by7];
            by4 = base64Alphabet[by8];
            byArray2[n4++] = (byte)(by << 2 | by2 >> 4);
            byArray2[n4++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray2[n4++] = (byte)(by3 << 6 | by4);
            ++n3;
        }
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void decode(byte[] byArray, OutputStream outputStream) throws Base64DecodingException, IOException {
        int n = Base64.removeWhiteSpace(byArray);
        if (n % 4 != 0) {
            throw new Base64DecodingException("It should be dived by four");
        }
        int n2 = n / 4;
        if (n2 == 0) {
            return;
        }
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        int n3 = 0;
        for (int i = 0; i < n2 - 1; ++i) {
            if (!(Base64.isData(by5 = byArray[n3++]) && Base64.isData(by6 = byArray[n3++]) && Base64.isData(by7 = byArray[n3++]) && Base64.isData(by8 = byArray[n3++]))) {
                throw new Base64DecodingException("decoding.general");
            }
            by = base64Alphabet[by5];
            by2 = base64Alphabet[by6];
            by3 = base64Alphabet[by7];
            by4 = base64Alphabet[by8];
            outputStream.write((byte)(by << 2 | by2 >> 4));
            outputStream.write((byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF));
            outputStream.write((byte)(by3 << 6 | by4));
        }
        if (!Base64.isData(by5 = byArray[n3++]) || !Base64.isData(by6 = byArray[n3++])) {
            throw new Base64DecodingException("decoding.general");
        }
        by = base64Alphabet[by5];
        by2 = base64Alphabet[by6];
        by7 = byArray[n3++];
        by8 = byArray[n3++];
        if (!Base64.isData(by7) || !Base64.isData(by8)) {
            if (Base64.isPad(by7) && Base64.isPad(by8)) {
                if ((by2 & 0xF) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by << 2 | by2 >> 4));
                return;
            } else {
                if (Base64.isPad(by7) || !Base64.isPad(by8)) throw new Base64DecodingException("decoding.general");
                by3 = base64Alphabet[by7];
                if ((by3 & 3) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by << 2 | by2 >> 4));
                outputStream.write((byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF));
            }
            return;
        } else {
            by3 = base64Alphabet[by7];
            by4 = base64Alphabet[by8];
            outputStream.write((byte)(by << 2 | by2 >> 4));
            outputStream.write((byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF));
            outputStream.write((byte)(by3 << 6 | by4));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void decode(InputStream inputStream, OutputStream outputStream) throws Base64DecodingException, IOException {
        byte by;
        int n;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        int n2 = 0;
        byte[] byArray = new byte[4];
        while ((n = inputStream.read()) > 0) {
            by = (byte)n;
            if (Base64.isWhiteSpace(by)) continue;
            if (Base64.isPad(by)) {
                byArray[n2++] = by;
                if (n2 != 3) break;
                byArray[n2++] = (byte)inputStream.read();
                break;
            }
            if (!Base64.isData(by)) {
                throw new Base64DecodingException("decoding.general");
            }
            byArray[n2++] = by;
            if (n2 != 4) continue;
            n2 = 0;
            by2 = base64Alphabet[byArray[0]];
            by3 = base64Alphabet[byArray[1]];
            by4 = base64Alphabet[byArray[2]];
            by5 = base64Alphabet[byArray[3]];
            outputStream.write((byte)(by2 << 2 | by3 >> 4));
            outputStream.write((byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF));
            outputStream.write((byte)(by4 << 6 | by5));
        }
        by = byArray[0];
        byte by6 = byArray[1];
        byte by7 = byArray[2];
        byte by8 = byArray[3];
        by2 = base64Alphabet[by];
        by3 = base64Alphabet[by6];
        if (!Base64.isData(by7) || !Base64.isData(by8)) {
            if (Base64.isPad(by7) && Base64.isPad(by8)) {
                if ((by3 & 0xF) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by2 << 2 | by3 >> 4));
                return;
            } else {
                if (Base64.isPad(by7) || !Base64.isPad(by8)) throw new Base64DecodingException("decoding.general");
                by4 = base64Alphabet[by7];
                if ((by4 & 3) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by2 << 2 | by3 >> 4));
                outputStream.write((byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF));
            }
            return;
        } else {
            by4 = base64Alphabet[by7];
            by5 = base64Alphabet[by8];
            outputStream.write((byte)(by2 << 2 | by3 >> 4));
            outputStream.write((byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF));
            outputStream.write((byte)(by4 << 6 | by5));
        }
    }

    protected static int removeWhiteSpace(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[i];
            if (Base64.isWhiteSpace(by)) continue;
            byArray[n++] = by;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n;
        log = LogFactory.getLog((class$org$apache$xml$security$utils$Base64 == null ? (class$org$apache$xml$security$utils$Base64 = Base64.class$("org.apache.xml.security.utils.Base64")) : class$org$apache$xml$security$utils$Base64).getName());
        _base64length = 76;
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new char[64];
        for (n = 0; n < 255; ++n) {
            Base64.base64Alphabet[n] = -1;
        }
        for (n = 90; n >= 65; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 65);
        }
        for (n = 122; n >= 97; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 97 + 26);
        }
        for (n = 57; n >= 48; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (n = 0; n <= 25; ++n) {
            Base64.lookUpBase64Alphabet[n] = (char)(65 + n);
        }
        n = 26;
        int n2 = 0;
        while (n <= 51) {
            Base64.lookUpBase64Alphabet[n] = (char)(97 + n2);
            ++n;
            ++n2;
        }
        n = 52;
        n2 = 0;
        while (n <= 61) {
            Base64.lookUpBase64Alphabet[n] = (char)(48 + n2);
            ++n;
            ++n2;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

