/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import org.globus.common.Version;

public class GassServer {
    private static final String message = "\nSyntax: java GassServer [options]\n        java GassServer -version\n        java GassServer -help\n\n\tOptions\n\t-help | -usage\n\t\tDisplays usage\n\t-s | -silent\n\t\tEnable silent mode (Don't output server URL)\n\t-r | -read\n\t\tEnable read access to the local file system\n \t-w | -write\n\t\tEnable write access to the local file system\n \t-o\n\t\tEnable stdout redirection\n\t-e\n\t\tEnable stderr redirection\n\t-c | -client-shutdown\n\t\tAllow client to trigger shutdown the GASS server\n\t\tSee globus-gass-server-shutdown\n\t-p <port> | -port <port>\n\t\tStart the GASS server using the specified port\n\t-i | -insecure\n\t\tStart the GASS server without security\n\t-n <options>\n\t\tDisable <options>, which is a string consisting \n\t\tof one or many of the letters \"crwoe\"\n\n";

    public static void main(String[] args) {
        block19: {
            int port = 0;
            boolean secure = true;
            boolean debug = false;
            boolean error = false;
            boolean silent = false;
            int options = 120;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-p") || args[i].equalsIgnoreCase("-port")) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-i") || args[i].equalsIgnoreCase("-insecure")) {
                    secure = false;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-s") || args[i].equalsIgnoreCase("-silent")) {
                    silent = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-d") || args[i].equalsIgnoreCase("-debug")) {
                    debug = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-c") || args[i].equalsIgnoreCase("-client-shutdown")) {
                    options |= 0x80;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-r") || args[i].equalsIgnoreCase("-read")) {
                    options |= 8;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-w") || args[i].equalsIgnoreCase("-write")) {
                    options |= 0x10;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-o")) {
                    options |= 0x20;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-e")) {
                    options |= 0x40;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-version")) {
                    System.err.println(Version.getVersion());
                    System.exit(1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-n")) {
                    int op;
                    if ((op = GassServer.setOptions(options, args[++i])) == -1) {
                        error = true;
                        break;
                    }
                    options = op;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                    System.out.println(message);
                    System.exit(0);
                    continue;
                }
                System.err.println("\nError: unreconginzed argument " + i + " : " + args[i]);
                error = true;
                break;
            }
            if (error) {
                System.err.println("\nSyntax: java GassServer [-help][-{s,r,w,c,o,e}][-p port]");
                System.err.println("\nUse -help to display full usage.");
                System.exit(1);
                System.exit(1);
            }
            try {
                org.globus.io.gass.server.GassServer s = new org.globus.io.gass.server.GassServer(secure, port);
                s.setOptions(options);
                if (debug) {
                    GassServer.displayOptions(s.getOptions());
                }
                if (!silent) {
                    System.out.println(s.getURL());
                }
            }
            catch (Exception e) {
                System.err.println("Unable to start GASS Server: " + e.getMessage());
                if (!debug) break block19;
                e.printStackTrace();
            }
        }
    }

    private static int setOptions(int options, String arg) {
        int size = arg.length();
        block7: for (int i = 0; i < size; ++i) {
            switch (arg.charAt(i)) {
                case 'r': {
                    options &= 0xFFFFFFF7;
                    continue block7;
                }
                case 'w': {
                    options &= 0xFFFFFFEF;
                    continue block7;
                }
                case 'o': {
                    options &= 0xFFFFFFDF;
                    continue block7;
                }
                case 'e': {
                    options &= 0xFFFFFFBF;
                    continue block7;
                }
                case 'c': {
                    options &= 0xFFFFFF7F;
                    continue block7;
                }
                default: {
                    System.err.println("Option unrecognized: " + arg.charAt(i));
                    return -1;
                }
            }
        }
        return options;
    }

    private static void displayOptions(int options) {
        System.out.println("GASS Options:");
        System.out.println("read     : " + GassServer.isEnabled(options, 8));
        System.out.println("write    : " + GassServer.isEnabled(options, 16));
        System.out.println("stdout   : " + GassServer.isEnabled(options, 32));
        System.out.println("stderr   : " + GassServer.isEnabled(options, 64));
        System.out.println("shutdown : " + GassServer.isEnabled(options, 128));
    }

    private static String isEnabled(int options, int option) {
        return (options & option) != 0 ? "enabled" : "disabled";
    }
}

