/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import commonj.timers.Timer;
import commonj.timers.TimerListener;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceLifetime;

public class ResourceSweeper
implements TimerListener {
    protected static Log logger = LogFactory.getLog(ResourceSweeper.class.getName());
    protected Map resources;
    protected ResourceHome home;

    public ResourceSweeper(ResourceHome home, Map resources) {
        this.home = home;
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        ResourceKey key;
        logger.debug("cleaning expired resources");
        Calendar currentTime = Calendar.getInstance();
        LinkedList<ResourceKey> list = new LinkedList<ResourceKey>();
        Map map = this.resources;
        synchronized (map) {
            Iterator keyIterator = this.resources.keySet().iterator();
            while (keyIterator.hasNext()) {
                key = (ResourceKey)keyIterator.next();
                try {
                    Resource resource = this.getResource(key);
                    if (resource == null || !this.isExpired(resource, currentTime)) continue;
                    list.add(key);
                }
                catch (ResourceException e) {
                    logger.error("", e);
                }
            }
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            key = (ResourceKey)iter.next();
            try {
                this.home.remove(key);
            }
            catch (ResourceException e) {
                logger.error("", e);
            }
        }
    }

    protected Resource getResource(ResourceKey key) throws ResourceException {
        return this.home.find(key);
    }

    protected boolean isExpired(Object resource, Calendar currentTime) {
        if (!(resource instanceof ResourceLifetime)) {
            return false;
        }
        return ResourceSweeper.isExpired((ResourceLifetime)resource, currentTime);
    }

    public static boolean isExpired(Resource resource) {
        if (!(resource instanceof ResourceLifetime)) {
            return false;
        }
        return ResourceSweeper.isExpired((ResourceLifetime)((Object)resource), Calendar.getInstance());
    }

    public static boolean isExpired(ResourceLifetime resource, Calendar currentTime) {
        Calendar terminationTime = resource.getTerminationTime();
        return terminationTime != null && terminationTime.before(currentTime);
    }
}

