/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.buffer;

import gr.uoa.di.madgik.grs.buffer.QueueBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreEntry;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreReader;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreInvalidArgumentException;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreInvalidOperationException;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.FifoMultiplex;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.FirstAvailableMultiplex;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.IMultiplex;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.TimeStruct;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheManager;

public class CacheBufferStore
extends Thread
implements IBufferStore {
    private static Logger logger = Logger.getLogger(CacheBufferStore.class.getName());
    public static final IBufferStore.MultiplexType DefaultMultiplexType = IBufferStore.MultiplexType.FIFO;
    private IBufferStore.MultiplexType multiplex = DefaultMultiplexType;
    private URI[] locators = new URI[0];
    private long readerTimeout = 10L;
    private TimeUnit readerTimeoutTimeUnit = ForwardReader.DefaultIteratorTimeUnit;
    private TimeStruct inactivity = new TimeStruct(QueueBuffer.DefaultInactivityTimeout, QueueBuffer.DefaultInactivityTimeUnit);
    private boolean doneInit = false;
    private long lastActivityTime = System.currentTimeMillis();
    private final Object modifyNotification = new Object();
    private ArrayList<BufferStoreEntry> entries = null;
    private IMultiplex algo = null;
    private ArrayList<BufferStoreReader> readers = new ArrayList();
    private String key = null;
    public static CacheManager manager = new CacheManager();

    @Override
    public void associateStoreReader(BufferStoreReader reader) {
        this.readers.add(reader);
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Object getModificationObject() {
        return this.modifyNotification;
    }

    @Override
    public ArrayList<BufferStoreEntry> getEntries() {
        return this.entries;
    }

    @Override
    public IBufferStore.MultiplexType getMultiplexType() {
        return this.multiplex;
    }

    @Override
    public void setMultiplexType(IBufferStore.MultiplexType multiplex) throws GRS2BufferStoreInvalidOperationException {
        if (this.doneInit) {
            throw new GRS2BufferStoreInvalidOperationException("Already performed initialization");
        }
        this.multiplex = multiplex;
    }

    @Override
    public long getReaderTimeout() {
        return this.readerTimeout;
    }

    @Override
    public void setReaderTimeout(long timeout) {
        this.readerTimeout = timeout;
    }

    @Override
    public TimeUnit getReaderTimeoutTimeUnit() {
        return this.readerTimeoutTimeUnit;
    }

    @Override
    public void setReaderTimeoutTimeUnit(TimeUnit unit) {
        this.readerTimeoutTimeUnit = unit;
    }

    @Override
    public long getInactivityTimeout() {
        return this.inactivity.timeout;
    }

    @Override
    public TimeUnit getInactivityTimeUnit() {
        return this.inactivity.unit;
    }

    @Override
    public URI[] getLocators() {
        return this.locators;
    }

    @Override
    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    @Override
    public void markActivity() {
        this.lastActivityTime = System.currentTimeMillis();
    }

    @Override
    public void setLocators(URI[] locators) throws GRS2BufferStoreInvalidOperationException {
        if (this.doneInit) {
            throw new GRS2BufferStoreInvalidOperationException("Already performed initialization");
        }
        this.locators = locators;
    }

    @Override
    public void initialize() throws GRS2BufferStoreInvalidOperationException {
        try {
            this.doneInit = true;
            this.entries = new ArrayList(this.locators.length);
            for (URI locator : this.locators) {
                BufferStoreEntry entry = new BufferStoreEntry(locator);
                entry.setReaderTimeout(this.readerTimeout);
                entry.setReaderTimeoutTimeUnit(this.readerTimeoutTimeUnit);
                entry.initialize();
                this.entries.add(entry);
            }
            for (BufferStoreEntry entry : this.entries) {
                TimeStruct str = new TimeStruct(entry.getReaderTimeout(), entry.getReaderTimeoutTimeUnit());
                if (this.inactivity.compareTo(str) <= 0) continue;
                this.inactivity = str;
            }
        }
        catch (Exception ex) {
            this.dispose();
            throw new GRS2BufferStoreInvalidOperationException("Could not initialize provided readers", ex);
        }
    }

    @Override
    public void store() {
        this.setName("File buffer store");
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void dispose() {
        this.locators = null;
        for (BufferStoreReader reader : this.readers) {
            try {
                reader.dispose();
            }
            catch (Exception ex) {}
        }
        this.readers.clear();
        this.readers = null;
        if (this.algo != null) {
            try {
                this.algo.dispose();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.algo = null;
        for (BufferStoreEntry entry : this.entries) {
            try {
                entry.dispose();
            }
            catch (Exception exception) {}
        }
        this.entries.clear();
        this.entries = null;
    }

    @Override
    public void run() {
        block6: {
            try {
                switch (this.multiplex) {
                    case FIFO: {
                        this.algo = new FifoMultiplex();
                        break;
                    }
                    case FirstAvailable: {
                        this.algo = new FirstAvailableMultiplex();
                        break;
                    }
                    default: {
                        throw new GRS2BufferStoreInvalidArgumentException("non recognizable multiplexing value " + this.multiplex.toString());
                    }
                }
                this.algo.setEntries(this.entries);
                this.algo.setBufferStore(this);
                this.algo.setModificationNotify(this.modifyNotification);
                this.algo.multiplex();
            }
            catch (Exception ex) {
                this.dispose();
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, "Could not complete buffer storing. Disposing", ex);
            }
        }
    }
}

