/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.proxies;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.core.utils.proxies.GCUBEProxyContext;

public class AccessControlProxyContext
extends GCUBEProxyContext<Restricted> {
    @Override
    public MethodInterceptor getInterceptor(final Object proxied) {
        final GCUBELog logger = new GCUBELog(this);
        return new MethodInterceptor(){

            public Object intercept(Object proxy, Method method, Object[] input, MethodProxy methodProxy) throws Throwable {
                Restricted allow = (Restricted)AccessControlProxyContext.this.getAnnotation();
                StackTraceElement caller = AccessControlProxyContext.this.getProxyCaller();
                boolean allowed = false;
                for (String allowable : allow.value()) {
                    if (!caller.getClassName().startsWith(allowable)) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    logger.warn("illegal access attempt to " + method + " from " + caller.getClassName());
                    throw new IllegalAccessError("Access to " + method + " is forbidden from " + caller.getClassName());
                }
                return methodProxy.invoke(proxied, input);
            }
        };
    }

    @Override
    public Class<Restricted> getAnnotationClass() {
        return Restricted.class;
    }

    public static void validateCall() {
        GCUBELog logger = new GCUBELog(AccessControlProxyContext.class);
        StackTraceElement[] stack = new Throwable().getStackTrace();
        boolean allowed = false;
        AccessibleObject clientMethod = null;
        try {
            Method[] methods;
            Class<?> clientClass = Thread.currentThread().getContextClassLoader().loadClass(stack[1].getClassName());
            for (Method method : methods = clientClass.getDeclaredMethods()) {
                if (method.getName() != stack[1].getMethodName()) continue;
                clientMethod = method;
            }
            if (!clientMethod.isAnnotationPresent(Restricted.class)) {
                return;
            }
            Restricted restricted = ((Method)clientMethod).getAnnotation(Restricted.class);
            for (String allowable : restricted.value()) {
                if (!stack[2].getClassName().startsWith(allowable)) continue;
                allowed = true;
                break;
            }
        }
        catch (Exception e) {
            logger.warn("Could not validate call", e);
            return;
        }
        if (!allowed) {
            new GCUBELog(AccessControlProxyContext.class).warn("illegal access attempt to " + stack[1] + " from " + stack[2]);
            throw new IllegalAccessError("Access forbidden");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Restricted {
        public static final String GCORE = "org.gcube.common";

        public String[] value() default {"org.gcube.common"};
    }
}

