/*
 * Decompiled with CFR 0.152.
 */
package org.globus.usage.packets;

public class CustomByteBuffer {
    private int maxSize;
    private int bytesUsed;
    private int pointer;
    private byte[] internalArray;
    private static final int LONG_SIZE = 8;
    private static final int INT_SIZE = 4;
    private static final int SHORT_SIZE = 2;

    public CustomByteBuffer(int maxSize) {
        this.internalArray = new byte[maxSize];
        this.maxSize = maxSize;
        this.bytesUsed = 0;
        this.pointer = 0;
    }

    private CustomByteBuffer() {
    }

    public static CustomByteBuffer fitToData(byte[] existingArray, int size) {
        CustomByteBuffer newBuf = new CustomByteBuffer(size);
        System.arraycopy(existingArray, 0, newBuf.internalArray, 0, size);
        newBuf.bytesUsed = size;
        return newBuf;
    }

    public static CustomByteBuffer wrap(byte[] existingArray) {
        CustomByteBuffer newByteBuffer = new CustomByteBuffer();
        newByteBuffer.internalArray = existingArray;
        newByteBuffer.maxSize = newByteBuffer.bytesUsed = existingArray.length;
        newByteBuffer.pointer = 0;
        return newByteBuffer;
    }

    public void shrink() {
        byte[] smallerArray = new byte[this.bytesUsed];
        System.arraycopy(this.internalArray, 0, smallerArray, 0, this.bytesUsed);
        this.internalArray = smallerArray;
        this.maxSize = this.internalArray.length;
    }

    public int limit() {
        return this.maxSize;
    }

    public int position() {
        return this.pointer;
    }

    public int remaining() {
        return this.maxSize - this.pointer;
    }

    public byte[] array() {
        this.shrink();
        return this.internalArray;
    }

    public void rewind() {
        this.pointer = 0;
    }

    public byte get() {
        byte nextByte = this.internalArray[this.pointer];
        ++this.pointer;
        return nextByte;
    }

    public void get(byte[] dataGoesHere) {
        this.get(dataGoesHere, 0, dataGoesHere.length);
    }

    public void get(byte[] dataGoesHere, int offset, int numBytes) {
        System.arraycopy(this.internalArray, this.pointer, dataGoesHere, offset, numBytes);
        this.pointer += numBytes;
    }

    public void getBytes(byte[] dataGoesHere) {
        this.get(dataGoesHere, 0, dataGoesHere.length);
    }

    public byte[] getRemainingBytes() {
        int remaining = this.remaining();
        byte[] remainingBytes = new byte[remaining];
        this.get(remainingBytes, 0, remaining);
        return remainingBytes;
    }

    public String getUntilZeroOrOne(int maxBytes) {
        char c;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < maxBytes && (c = (char)this.internalArray[this.pointer]) > '\u0001'; ++i) {
            buf.append(c);
            ++this.pointer;
        }
        return buf.toString();
    }

    public long getLong() {
        long out = 0L;
        for (int i = 7; i >= 0; --i) {
            out <<= 8;
            out |= (long)(this.internalArray[this.pointer + i] & 0xFF);
        }
        this.pointer += 8;
        return out;
    }

    public int getInt() {
        int out = 0;
        for (int i = 3; i >= 0; --i) {
            out <<= 8;
            out |= this.internalArray[this.pointer + i] & 0xFF;
        }
        this.pointer += 4;
        return out;
    }

    public int getIntBigEndian() {
        int out = 0;
        for (int i = 0; i < 4; ++i) {
            out <<= 8;
            out |= this.internalArray[this.pointer + i] & 0xFF;
        }
        this.pointer += 4;
        return out;
    }

    public short getShort() {
        short out = 0;
        for (int i = 1; i >= 0; --i) {
            out = (short)(out << 8);
            out = (short)(out | this.internalArray[this.pointer + i] & 0xFF);
        }
        this.pointer += 2;
        return out;
    }

    public void put(byte datum) {
        this.internalArray[this.pointer] = datum;
        ++this.pointer;
        if (this.pointer > this.bytesUsed) {
            this.bytesUsed = this.pointer;
        }
    }

    public void put(byte[] data) {
        this.put(data, 0, data.length);
    }

    public void put(byte[] data, int offset, int numBytes) {
        System.arraycopy(data, offset, this.internalArray, this.pointer, numBytes);
        this.pointer += numBytes;
        if (this.pointer > this.bytesUsed) {
            this.bytesUsed = this.pointer;
        }
    }

    public void putLong(long datum) {
        for (int i = 0; i < 8; ++i) {
            this.internalArray[this.pointer + i] = (byte)datum;
            datum >>= 8;
        }
        this.pointer += 8;
        if (this.pointer > this.bytesUsed) {
            this.bytesUsed = this.pointer;
        }
    }

    public void putInt(int datum) {
        for (int i = 0; i < 4; ++i) {
            this.internalArray[this.pointer + i] = (byte)datum;
            datum >>= 8;
        }
        this.pointer += 4;
        if (this.pointer > this.bytesUsed) {
            this.bytesUsed = this.pointer;
        }
    }

    public void putShort(short datum) {
        for (int i = 0; i < 2; ++i) {
            this.internalArray[this.pointer + i] = (byte)datum;
            datum = (short)(datum >> 8);
        }
        this.pointer += 2;
        if (this.pointer > this.bytesUsed) {
            this.bytesUsed = this.pointer;
        }
    }
}

