/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.reader;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.IReaderProxy;
import gr.uoa.di.madgik.grs.proxy.ProxyFactory;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorException;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderInvalidArgumentException;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.reader.RandomReaderIterator;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.store.record.GRS2RecordStoreException;
import gr.uoa.di.madgik.grs.store.record.IRecordStore;
import gr.uoa.di.madgik.grs.store.record.RecordStoreFactory;
import gr.uoa.di.madgik.grs.utils.ProgressiveTimeoutGenerator;
import java.net.URI;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;

public class RandomReader<T extends Record>
implements IRecordReader<T>,
Iterable<T> {
    public static final int DefaultIteratorTimeout = 10;
    public static final TimeUnit DefaultIteratorTimeUnit = TimeUnit.SECONDS;
    public static final int DefaultWindowSize = 1;
    private IBuffer buffer = null;
    private IReaderProxy proxy = null;
    private Object immediateNotificationObject = new Object();
    private long iteratorTimeout = 10L;
    private TimeUnit iteratorTimeUnit = ForwardReader.DefaultIteratorTimeUnit;
    private IRecordStore manager = null;
    private long lastRecordIndex = -1L;
    private long currentRecordIndex = -1L;
    private int windowSize = 1;
    private Hashtable<Long, T> window = new Hashtable();
    private long windowBeginRecordIndex = -1L;
    private long windowEndRecordIndex = -1L;

    public RandomReader(URI locator) throws GRS2ReaderException {
        try {
            this.proxy = ProxyFactory.getProxy(locator);
            this.buffer = this.proxy.getBuffer();
            this.manager = RecordStoreFactory.getManager();
            this.manager.enableOrder(false);
            this.immediateNotificationObject = this.buffer.getReaderImmediateNotificationObject();
            this.initCounters();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to initialize the reader", ex);
        }
    }

    public RandomReader(URI locator, int capacity) throws GRS2ReaderException {
        try {
            this.proxy = ProxyFactory.getProxy(locator);
            this.proxy.overrideBufferCapacity(capacity);
            this.buffer = this.proxy.getBuffer();
            this.manager = RecordStoreFactory.getManager();
            this.manager.enableOrder(false);
            this.immediateNotificationObject = this.buffer.getReaderImmediateNotificationObject();
            this.initCounters();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to initialize the reader", ex);
        }
    }

    @Override
    public RecordDefinition[] getRecordDefinitions() throws GRS2ReaderException {
        try {
            return this.buffer.getRecordDefinitions();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve the record definitions", ex);
        }
    }

    @Override
    public long getInactivityTimeout() throws GRS2ReaderException {
        try {
            return this.buffer.getInactivityTimeout();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve buffer's inactivity timeout", ex);
        }
    }

    @Override
    public TimeUnit getInactivityTimeUnit() throws GRS2ReaderException {
        try {
            return this.buffer.getInactivityTimeUnit();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve buffer's inactivity time unit", ex);
        }
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    @Override
    public void setIteratorTimeout(long iteratorTimeout) {
        this.iteratorTimeout = iteratorTimeout;
    }

    @Override
    public long getIteratorTimeout() {
        return this.iteratorTimeout;
    }

    @Override
    public void setIteratorTimeUnit(TimeUnit iteratorTimeUnit) {
        this.iteratorTimeUnit = iteratorTimeUnit;
    }

    @Override
    public TimeUnit getIteratorTimeUnit() {
        return this.iteratorTimeUnit;
    }

    @Override
    public int getCapacity() throws GRS2ReaderException {
        try {
            return this.buffer.getCapacity();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve capacity", ex);
        }
    }

    @Override
    public int getConcurrentPartialCapacity() throws GRS2ReaderException {
        try {
            return this.buffer.getConcurrentPartialCapacity();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve concurrent partial capacity", ex);
        }
    }

    @Override
    public synchronized IBuffer.Status getStatus() {
        return this.buffer.getStatus();
    }

    @Override
    public synchronized void close() throws GRS2ReaderException {
        try {
            if (this.buffer.getStatus() == IBuffer.Status.Dispose) {
                return;
            }
            this.buffer.close();
            this.buffer.dispose();
            this.manager.dispose();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to close reader", ex);
        }
    }

    @Override
    public synchronized long totalRecords() throws GRS2ReaderException {
        try {
            return this.buffer.totalRecords();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve total record count", ex);
        }
    }

    @Override
    public long currentRecord() throws GRS2ReaderException {
        if (this.currentRecordIndex == -1L) {
            throw new GRS2ReaderException("no records retrieved");
        }
        return this.currentRecordIndex;
    }

    @Override
    public synchronized int availableRecords() throws GRS2ReaderException {
        try {
            if (this.serveFromWindow()) {
                return (int)((long)this.window.size() - this.currentRecordIndex + this.windowBeginRecordIndex);
            }
            return this.buffer.availableRecords();
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve available record count", ex);
        }
    }

    @Override
    public synchronized T get() throws GRS2ReaderException {
        try {
            Record record = null;
            if (this.serveFromWindow()) {
                record = (Record)this.window.get(this.currentRecordIndex);
                if (record == null) {
                    throw new GRS2RecordStoreException("Could not locate previously stored record");
                }
                this.buffer.markSimulateActivity();
            } else {
                record = this.buffer.get();
                this.persistRecord(record);
            }
            if (record != null) {
                this.increaseCounters();
            }
            return (T)record;
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve record", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws GRS2ReaderException {
        try {
            Record item = null;
            if (this.serveFromWindow()) {
                item = (Record)this.window.get(this.currentRecordIndex);
                if (item == null) {
                    throw new GRS2RecordStoreException("Could not locate previously stored record");
                }
                this.buffer.markSimulateActivity();
            } else {
                ProgressiveTimeoutGenerator ptf = new ProgressiveTimeoutGenerator(unit.toMillis(timeout));
                while (ptf.hasNext() && this.buffer.getStatus() != IBuffer.Status.Dispose && (this.buffer.getStatus() != IBuffer.Status.Close || this.buffer.availableRecords() != 0) && (item = this.buffer.get()) == null) {
                    Object object = this.immediateNotificationObject;
                    synchronized (object) {
                        try {
                            this.immediateNotificationObject.wait(ptf.next());
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
                this.persistRecord(item);
            }
            if (item != null) {
                this.increaseCounters();
            }
            return (T)item;
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to retrieve record", ex);
        }
    }

    @Override
    public long seek(long len) throws GRS2ReaderException {
        try {
            T rec;
            if (len == 0L) {
                return 0L;
            }
            long newLen = 0L;
            long additionalRecs = 0L;
            if (len < 0L && this.currentRecordIndex + len < 0L) {
                newLen = -1L * this.currentRecordIndex;
            } else if (len > 0L && this.currentRecordIndex + len <= this.lastRecordIndex) {
                newLen = len;
            } else if (len > 0L && this.currentRecordIndex + len > this.lastRecordIndex) {
                additionalRecs = this.currentRecordIndex + len - this.lastRecordIndex;
                newLen = len = this.lastRecordIndex - this.currentRecordIndex;
            } else {
                newLen = len;
            }
            this.resetWindow(this.currentRecordIndex + newLen);
            int i = 0;
            while ((long)i < additionalRecs && (rec = this.get(this.getIteratorTimeout(), this.getIteratorTimeUnit())) != null) {
                ++newLen;
                ++i;
            }
            if (this.currentRecordIndex + newLen - additionalRecs < 0L) {
                throw new GRS2ReaderException("index out of bounds");
            }
            this.currentRecordIndex += newLen - additionalRecs;
            return newLen;
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to seek", ex);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new RandomReaderIterator(this);
    }

    public ListIterator<T> listIterator() {
        return new RandomReaderIterator(this);
    }

    @Override
    public synchronized void emit(BufferEvent event) throws GRS2ReaderException, GRS2ReaderInvalidArgumentException {
        if (event == null) {
            throw new GRS2ReaderInvalidArgumentException("event cannot be null");
        }
        try {
            event.setSource(BufferEvent.EventSource.Reader);
            this.buffer.emit(event);
        }
        catch (GRS2BufferException e) {
            throw new GRS2ReaderException("unable to emit event", e);
        }
    }

    @Override
    public synchronized BufferEvent receive() throws GRS2ReaderException {
        try {
            return this.buffer.receive(BufferEvent.EventSource.Writer);
        }
        catch (GRS2BufferException e) {
            throw new GRS2ReaderException("unable to receive event", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean waitAvailable(long timeout, TimeUnit unit) throws GRS2ReaderException {
        try {
            boolean item = false;
            if (this.serveFromWindow()) {
                item = true;
            } else {
                long expirationTime = System.currentTimeMillis() + unit.toMillis(timeout);
                while (this.buffer.getStatus() != IBuffer.Status.Dispose && (this.buffer.getStatus() != IBuffer.Status.Close || this.buffer.availableRecords() != 0)) {
                    long timeLeft;
                    if (this.buffer.availableRecords() > 0) {
                        item = true;
                    }
                    if (item || (timeLeft = expirationTime - System.currentTimeMillis()) <= 0L) break;
                    Object object = this.immediateNotificationObject;
                    synchronized (object) {
                        try {
                            this.immediateNotificationObject.wait(timeLeft);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
            return item;
        }
        catch (GRS2Exception ex) {
            throw new GRS2ReaderException("unable to seek", ex);
        }
    }

    protected synchronized boolean canCallPrevious() {
        return this.currentRecordIndex != 1L;
    }

    protected synchronized boolean canCallNext() {
        return this.currentRecordIndex < this.lastRecordIndex;
    }

    private void persistRecord(T record) throws GRS2RecordStoreException, GRS2RecordDefinitionException, GRS2ProxyMirrorException, GRS2BufferException {
        if (record == null) {
            return;
        }
        ((Record)record).makeAvailable();
        this.manager.persist((Record)record);
    }

    private T retrieveRecord(long recordIndex) throws GRS2RecordStoreException, GRS2ReaderInvalidArgumentException, GRS2RecordDefinitionException, GRS2BufferException {
        Record record = this.manager.retrieve(recordIndex, false);
        if (record == null) {
            throw new GRS2ReaderInvalidArgumentException("provided record id #" + recordIndex + " not found in persistency manager");
        }
        record.bind(this.buffer);
        return (T)record;
    }

    private void initCounters() throws GRS2BufferException {
        this.lastRecordIndex = 0L;
        this.currentRecordIndex = 0L;
        this.windowSize = this.buffer.getCapacity();
        this.windowBeginRecordIndex = -1L;
        this.windowEndRecordIndex = -1L;
    }

    private void resetWindow(long recordIndex) throws GRS2RecordDefinitionException, GRS2RecordStoreException, GRS2ReaderInvalidArgumentException, GRS2BufferException {
        if (recordIndex >= this.lastRecordIndex) {
            this.windowBeginRecordIndex = -1L;
            this.windowEndRecordIndex = -1L;
            this.window.clear();
        } else if (recordIndex < 0L) {
            this.windowBeginRecordIndex = -1L;
            this.windowEndRecordIndex = -1L;
            this.window.clear();
        } else if (this.windowBeginRecordIndex < 0L || this.windowEndRecordIndex < 0L || this.windowBeginRecordIndex > recordIndex || this.windowEndRecordIndex < recordIndex) {
            int tmpWindowSize = this.windowSize;
            if (recordIndex + (long)this.windowSize > this.lastRecordIndex) {
                tmpWindowSize = (int)(this.lastRecordIndex - recordIndex);
            }
            this.window.clear();
            for (long i = 0L; i < (long)tmpWindowSize; ++i) {
                this.window.put(recordIndex + i, this.retrieveRecord(recordIndex + i));
            }
            this.windowBeginRecordIndex = recordIndex;
            this.windowEndRecordIndex = recordIndex + (long)tmpWindowSize - 1L;
        }
    }

    private boolean serveFromWindow() {
        return this.windowBeginRecordIndex >= 0L && this.windowEndRecordIndex >= 0L && this.currentRecordIndex >= this.windowBeginRecordIndex && this.currentRecordIndex <= this.windowEndRecordIndex;
    }

    private void increaseCounters() throws GRS2RecordDefinitionException, GRS2RecordStoreException, GRS2ReaderInvalidArgumentException, GRS2BufferException {
        ++this.currentRecordIndex;
        if (this.lastRecordIndex < this.currentRecordIndex) {
            this.lastRecordIndex = this.currentRecordIndex;
        }
        if (this.windowBeginRecordIndex >= 0L && this.windowEndRecordIndex >= 0L && this.currentRecordIndex > this.windowEndRecordIndex) {
            this.resetWindow(this.currentRecordIndex);
        }
    }
}

