/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import xjava.security.Parameterized;

public class HMACOutputStream
extends OutputStream {
    private OutputStream sub;
    private MessageDigest md;

    protected void _HMACOutputStream(String digest, byte[] key, OutputStream out) {
        this.sub = out;
        try {
            this.md = MessageDigest.getInstance("HMAC-" + digest);
            ((Parameterized)this.md).setParameter("key", (Object)key);
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    public HMACOutputStream(String digest, byte[] key, OutputStream out) {
        this._HMACOutputStream(digest, key, out);
    }

    public HMACOutputStream(String digest, String key, OutputStream out) {
        try {
            this.md = MessageDigest.getInstance(digest);
            this._HMACOutputStream(digest, this.md.digest(key.getBytes()), out);
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    public void write(int b) throws IOException {
        this.md.update((byte)(0xFF & b));
        this.sub.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.md.update(b);
        this.sub.write(b);
    }

    public byte[] digest() {
        return this.md.digest();
    }
}

