/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.implementation.validations.validators;

import java.io.Serializable;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.implementation.FieldAction;

public class ValidBooleanValidator
implements FieldAction {
    private static final String ERROR = String.format("Not Instance of %s", Boolean.class.getSimpleName());

    @Override
    public Serializable validate(String key, Serializable value, Record record) throws InvalidValueException {
        if (value instanceof Boolean) {
            return value;
        }
        try {
            Boolean booleanObj;
            if (value instanceof String) {
                try {
                    booleanObj = Boolean.valueOf((String)((Object)value));
                    if (booleanObj != null) {
                        return booleanObj;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Integer integer = Integer.getInteger((String)((Object)value));
                    if (integer != null) {
                        value = integer;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (value instanceof Integer && (booleanObj = Boolean.valueOf((Integer)value != 0)) != null) {
                return booleanObj;
            }
        }
        catch (Exception e) {
            throw new InvalidValueException(ERROR, e);
        }
        throw new InvalidValueException(ERROR);
    }
}

