/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.configuration.parameter;

import gr.uoa.di.madgik.commons.configuration.parameter.IParameter;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StringParameter
implements IParameter {
    private String Name = null;
    private String Value = null;
    private boolean generated = false;
    private boolean internal = false;
    private boolean checked = false;

    @Override
    public Class<?> GetParameterClassType() {
        return String.class;
    }

    @Override
    public Boolean IsChecked() {
        return this.checked;
    }

    @Override
    public void Check() {
        this.checked = true;
    }

    @Override
    public IParameter.ParameterType GetParameterType() {
        return IParameter.ParameterType.String;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public Boolean IsGenerated() {
        return this.generated;
    }

    @Override
    public Boolean IsInternal() {
        return this.internal;
    }

    @Override
    public String GetValue() {
        return new String(this.Value);
    }

    @Override
    public void SetValue(Object Value) throws Exception {
        if (!(Value instanceof String)) {
            throw new Exception("Provided value not of expected type");
        }
        this.Value = new String((String)Value);
    }

    @Override
    public void FromXML(String xml) throws Exception {
        Document doc = XMLUtils.Deserialize(xml);
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element element) throws Exception {
        if (!XMLUtils.AttributeExists(element, "name").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        this.Name = XMLUtils.GetAttribute(element, "name");
        if (!XMLUtils.AttributeExists(element, "type").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        if (!IParameter.ParameterType.valueOf(XMLUtils.GetAttribute(element, "type")).equals((Object)this.GetParameterType())) {
            throw new Exception("Not valid serialization of parameter");
        }
        if (!XMLUtils.AttributeExists(element, "generated").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        this.generated = Boolean.getBoolean(XMLUtils.GetAttribute(element, "generated"));
        if (!XMLUtils.AttributeExists(element, "internal").booleanValue()) {
            throw new Exception("Not valid serialization of parameter");
        }
        this.internal = Boolean.getBoolean(XMLUtils.GetAttribute(element, "internal"));
        if (!this.generated) {
            this.Value = XMLUtils.GetChildText(element);
        }
    }
}

