/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.dc.ManagedSocketBox;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.SocketOperator;

public class SocketPool {
    private static Log logger = LogFactory.getLog((class$org$globus$ftp$dc$SocketPool == null ? (class$org$globus$ftp$dc$SocketPool = SocketPool.class$("org.globus.ftp.dc.SocketPool")) : class$org$globus$ftp$dc$SocketPool).getName());
    protected Hashtable allSockets = new Hashtable();
    protected Hashtable freeSockets = new Hashtable();
    protected Hashtable busySockets = new Hashtable();
    static /* synthetic */ Class class$org$globus$ftp$dc$SocketPool;

    public synchronized void add(SocketBox sb) {
        int status = ((ManagedSocketBox)sb).getStatus();
        if (this.allSockets.containsKey(sb)) {
            throw new IllegalArgumentException("This socket already exists in the socket pool.");
        }
        this.allSockets.put(sb, sb);
        if (status == 1) {
            if (this.freeSockets.containsKey(sb)) {
                throw new IllegalArgumentException("This socket already exists in the pool of free sockets.");
            }
            logger.debug("adding a free socket");
            this.freeSockets.put(sb, sb);
        } else {
            if (this.busySockets.containsKey(sb)) {
                throw new IllegalArgumentException("This socket already exists in the pool of busy sockets.");
            }
            logger.debug("adding a busy socket");
            this.busySockets.put(sb, sb);
        }
    }

    public synchronized void remove(SocketBox sb) {
        int status = ((ManagedSocketBox)sb).getStatus();
        if (!this.allSockets.containsKey(sb)) {
            throw new IllegalArgumentException("This socket does not seem to exist in the socket pool.");
        }
        this.allSockets.remove(sb);
        if (status == 1) {
            if (!this.freeSockets.containsKey(sb)) {
                throw new IllegalArgumentException("This socket is marked free, but does not exist in the pool of free sockets.");
            }
            this.freeSockets.remove(sb);
        } else {
            if (!this.busySockets.containsKey(sb)) {
                throw new IllegalArgumentException("This socket is marked busy, but does not exist in the pool of busy sockets.");
            }
            this.busySockets.remove(sb);
        }
    }

    public synchronized SocketBox checkOut() {
        Enumeration e = this.freeSockets.keys();
        if (e.hasMoreElements()) {
            SocketBox sb = (SocketBox)e.nextElement();
            if (this.busySockets.containsKey(sb)) {
                throw new IllegalArgumentException("This socket is marked free, but already exists in the pool of busy sockets.");
            }
            ((ManagedSocketBox)sb).setStatus(2);
            this.freeSockets.remove(sb);
            this.busySockets.put(sb, sb);
            return sb;
        }
        return null;
    }

    public synchronized void checkIn(SocketBox sb) {
        if (((ManagedSocketBox)sb).getStatus() != 2) {
            throw new IllegalArgumentException("The socket      is already marked free, cannot check it in twice.");
        }
        if (!this.busySockets.containsKey(sb)) {
            throw new IllegalArgumentException("This socket does not exist in the pool of busy sockets.");
        }
        if (this.freeSockets.containsKey(sb)) {
            throw new IllegalArgumentException("This socket already exists in the pool of free sockets.");
        }
        if (!((ManagedSocketBox)sb).isReusable()) {
            throw new IllegalArgumentException("This socket is not reusable; cannot check in.");
        }
        ((ManagedSocketBox)sb).setStatus(1);
        this.busySockets.remove(sb);
        this.freeSockets.put(sb, sb);
    }

    public int count() {
        return this.allSockets.size();
    }

    public int countFree() {
        return this.freeSockets.size();
    }

    public int countBusy() {
        return this.busySockets.size();
    }

    public boolean hasFree() {
        return this.countFree() > 0;
    }

    public synchronized void applyToAll(SocketOperator op) throws Exception {
        Enumeration keys = this.allSockets.keys();
        while (keys.hasMoreElements()) {
            SocketBox myBox = (SocketBox)keys.nextElement();
            op.operate(myBox);
        }
    }

    public synchronized void flush() throws IOException {
        Enumeration keys = this.allSockets.keys();
        while (keys.hasMoreElements()) {
            SocketBox myBox = (SocketBox)keys.nextElement();
            if (myBox == null) continue;
            myBox.setSocket(null);
        }
        this.allSockets.clear();
        this.freeSockets.clear();
        this.busySockets.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

