/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.securemsg;

import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authentication.signature.X509WSSignedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.ietf.jgss.GSSCredential;

public class X509SignHandler
extends GenericHandler {
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authentication.errors");
    private static Log log = LogFactory.getLog((String)X509SignHandler.class.getName());

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context, JaasSubject.getCurrentSubject());
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context, (Subject)context.getProperty("invocationSubject"));
    }

    public boolean handleMessage(SOAPMessageContext ctx, Subject subject) {
        Object tmp = ctx.getProperty("org.globus.security.secMsg.msg.type");
        if (!Constants.SIGNATURE.equals(tmp) && !Constants.ENCRYPTION.equals(tmp)) {
            log.debug((Object)("Signature not requested. " + tmp));
            return true;
        }
        SOAPMessage msg = ctx.getMessage();
        if (msg == null) {
            log.debug((Object)"No message - not signing.");
            return true;
        }
        log.debug((Object)"Enter: sign");
        SOAPMessage signedMsg = null;
        try {
            SOAPEnvelope unsignedEnvelope = msg.getSOAPPart().getEnvelope();
            GSSCredential cred = AuthUtil.getCredential((MessageContext)ctx);
            if (cred == null && subject != null) {
                log.debug((Object)"Get credentials associated with current thread");
                cred = JaasGssUtil.getCredential((Subject)subject);
            }
            X509WSSignedSOAPEnvelopeBuilder builder = new X509WSSignedSOAPEnvelopeBuilder((MessageContext)ctx, cred);
            builder.setActor((String)ctx.getProperty("x509Actor"));
            signedMsg = builder.buildMessage(unsignedEnvelope);
        }
        catch (Exception e) {
            log.error((Object)i18n.getMessage("signErr"), (Throwable)e);
            throw WSSecurityFault.makeFault(e);
        }
        ctx.setMessage(signedMsg);
        log.debug((Object)"Exit: sign");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }
}

