/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.container;

import java.io.InputStream;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.configuration.container.ContainerHandlers;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.utils.Utils;

public class ContainerConfigurationBinder {
    public ContainerConfiguration bind(InputStream stream) {
        try {
            ContainerConfiguration config;
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{ContainerConfiguration.class});
            ContainerConfiguration containerConfiguration = config = (ContainerConfiguration)ctx.createUnmarshaller().unmarshal(stream);
            return containerConfiguration;
        }
        catch (JAXBException e) {
            throw new RuntimeException("invalid container configuration", e);
        }
        finally {
            Utils.closeSafely(stream);
        }
    }

    public ContainerHandlers bindHandlers(InputStream stream) {
        Set<Class<?>> classes = this.scanForConfigurationElements();
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[0]));
            return (ContainerHandlers)ctx.createUnmarshaller().unmarshal(stream);
        }
        catch (JAXBException e) {
            throw Utils.unchecked(e);
        }
    }

    private Set<Class<?>> scanForConfigurationElements() throws RuntimeException {
        ServiceLoader<ContainerHandler> handlerLoader = ServiceLoader.load(ContainerHandler.class);
        HashSet scanned = new HashSet();
        for (ContainerHandler handler : handlerLoader) {
            Class<?> handlerClass = handler.getClass();
            if (handlerClass.isInterface() || handlerClass.getModifiers() == 1024) continue;
            scanned.add(handlerClass);
        }
        scanned.add(ContainerHandlers.class);
        return scanned;
    }
}

