/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.gcube.vomanagement.vomsapi.ExtendedVOMSAdmin;
import org.gcube.vomanagement.vomsapi.VOMSACL;
import org.gcube.vomanagement.vomsapi.VOMSAdmin;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationException;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIFactory;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIStub;
import org.glite.wsdl.services.org_glite_security_voms.User;
import org.glite.wsdl.services.org_glite_security_voms.VOMSException;
import org.glite.wsdl.services.org_glite_security_voms_service_acl.ACLEntry;

class ExtendedVOMSAdminImpl
extends VOMSAPIStub
implements ExtendedVOMSAdmin {
    static Logger logger = Logger.getLogger((String)ExtendedVOMSAdminImpl.class.getName());
    private VOMSAdmin vomsAdmin;
    private VOMSACL vomsACL;

    ExtendedVOMSAdminImpl(VOMSAdmin vomsAdmin, VOMSACL vomsACL, VOMSAPIFactory factory) {
        super(factory);
        this.vomsAdmin = vomsAdmin;
        this.vomsACL = vomsACL;
    }

    @Override
    void configureVOMSAPIStubForCall() {
    }

    @Override
    public void addOnlineCAMember(String groupName, String userName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        this.vomsAdmin.addMember(groupName, this.getDN(userName), this.getCA());
    }

    @Override
    public void assignOnlineCARole(String groupName, String roleName, String userName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        this.vomsAdmin.assignRole(groupName, roleName, this.getDN(userName), this.getCA());
    }

    @Override
    public void createOnlineCAUser(String userName, String mail) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        this.createUser(userName, this.getDN(userName), this.getCA(), mail);
    }

    @Override
    public void createUser(String CN, String DN, String CA, String mail) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        User user = new User();
        user.setCA(CA);
        user.setCN(CN);
        user.setDN(DN);
        user.setMail(mail);
        this.vomsAdmin.createUser(user);
    }

    @Override
    public void deleteOnlineCAUser(String userName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        this.vomsAdmin.deleteUser(this.getDN(userName), this.getCA());
    }

    @Override
    public void dismissOnlineCARole(String groupName, String roleName, String userName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        this.vomsAdmin.dismissRole(groupName, roleName, this.getDN(userName), this.getCA());
    }

    @Override
    public User getOnlineCAUser(String userName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        return this.vomsAdmin.getUser(this.getDN(userName), this.getCA());
    }

    @Override
    public HashMap<String, String[]> listGroupedRoles(String DN, String CA) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        String[] fqanRoles;
        HashMap groupedRoles = new HashMap();
        for (String fqanRole : fqanRoles = this.vomsAdmin.listRoles(DN, CA)) {
            String groupName = this.getGroupFromFQAN(fqanRole);
            String roleName = this.getRoleFromFQAN(fqanRole);
            if (groupedRoles.containsKey(groupName)) {
                ((ArrayList)groupedRoles.get(groupName)).add(roleName);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(roleName);
            groupedRoles.put(groupName, values);
        }
        HashMap<String, String[]> groupedRolesArray = new HashMap<String, String[]>();
        for (String group : groupedRoles.keySet()) {
            ArrayList rolesInGroup = (ArrayList)groupedRoles.get(group);
            groupedRolesArray.put(group, rolesInGroup.toArray(new String[rolesInGroup.size()]));
        }
        return groupedRolesArray;
    }

    @Override
    public String[] listGroupsRecursively() throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        return this.listGroupsRecursively(this.vomsAdmin.getVOName());
    }

    @Override
    public String[] listSubGroupsRecursively() throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        return this.listSubGroupsRecursively(this.vomsAdmin.getVOName());
    }

    @Override
    public String[] listGroupsRecursively(String groupName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        String[] subGroups = this.listSubGroupsRecursively(groupName);
        String[] groups = new String[subGroups.length + 1];
        groups[0] = groupName;
        for (int i = 0; i < subGroups.length; ++i) {
            groups[i + 1] = subGroups[i];
        }
        return groups;
    }

    @Override
    public String[] listSubGroupsRecursively(String groupName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        String[] subGroups;
        ArrayList<String> groups = new ArrayList<String>();
        for (String subGroup : subGroups = this.vomsAdmin.listSubGroups(groupName)) {
            groups.add(subGroup);
            groups.addAll(Arrays.asList(this.listSubGroupsRecursively(subGroup)));
        }
        return groups.toArray(new String[groups.size()]);
    }

    @Override
    public String[] listOnlineCAGroups(String userName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        return this.vomsAdmin.listGroups(this.getDN(userName), this.getCA());
    }

    @Override
    public HashMap<String, String[]> listOnlineCARoles(String userName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        return this.listGroupedRoles(this.getDN(userName), this.getCA());
    }

    @Override
    public String[] listOnlineCARoles(String groupName, String userName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        return this.listRoles(groupName, this.getDN(userName), this.getCA());
    }

    @Override
    public String[] listRoles(String groupName, String DN, String CA) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        String[] fqanRoles = this.vomsAdmin.listRoles(DN, CA);
        ArrayList<String> rolesInGroup = new ArrayList<String>();
        for (String fqanRole : fqanRoles) {
            if (!this.getGroupFromFQAN(fqanRole).equals(groupName)) continue;
            rolesInGroup.add(this.getRoleFromFQAN(fqanRole));
        }
        return rolesInGroup.toArray(new String[rolesInGroup.size()]);
    }

    @Override
    public User[] listUsers() throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        return this.vomsAdmin.listMembers(this.vomsAdmin.getVOName());
    }

    @Override
    public User[] listUsers(String groupName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        return this.vomsAdmin.listMembers(groupName);
    }

    @Override
    public HashMap<User, String[]> listUsersAndGroups(String roleName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        HashMap usersAndGroups = new HashMap();
        User[] users = null;
        String[] groups = this.listGroupsRecursively();
        for (int i = 0; i < groups.length; ++i) {
            users = this.vomsAdmin.listUsersWithRole(groups[i], roleName);
            for (int j = 0; j < users.length; ++j) {
                if (usersAndGroups.containsKey(users[j])) {
                    ArrayList g = (ArrayList)usersAndGroups.get(users[j]);
                    g.add(groups[i]);
                    continue;
                }
                ArrayList<String> inGroups = new ArrayList<String>();
                inGroups.add(groups[i]);
                usersAndGroups.put(users[j], inGroups);
            }
        }
        HashMap<User, String[]> usersAndGroupsArray = new HashMap<User, String[]>();
        for (User user : usersAndGroups.keySet()) {
            ArrayList rolesInGroup = (ArrayList)usersAndGroups.get(user);
            usersAndGroupsArray.put(user, rolesInGroup.toArray(new String[rolesInGroup.size()]));
        }
        return usersAndGroupsArray;
    }

    @Override
    public HashMap<User, String[]> listUsersAndRoles(String groupName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        HashMap usersAndRoles = new HashMap();
        User[] users = null;
        String[] roles = this.vomsAdmin.listRoles();
        for (int i = 0; i < roles.length; ++i) {
            users = this.vomsAdmin.listUsersWithRole(groupName, roles[i]);
            for (int j = 0; j < users.length; ++j) {
                if (usersAndRoles.containsKey(users[j])) {
                    ArrayList g = (ArrayList)usersAndRoles.get(users[j]);
                    g.add(roles[i]);
                    continue;
                }
                ArrayList<String> inGroups = new ArrayList<String>();
                inGroups.add(roles[i]);
                usersAndRoles.put(users[j], inGroups);
            }
        }
        HashMap<User, String[]> usersAndRolesArray = new HashMap<User, String[]>();
        for (User user : usersAndRoles.keySet()) {
            ArrayList rolesInGroup = (ArrayList)usersAndRoles.get(user);
            usersAndRolesArray.put(user, rolesInGroup.toArray(new String[rolesInGroup.size()]));
        }
        return usersAndRolesArray;
    }

    @Override
    public void removeOnlineCAMember(String groupName, String userName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        this.vomsAdmin.removeMember(groupName, this.getDN(userName), this.getCA());
    }

    @Override
    public void configureAsAdmin(String groupName, String roleName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        String rootGroup = this.vomsAdmin.getVOName();
        String voContext = rootGroup + "/" + roleName;
        String groupContext = groupName + "/" + roleName;
        ACLEntry rootAdminEntry = new ACLEntry();
        rootAdminEntry.setAdminIssuer("/O=VOMS/O=System/CN=VOMS Role");
        rootAdminEntry.setAdminSubject(voContext);
        rootAdminEntry.setVomsPermissionBits(3);
        this.vomsACL.addACLEntry(rootGroup, rootAdminEntry, false);
        ACLEntry voAdminEntry = new ACLEntry();
        voAdminEntry.setAdminIssuer("/O=VOMS/O=System/CN=VOMS Role");
        voAdminEntry.setAdminSubject(groupContext);
        voAdminEntry.setVomsPermissionBits(15);
        this.vomsACL.addACLEntry(groupName, voAdminEntry, false);
    }

    @Override
    public void revokeAsAdmin(String groupName, String roleName) throws VOMSException, RemoteException, VOMSAPIConfigurationException {
        String voName = this.vomsAdmin.getVOName();
        String voContext = voName + "/" + roleName;
        String groupContext = groupName + "/" + roleName;
        ACLEntry rootAdminEntry = new ACLEntry();
        rootAdminEntry.setAdminIssuer("/O=VOMS/O=System/CN=VOMS Role");
        rootAdminEntry.setAdminSubject(voContext);
        rootAdminEntry.setVomsPermissionBits(3);
        this.vomsACL.removeACLEntry(voName, rootAdminEntry, false);
        ACLEntry voAdminEntry = new ACLEntry();
        voAdminEntry.setAdminIssuer("/O=VOMS/O=System/CN=VOMS Role");
        voAdminEntry.setAdminSubject(groupContext);
        voAdminEntry.setVomsPermissionBits(15);
        this.vomsACL.removeACLEntry(groupName, voAdminEntry, false);
    }
}

