/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.util;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.gcube.common.core.security.utils.ProxyUtil;
import org.gcube.vomanagement.vomsapi.util.VOMSProxyFactory;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSException;

public class InMemoryVOMSProxyFactory
extends VOMSProxyFactory {
    private static Logger logger = Logger.getLogger(InMemoryVOMSProxyFactory.class);
    private static String defaultProxyDir = "proxies";
    private String proxyDir;

    public InMemoryVOMSProxyFactory(String proxyDir) throws IOException {
        this.proxyDir = proxyDir;
        File dir = new File(proxyDir);
        dir.mkdirs();
    }

    public InMemoryVOMSProxyFactory() throws IOException {
        this(defaultProxyDir);
    }

    public static void setDefaultProxyDir(String defaultProxyDir) {
        InMemoryVOMSProxyFactory.defaultProxyDir = defaultProxyDir;
    }

    public static String getDefaultProxyDir() {
        return defaultProxyDir;
    }

    public String getProxyDir() {
        return this.proxyDir;
    }

    public synchronized ExtendedGSSCredential createInMemoryProxy(File certificate, File key, String password) throws IOException, InterruptedException, GSSException {
        ExtendedGSSCredential credentials;
        File randomFile = new File(this.proxyDir + File.separator + "proxy_" + System.currentTimeMillis());
        try {
            while (!randomFile.createNewFile()) {
                randomFile = new File(this.proxyDir + File.separator + "proxy_" + System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            logger.error((Object)"Cannot create the temporary file to store credentials", (Throwable)e);
            throw e;
        }
        this.setOutput(randomFile);
        try {
            this.createProxy(certificate, key, password);
        }
        catch (IOException e) {
            randomFile.delete();
            throw e;
        }
        catch (InterruptedException e) {
            randomFile.delete();
            throw e;
        }
        try {
            credentials = ProxyUtil.loadProxyCredentials((String)randomFile.getAbsolutePath());
        }
        catch (IOException e) {
            logger.error((Object)"Cannot load credentials", (Throwable)e);
            randomFile.delete();
            throw e;
        }
        catch (GSSException e) {
            logger.error((Object)"Cannot load credentials", (Throwable)e);
            randomFile.delete();
            throw e;
        }
        randomFile.delete();
        return credentials;
    }

    public ExtendedGSSCredential createInMemoryProxy(File proxyFile) throws IOException, InterruptedException, GSSException {
        return this.createInMemoryProxy(proxyFile, null, null);
    }

    public ExtendedGSSCredential createInMemoryProxy(File certificate, File key) throws IOException, InterruptedException, GSSException {
        return this.createInMemoryProxy(certificate, key, null);
    }

    public ExtendedGSSCredential createInMemoryProxy(ExtendedGSSCredential credentials) throws IOException, InterruptedException, GSSException {
        File randomFile = new File(this.proxyDir + File.separator + "proxy_" + System.currentTimeMillis());
        ProxyUtil.storeProxyCredentials((String)randomFile.getAbsolutePath(), (ExtendedGSSCredential)credentials);
        ExtendedGSSCredential attributedCredentials = this.createInMemoryProxy(randomFile);
        randomFile.delete();
        return attributedCredentials;
    }
}

