/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.gcube.common.core.security.utils.ProxyUtil;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationException;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationProperty;
import org.gcube.vomanagement.vomsapi.util.CredentialsUtil;
import org.gridforum.jgss.ExtendedGSSCredential;

public class VOMSAPIConfiguration {
    private static File defaultConfigurationFile = new File("VOMS-API.properties");
    private static Logger logger = Logger.getLogger((String)VOMSAPIConfiguration.class.getName());
    private ExtendedGSSCredential credentials = null;
    private Properties properties;
    private transient String password = null;

    public static void setDefaultConfigurationFile(File defaultConfigFile) {
        logger.info((Object)("Setting default configuration file to " + defaultConfigurationFile.getAbsolutePath()));
        defaultConfigurationFile = defaultConfigFile;
    }

    public static File getDefaultConfigurationFile() {
        return defaultConfigurationFile;
    }

    public VOMSAPIConfiguration() throws VOMSAPIConfigurationException {
        this(defaultConfigurationFile);
    }

    public VOMSAPIConfiguration(Properties configurationProperties) throws VOMSAPIConfigurationException {
        logger.debug((Object)"Loading configuration properties from object");
        this.properties = new Properties();
        Enumeration<?> propEnum = configurationProperties.propertyNames();
        while (propEnum.hasMoreElements()) {
            String property = (String)propEnum.nextElement();
            this.properties.setProperty(property, configurationProperties.getProperty(property));
        }
        logger.info((Object)"Loaded configuration properties from object");
        this.intializeConfiguration();
    }

    public VOMSAPIConfiguration(File configurationFile) throws VOMSAPIConfigurationException {
        if (configurationFile == null) {
            logger.error((Object)"Configuration file cannot be null");
            throw new NullPointerException("Configuration file cannot be null");
        }
        this.properties = new Properties();
        logger.info((Object)("Using configuration file " + configurationFile.getAbsolutePath()));
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configurationFile);
            this.properties.load(fis);
        }
        catch (IOException e) {
            logger.error((Object)("Cannot load configuration file " + configurationFile.getAbsolutePath()), (Throwable)e);
            throw new VOMSAPIConfigurationException("Cannot load configuration file " + configurationFile.getAbsolutePath(), e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                logger.error((Object)("Cannot close the stream of the configuration file " + configurationFile), (Throwable)e);
                throw new VOMSAPIConfigurationException("Cannot close the stream of the configuration file " + configurationFile, e);
            }
        }
        logger.info((Object)("Loaded configuration file " + configurationFile));
        this.intializeConfiguration();
    }

    private void intializeConfiguration() throws VOMSAPIConfigurationException {
        this.password = (String)this.properties.remove(VOMSAPIConfigurationProperty.CLIENT_PWD.toString());
        logger.info((Object)("Initializing the VOMSAPIConfiguration object with properties " + this.properties.toString() + (this.password != null ? " \n NOTE: A CLIENT_PWD property has also been loaded, but is not shown in logs for security reasons" : "")));
        this.loadCredentials();
    }

    private void loadCredentials() throws VOMSAPIConfigurationException {
        String clientProxy = this.properties.getProperty(VOMSAPIConfigurationProperty.CLIENT_PROXY.toString());
        String clientCert = this.properties.getProperty(VOMSAPIConfigurationProperty.CLIENT_CERT.toString());
        String clientKey = this.properties.getProperty(VOMSAPIConfigurationProperty.CLIENT_KEY.toString());
        if (clientProxy != null) {
            try {
                this.credentials = ProxyUtil.loadProxyCredentials((String)clientProxy);
                logger.debug((Object)("Loaded " + CredentialsUtil.stringCredentials(this.credentials) + " from proxy file " + clientProxy));
            }
            catch (Exception e) {
                logger.error((Object)("Cannot load credentials from proxy file: " + clientProxy), (Throwable)e);
                throw new VOMSAPIConfigurationException("Cannot load credentials from proxy file: " + clientProxy, e);
            }
        }
        if (clientCert != null) {
            try {
                this.credentials = CredentialsUtil.loadEndEntityCredentials(clientCert, clientKey, this.password);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot load end entity credentials from certificate file: " + clientCert + " and key file: " + clientKey), (Throwable)e);
                throw new VOMSAPIConfigurationException("Cannot load end entity credentials from certificate file: " + clientCert + " and key file: " + clientKey, e);
            }
        }
        if (this.credentials != null) {
            this.verifyCredentials(this.credentials);
        }
    }

    public String getProperty(VOMSAPIConfigurationProperty property) {
        String value = this.properties.getProperty(property.toString());
        if (value == null) {
            value = property.getDefaultValue();
        }
        return value;
    }

    public int getVOMSPort() {
        String value = this.getProperty(VOMSAPIConfigurationProperty.VOMS_PORT);
        return Integer.parseInt(value);
    }

    public int getMyProxyPort() {
        String value = this.getProperty(VOMSAPIConfigurationProperty.MYPROXY_PORT);
        return Integer.parseInt(value);
    }

    public boolean runsInWSCore() {
        String value = this.getProperty(VOMSAPIConfigurationProperty.RUNS_IN_WS_CORE);
        return Boolean.parseBoolean(value);
    }

    public ExtendedGSSCredential getCredentials() {
        logger.debug((Object)("Returning " + CredentialsUtil.stringCredentials(this.credentials)));
        return this.credentials;
    }

    public void setCredentials(ExtendedGSSCredential credentials) throws VOMSAPIConfigurationException {
        this.verifyCredentials(credentials);
        logger.debug((Object)("Setting " + CredentialsUtil.stringCredentials(credentials)));
        this.credentials = credentials;
    }

    private void verifyCredentials(ExtendedGSSCredential credentials) throws VOMSAPIConfigurationException {
        if (CredentialsUtil.isExpired(credentials)) {
            logger.error((Object)(CredentialsUtil.stringCredentials(credentials) + " are expired!!!"));
            throw new VOMSAPIConfigurationException(CredentialsUtil.stringCredentials(credentials) + " are expired!!!");
        }
    }

    public String toString() {
        return "VOMSAPIConfiguration[" + this.properties.toString() + ",\n\t" + CredentialsUtil.stringCredentials(this.credentials) + ", \n\t" + (this.password != null ? " A password to decrypt credentials is also present in the configuration " : " A password to decrypt credentials is NOT present in the configuration ") + "]";
    }
}

