/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.impl;

import java.net.URL;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.BasicClientConfig;
import org.apache.log4j.Logger;
import org.gcube.vomanagement.vomsapi.CredentialsManager;
import org.gcube.vomanagement.vomsapi.ExtendedVOMSAdmin;
import org.gcube.vomanagement.vomsapi.VOMSACL;
import org.gcube.vomanagement.vomsapi.VOMSAdmin;
import org.gcube.vomanagement.vomsapi.VOMSAttributeManager;
import org.gcube.vomanagement.vomsapi.VOMSAttributes;
import org.gcube.vomanagement.vomsapi.impl.CredentialsManagerImpl;
import org.gcube.vomanagement.vomsapi.impl.ExtendedVOMSAdminImpl;
import org.gcube.vomanagement.vomsapi.impl.VOMSACLImpl;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfiguration;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationException;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationProperty;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIStub;
import org.gcube.vomanagement.vomsapi.impl.VOMSAdminImpl;
import org.gcube.vomanagement.vomsapi.impl.VOMSAttributeManagerImpl;
import org.gcube.vomanagement.vomsapi.impl.VOMSAttributesImpl;
import org.gcube.vomanagement.vomsapi.impl.ssl.MySSLSocketFactory;
import org.gcube.vomanagement.vomsapi.impl.utils.VOMSServerBean;
import org.glite.wsdl.services.org_glite_security_voms_service_acl.VOMSACLServiceLocator;
import org.glite.wsdl.services.org_glite_security_voms_service_admin.VOMSAdminServiceLocator;
import org.glite.wsdl.services.org_glite_security_voms_service_attributes.VOMSAttributesServiceLocator;
import org.gridforum.jgss.ExtendedGSSCredential;

public class VOMSAPIFactory {
    private static Logger logger = Logger.getLogger((String)VOMSAPIFactory.class.getName());
    private VOMSAPIConfiguration config;
    private SSLSocketFactory sslFactory = null;
    private ExtendedGSSCredential lastUsedCredentials;
    private List<VOMSServerBean> serverList;

    public VOMSAPIFactory() throws VOMSAPIConfigurationException {
        this(new VOMSAPIConfiguration());
    }

    public VOMSAPIFactory(VOMSAPIConfiguration configuration) throws VOMSAPIConfigurationException {
        this.config = configuration;
        this.refreshSSLFactory();
    }

    public void setServerList(List<VOMSServerBean> serverList) {
        this.serverList = serverList;
    }

    public VOMSAdmin getVOMSAdmin() throws VOMSAPIConfigurationException, ServiceException {
        VOMSAdminServiceLocator locator = new VOMSAdminServiceLocator();
        this.configureLocator((Service)locator);
        URL url = this.createURL(locator.getVOMSAdminWSDDServiceName());
        org.glite.wsdl.services.org_glite_security_voms_service_admin.VOMSAdmin portType = locator.getVOMSAdmin(url);
        return new VOMSAdminImpl(portType, this);
    }

    public ExtendedVOMSAdmin getExtendedVOMSAdmin() throws VOMSAPIConfigurationException, ServiceException {
        return new ExtendedVOMSAdminImpl(this.getVOMSAdmin(), this.getVOMSACL(), this);
    }

    public VOMSAttributes getVOMSAttributes() throws VOMSAPIConfigurationException, ServiceException {
        VOMSAttributesServiceLocator locator = new VOMSAttributesServiceLocator();
        this.configureLocator((Service)locator);
        URL url = this.createURL(locator.getVOMSAttributesWSDDServiceName());
        org.glite.wsdl.services.org_glite_security_voms_service_attributes.VOMSAttributes portType = locator.getVOMSAttributes(url);
        return new VOMSAttributesImpl(portType, this);
    }

    public VOMSACL getVOMSACL() throws VOMSAPIConfigurationException, ServiceException {
        VOMSACLServiceLocator locator = new VOMSACLServiceLocator();
        this.configureLocator((Service)locator);
        URL url = this.createURL(locator.getVOMSACLWSDDServiceName());
        org.glite.wsdl.services.org_glite_security_voms_service_acl.VOMSACL portType = locator.getVOMSACL(url);
        return new VOMSACLImpl(portType, this);
    }

    public CredentialsManager getCredentialsManager() throws VOMSAPIConfigurationException, ServiceException {
        CredentialsManagerImpl response = new CredentialsManagerImpl(this.config, this.getExtendedVOMSAdmin());
        response.setServerList(this.serverList);
        return response;
    }

    public VOMSAttributeManager getVOMSAttributeManager() throws VOMSAPIConfigurationException, ServiceException {
        VOMSAttributeManagerImpl response = new VOMSAttributeManagerImpl(this.config, this.getExtendedVOMSAdmin());
        response.setServerList(this.serverList);
        return response;
    }

    public VOMSAPIConfiguration getVOMSAPIConfiguration() {
        return this.config;
    }

    private URL createURL(String wsddServiceName) throws VOMSAPIConfigurationException {
        try {
            return new URL(this.config.getProperty(VOMSAPIConfigurationProperty.VOMS_PROTOCOL), this.config.getProperty(VOMSAPIConfigurationProperty.VOMS_HOST), this.config.getVOMSPort(), "/voms/" + this.config.getProperty(VOMSAPIConfigurationProperty.VO_NAME) + "/services/" + wsddServiceName);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot create URL for VOMS interface " + wsddServiceName), (Throwable)e);
            throw new VOMSAPIConfigurationException("Cannot create URL for VOMS interface " + wsddServiceName + ", the VOMS configuration in use is " + this.config, e);
        }
    }

    private void configureLocator(Service locator) {
        if (!this.config.runsInWSCore()) {
            BasicClientConfig clientConfig = new BasicClientConfig();
            locator.setEngineConfiguration((EngineConfiguration)clientConfig);
            locator.setEngine((AxisEngine)new AxisClient((EngineConfiguration)clientConfig));
        }
    }

    Object getLock() {
        if (!this.config.runsInWSCore()) {
            return MySSLSocketFactory.LOCK;
        }
        return new Object();
    }

    void prepareForCall(VOMSAPIStub stub) throws VOMSAPIConfigurationException {
        if (!this.config.runsInWSCore()) {
            this.refreshSSLFactory();
            MySSLSocketFactory.setCurrentSSLFactory(this.sslFactory);
        } else {
            stub.configureVOMSAPIStubForCall();
        }
    }

    void exitFromCall() {
        if (!this.config.runsInWSCore()) {
            MySSLSocketFactory.resetSSLFactory();
        }
    }

    private void refreshSSLFactory() throws VOMSAPIConfigurationException {
        if (!this.config.runsInWSCore() && this.config.getCredentials() != this.lastUsedCredentials) {
            this.lastUsedCredentials = this.config.getCredentials();
            this.sslFactory = MySSLSocketFactory.createSSLFactory(this.lastUsedCredentials);
        }
    }
}

