/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.jms;

import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.exception.EnvironmentValidationException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.jms.IJMSProvider;

public class JMSProvider
implements IJMSProvider {
    private static IJMSProvider StaticProvider = null;
    private static final Object lockMe = new Object();
    private static String fallback;
    private IJMSProvider Provider = null;
    private static EnvHintCollection InitHints;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJMSProvider Init(String ProviderName, EnvHintCollection Hints, String fallback) throws EnvironmentValidationException {
        JMSProvider.fallback = fallback;
        try {
            Object object = lockMe;
            synchronized (object) {
                if (StaticProvider == null) {
                    if (ProviderName.equals(JMSProvider.class.getName())) {
                        throw new EnvironmentValidationException("Class " + JMSProvider.class.getName() + " cannot be defined as provider");
                    }
                    Class<?> c = Class.forName(ProviderName);
                    Object o = c.newInstance();
                    if (!(o instanceof IJMSProvider)) {
                        throw new EnvironmentValidationException("");
                    }
                    JMSProvider prov = new JMSProvider();
                    prov.Provider = (IJMSProvider)o;
                    InitHints = Hints;
                    StaticProvider = prov;
                }
            }
            return StaticProvider;
        }
        catch (Exception ex) {
            if (fallback == null || fallback.isEmpty()) {
                throw new EnvironmentValidationException("Could not initialize JMS Provider", ex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean IsInit() {
        Object object = lockMe;
        synchronized (object) {
            return StaticProvider != null;
        }
    }

    private EnvHintCollection MergeHints(EnvHintCollection Hints) {
        if (InitHints == null && Hints == null) {
            return new EnvHintCollection();
        }
        if (InitHints == null) {
            return Hints;
        }
        if (Hints == null) {
            return InitHints;
        }
        return InitHints.Merge(Hints);
    }

    @Override
    public String getJMSPRovider(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (this.Provider == null) {
            return fallback;
        }
        return this.Provider.getJMSPRovider(InitHints);
    }

    public static String getJMSPRovider() throws EnvironmentInformationSystemException {
        if (StaticProvider == null) {
            return fallback;
        }
        return StaticProvider.getJMSPRovider(InitHints);
    }

    static {
        InitHints = null;
    }
}

