/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.is.elements.plot;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemSerializationException;
import gr.uoa.di.madgik.environment.is.elements.plot.PlotParameter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PlotMethod
implements Serializable {
    private static final long serialVersionUID = -4686237646751510182L;
    public int Order = 0;
    public boolean IsConstructor;
    public boolean UseReturnValue;
    public String Signature;
    public Set<PlotParameter> Parameters = new HashSet<PlotParameter>();

    public void FromXML(Element XML) throws EnvironmentInformationSystemSerializationException {
        try {
            Element plotMethodSignature;
            if (!XMLUtils.AttributeExists((Element)XML, (String)"order").booleanValue()) {
                throw new EnvironmentInformationSystemException("Invalid serialization provided");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)XML, (String)"order"));
            this.IsConstructor = XMLUtils.AttributeExists((Element)XML, (String)"isConstructor") == false ? false : Boolean.parseBoolean(XMLUtils.GetAttribute((Element)XML, (String)"isConstructor"));
            if (!this.IsConstructor) {
                if (!XMLUtils.AttributeExists((Element)XML, (String)"useReturn").booleanValue()) {
                    throw new EnvironmentInformationSystemException("Invalid serialization provided");
                }
                this.UseReturnValue = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)XML, (String)"useReturn"));
            }
            if ((plotMethodSignature = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"signature", (String)"http://profile.workflow.madgik.di.uoa.gr")) == null) {
                throw new EnvironmentInformationSystemException("Invalid serialization provided");
            }
            this.Signature = XMLUtils.GetChildText((Node)plotMethodSignature);
            Element plotMethodParametersElement = XMLUtils.GetChildElementWithNameAndNamespace((Node)XML, (String)"parameters", (String)"http://profile.workflow.madgik.di.uoa.gr");
            if (plotMethodParametersElement != null) {
                List plotMethodParameterslst = XMLUtils.GetChildElementsWithNameAndNamespace((Node)plotMethodParametersElement, (String)"parameter", (String)"http://profile.workflow.madgik.di.uoa.gr");
                this.Parameters.clear();
                for (Element plotMethodParameterElement : plotMethodParameterslst) {
                    PlotParameter ppar = new PlotParameter();
                    ppar.FromXML(plotMethodParameterElement);
                    this.Parameters.add(ppar);
                }
            }
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemSerializationException("Could not deserialize element", ex);
        }
    }

    public String ToXML() throws EnvironmentInformationSystemSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<wfprf:method order=\"" + this.Order + "\" isConstructor=\"" + this.IsConstructor + "\" useReturn=\"" + this.UseReturnValue + "\">");
        buf.append("<wfprf:signature>" + this.Signature + "</wfprf:signature>");
        buf.append("<wfprf:parameters>");
        for (PlotParameter par : this.Parameters) {
            buf.append(par.ToXML());
        }
        buf.append("</wfprf:parameters>");
        buf.append("</wfprf:method>");
        return buf.toString();
    }
}

