/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.proxy.tcp;

import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistry;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryEntry;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryKey;
import gr.uoa.di.madgik.commons.channel.registry.RegisteredNozzle;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import java.io.DataInputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelTCPConnManagerEntry
implements ITCPConnectionManagerEntry {
    private static Logger logger = Logger.getLogger(ChannelTCPConnManagerEntry.class.getName());

    @Override
    public ITCPConnectionManagerEntry.NamedEntry GetName() {
        return ITCPConnectionManagerEntry.NamedEntry.Channel;
    }

    @Override
    public void HandleConnection(Socket socket) {
        block8: {
            try {
                DataInputStream din = new DataInputStream(socket.getInputStream());
                String nozzleUUID = din.readUTF();
                String channelUUID = din.readUTF();
                ChannelRegistryEntry entry = ChannelRegistry.Retrieve(new ChannelRegistryKey(channelUUID));
                if (entry != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "New Connection opened");
                    }
                    if (!entry.RegisterNozzle(new RegisteredNozzle(nozzleUUID, socket))) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Registration of new connection not allowed");
                        }
                        socket.close();
                    }
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Received incomming connection for non available channel");
                    }
                    socket.close();
                }
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) break block8;
                logger.log(Level.WARNING, "Could not handle incomming connection", ex);
            }
        }
    }
}

