/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeassignmentpolicy;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import java.util.HashMap;
import java.util.Map;

public class CollocationRegistry {
    private Map<String, HostingNode> nodes = new HashMap<String, HostingNode>();
    private Map<String, Integer> timesSelected = new HashMap<String, Integer>();
    private Map<String, Integer> roundsSelected = new HashMap<String, Integer>();
    private Map<String, Float> collocationScore = new HashMap<String, Float>();
    private Map<String, Float> totalCollocationScore = new HashMap<String, Float>();

    public void markSelected(HostingNode node) {
        this.nodes.put(node.getId(), node);
        if (!this.timesSelected.containsKey(node.getId())) {
            this.timesSelected.put(node.getId(), 1);
        } else {
            this.timesSelected.put(node.getId(), this.timesSelected.get(node.getId()) + 1);
        }
        if (!this.roundsSelected.containsKey(node.getId())) {
            this.roundsSelected.put(node.getId(), 1);
        }
        if (!this.collocationScore.containsKey(node.getId())) {
            this.collocationScore.put(node.getId(), Float.valueOf(0.0f));
        }
        if (!this.totalCollocationScore.containsKey(node.getId())) {
            this.totalCollocationScore.put(node.getId(), Float.valueOf(0.0f));
        }
    }

    public boolean isSelected(HostingNode node) {
        return this.nodes.containsKey(node.getId());
    }

    public int timesSelected(HostingNode node) {
        if (!this.timesSelected.containsKey(node.getId())) {
            return 0;
        }
        return this.timesSelected.get(node.getId());
    }

    public int currentRound(HostingNode node) {
        Integer round = this.roundsSelected.get(node.getId());
        if (round == null) {
            return 1;
        }
        return round;
    }

    public void newRound(HostingNode node) {
        if (!this.roundsSelected.containsKey(node.getId())) {
            this.roundsSelected.put(node.getId(), 1);
        } else {
            this.roundsSelected.put(node.getId(), this.roundsSelected.get(node.getId()) + 1);
        }
        this.collocationScore.put(node.getId(), Float.valueOf(0.0f));
    }

    public float getCollocationScore(HostingNode node) throws Exception {
        if (!this.isSelected(node)) {
            throw new Exception("Node is not marked as selected");
        }
        return this.collocationScore.get(node.getId()).floatValue();
    }

    public float getTotalCollocationScore(HostingNode node) throws Exception {
        if (!this.isSelected(node)) {
            throw new Exception("Node is not marked as selected");
        }
        return this.totalCollocationScore.get(node.getId()).floatValue();
    }

    public void addToCollocationScore(HostingNode node, float value) throws Exception {
        if (!this.isSelected(node)) {
            throw new Exception("Node is not marked as selected");
        }
        this.collocationScore.put(node.getId(), Float.valueOf(this.collocationScore.get(node.getId()).floatValue() + value));
        this.totalCollocationScore.put(node.getId(), Float.valueOf(this.totalCollocationScore.get(node.getId()).floatValue() + value));
    }
}

