/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.server.http;

import gr.uoa.di.madgik.commons.server.ConnectionManager;
import gr.uoa.di.madgik.commons.server.ConnectionManagerConfig;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.http.IHTTPConnectionManagerEntry;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTTPConnectionManager
extends ConnectionManager {
    private static Logger logger = Logger.getLogger(HTTPConnectionManager.class.getName());
    private static HTTPConnectionManager Manager = null;
    private static final Map<IHTTPConnectionManagerEntry.NamedEntry, IHTTPConnectionManagerEntry> Entries = new Hashtable<IHTTPConnectionManagerEntry.NamedEntry, IHTTPConnectionManagerEntry>();
    private static final Object lockInit = new Object();
    private static final Object lockEntries = new Object();
    private static final Object synchStart = new Object();
    private ServerSocket Sock = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Init(ConnectionManagerConfig Config2) {
        Config = Config2;
        Object object = lockInit;
        synchronized (object) {
            if (Manager == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Creating new instance of the connection manager");
                }
                Manager = new HTTPConnectionManager(HTTPConnectionManager.OpenSocket());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Init() throws FileNotFoundException, IOException {
        HTTPConnectionManager.initializeConfigFromFile();
        Object object = lockInit;
        synchronized (object) {
            if (Manager == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Creating new instance of the connection manager");
                }
                Manager = new HTTPConnectionManager(HTTPConnectionManager.OpenSocket());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean IsInitialized() {
        Object object = lockInit;
        synchronized (object) {
            return Manager != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetConnectionManagerHostName() {
        Object object = lockInit;
        synchronized (object) {
            if (Manager != null) {
                if (HTTPConnectionManager.Config.HostName != null) {
                    return HTTPConnectionManager.Config.HostName;
                }
                return HTTPConnectionManager.Manager.Sock.getInetAddress().getHostAddress();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetConnectionManagerPort() {
        Object object = lockInit;
        synchronized (object) {
            if (Manager != null) {
                return HTTPConnectionManager.Manager.Sock.getLocalPort();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IHTTPConnectionManagerEntry RegisterEntry(IHTTPConnectionManagerEntry Entry2) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Registering entry for entry name " + Entry2.GetName().toString());
        }
        Object object = lockEntries;
        synchronized (object) {
            if (!Entries.containsKey((Object)Entry2.GetName())) {
                Entries.put(Entry2.GetName(), Entry2);
            }
            return Entries.get((Object)Entry2.GetName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IHTTPConnectionManagerEntry GetEntry(IHTTPConnectionManagerEntry.NamedEntry Name) {
        Object object = lockEntries;
        synchronized (object) {
            if (!Entries.containsKey((Object)Name)) {
                return null;
            }
            return Entries.get((Object)Name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPConnectionManager(ServerSocket Sock) {
        this.Sock = Sock;
        this.setName(HTTPConnectionManager.class.getName());
        this.setDaemon(true);
        Object object = synchStart;
        synchronized (object) {
            this.start();
            try {
                synchStart.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ServerSocket OpenSocket() {
        block11: {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Opening socket");
            }
            for (PortRange range : HTTPConnectionManager.Config.Ports) {
                for (int p = range.GetStart(); p <= range.GetEnd(); ++p) {
                    try {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Trying to open server socket on port " + p);
                        }
                        ServerSocket servSocktmp = new ServerSocket(p);
                        return servSocktmp;
                    }
                    catch (Exception ex) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "Could not open server socket on port " + p, ex);
                        continue;
                    }
                }
            }
            if (HTTPConnectionManager.Config.UseRandomIfNoneAvailable) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Trying to open server socket on random port");
                    }
                    ServerSocket servSocktmp = new ServerSocket(0);
                    return servSocktmp;
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(Level.FINE)) break block11;
                    logger.log(Level.FINE, "Could not open server socket on random port ", ex);
                }
            }
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Socket for proxy cannot be opened. No usable port could be found and bound to");
        }
        throw new IllegalArgumentException("Socket for proxy cannot be opened. No usable port could be found and bound to");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Connection manager initialized listening to port (" + this.Sock.getLocalPort() + ")");
        }
        Object object = synchStart;
        synchronized (object) {
            synchStart.notify();
        }
        while (true) {
            Socket consumerSock = null;
            try {
                logger.log(Level.FINEST, "HTTPConnectionManager : Accepting...");
                consumerSock = this.Sock.accept();
                logger.log(Level.FINEST, "HTTPConnectionManager : Accepted");
                logger.log(Level.FINEST, "HTTPConnectionManager : Socket host : " + consumerSock.getInetAddress().getHostAddress());
                logger.log(Level.FINEST, "HTTPConnectionManager : Socket port : " + consumerSock.getPort());
                logger.log(Level.FINEST, "HTTPConnectionManager : remote address : " + consumerSock.getRemoteSocketAddress().toString());
                BufferedReader netStream = new BufferedReader(new InputStreamReader(consumerSock.getInputStream()));
                StringBuffer strBuf = new StringBuffer();
                String key = null;
                String EntryNameString = null;
                Integer contentLength = -1;
                String line = null;
                while ((line = netStream.readLine()) != null) {
                    String[] words = line.split(" ");
                    if (words.length > 1 && words[0].equalsIgnoreCase("Content-Length:")) {
                        contentLength = Integer.valueOf(words[1].trim());
                    } else if (words.length > 1 && words[0].equalsIgnoreCase("key:")) {
                        key = words[1].trim();
                    } else if (words.length > 1 && words[0].equalsIgnoreCase("EntryName:")) {
                        EntryNameString = words[1].trim();
                    }
                    if (line.trim().length() == 0) break;
                    strBuf.append(line + "\n");
                }
                if (strBuf.toString().trim().length() == 0) {
                    logger.log(Level.FINEST, "Trying to parse it byte-byte");
                    DataInputStream dis = new DataInputStream(consumerSock.getInputStream());
                    while (dis.available() > 0) {
                        char c = dis.readChar();
                        logger.log(Level.FINEST, String.valueOf(c));
                    }
                    throw new Exception("Empty request received");
                }
                StringBuffer request = new StringBuffer();
                while (true) {
                    Integer c = contentLength;
                    Integer n = contentLength = Integer.valueOf(contentLength - 1);
                    if (c <= 0) break;
                    request.append((char)netStream.read());
                }
                if (key == null) {
                    throw new Exception("Key not defined");
                }
                IHTTPConnectionManagerEntry.NamedEntry EntryName = IHTTPConnectionManagerEntry.NamedEntry.valueOf(EntryNameString);
                IHTTPConnectionManagerEntry Entry2 = HTTPConnectionManager.GetEntry(EntryName);
                if (Entry2 == null) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "No handler set to forward connection for " + EntryName.toString());
                    }
                    consumerSock.close();
                    continue;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "New Connection opened and passed to " + EntryName.toString());
                }
                Entry2.HandleConnection(consumerSock, request.toString(), new BufferedOutputStream(consumerSock.getOutputStream()), key);
                continue;
            }
            catch (Exception ex) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Could not handle new connection request", ex);
                }
                try {
                    consumerSock.close();
                }
                catch (IOException iOException) {
                }
                continue;
            }
            break;
        }
    }
}

