/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeselection.cost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CostFunction {
    public static String DistanceToPrevious = "distanceToPrevious";
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private float fractionSum = 0.0f;
    private Map<String, CostFactor> costFactors = new HashMap<String, CostFactor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCostFactor(String name, float fraction, boolean ascending) throws Exception {
        boolean locked = false;
        try {
            this.lock.writeLock().lock();
            locked = true;
            if (this.fractionSum + fraction > 1.00001f) {
                throw new Exception("Coefficients exceed 1.0");
            }
            this.costFactors.put(name, new CostFactor(name, fraction, ascending));
        }
        finally {
            if (locked) {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCostFactors(Set<String> factorsToRemove) {
        if (factorsToRemove.isEmpty()) {
            return;
        }
        boolean locked = false;
        try {
            this.lock.writeLock().lock();
            locked = true;
            for (String factor : factorsToRemove) {
                float coeff = this.costFactors.get(factor).coefficient;
                float coeffFactor = 1.0f / (1.0f - coeff);
                this.costFactors.remove(factor);
                Iterator<CostFactor> iterator = this.costFactors.values().iterator();
                while (iterator.hasNext()) {
                    CostFactor f;
                    CostFactor costFactor = f = iterator.next();
                    costFactor.coefficient = costFactor.coefficient * coeffFactor;
                }
            }
        }
        finally {
            if (locked) {
                this.lock.writeLock().unlock();
            }
        }
    }

    public List<CostFactor> getCostFactors() {
        boolean locked = false;
        try {
            this.lock.readLock().lock();
            locked = true;
            ArrayList<CostFactor> arrayList = new ArrayList<CostFactor>(this.costFactors.values());
            return arrayList;
        }
        finally {
            if (locked) {
                this.lock.readLock().unlock();
            }
        }
    }

    public static class CostFactor {
        public final String name;
        private float coefficient;
        private final boolean ascending;

        public CostFactor(String name, float coefficient, boolean ascending) {
            this.name = name;
            this.coefficient = coefficient;
            this.ascending = ascending;
        }

        public float getCoefficient() {
            return this.coefficient;
        }

        public boolean isAscending() {
            return this.ascending;
        }
    }
}

