/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.configuration.parameter.elements.graph;

import gr.uoa.di.madgik.commons.configuration.parameter.IParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.ObjectParameter;
import gr.uoa.di.madgik.commons.configuration.parameter.elements.Argument;
import gr.uoa.di.madgik.commons.configuration.parameter.elements.Method;
import gr.uoa.di.madgik.commons.configuration.parameter.elements.graph.GraphElement;
import gr.uoa.di.madgik.commons.configuration.utils.ClassWrapper;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DependencyGraph {
    private static Logger logger = Logger.getLogger(DependencyGraph.class.getName());
    private Map<String, GraphElement> Graph = new Hashtable<String, GraphElement>();
    private Map<String, IParameter> Params = null;

    public DependencyGraph(Map<String, IParameter> Params) {
        this.Params = Params;
    }

    public void ConstructGraph() throws Exception {
        for (Map.Entry<String, IParameter> entry : this.Params.entrySet()) {
            this.Graph.put(entry.getKey(), new GraphElement(entry.getKey()));
        }
        for (Map.Entry<String, IParameter> entry : this.Params.entrySet()) {
            if (!entry.getValue().GetParameterType().equals((Object)IParameter.ParameterType.Object)) continue;
            if (((ObjectParameter)entry.getValue()).GetConstructor() != null) {
                for (Argument a : ((ObjectParameter)entry.getValue()).GetConstructor().GetArguments().GetArguments()) {
                    if (!this.Graph.containsKey(a.GetParameterName())) {
                        throw new Exception("Reference to " + a.GetParameterName() + " not found");
                    }
                    this.Graph.get((Object)entry.getValue().GetName()).Incoming.add(a.GetParameterName());
                }
            }
            for (Method m : ((ObjectParameter)entry.getValue()).GetMethods()) {
                for (Argument a : m.GetArguments().GetArguments()) {
                    if (!this.Graph.containsKey(a.GetParameterName())) {
                        throw new Exception("Reference to " + a.GetParameterName() + " not found");
                    }
                    this.Graph.get((Object)entry.getValue().GetName()).Incoming.add(a.GetParameterName());
                }
                if (m.GetOutput() == null) continue;
                if (!this.Graph.containsKey(m.GetOutput().GetParameterName())) {
                    throw new Exception("Reference to " + m.GetOutput().GetParameterName() + " not found");
                }
                this.Graph.get((Object)entry.getValue().GetName()).Outgoing.add(m.GetOutput().GetParameterName());
            }
        }
    }

    public void ResolveDependencies() throws Exception {
        boolean continueLoop = true;
        while (continueLoop) {
            continueLoop = false;
            for (Map.Entry<String, GraphElement> entry : this.Graph.entrySet()) {
                boolean generated = this.Generate(entry.getKey());
                if (generated) continue;
                continueLoop = true;
            }
        }
    }

    public Boolean AllChecked() {
        for (Map.Entry<String, IParameter> entry : this.Params.entrySet()) {
            if (entry.getValue().IsChecked().booleanValue()) continue;
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Parameter " + entry.getKey() + " not checked");
            }
            return false;
        }
        return true;
    }

    private Boolean Generate(String Name) throws Exception {
        if (this.Params.get(Name).IsChecked().booleanValue()) {
            return true;
        }
        if (!(this.Params.get(Name) instanceof ObjectParameter)) {
            if (!this.Params.get(Name).IsGenerated().booleanValue()) {
                this.Params.get(Name).Check();
                return true;
            }
            return false;
        }
        boolean canGenerate = true;
        for (String incoming : this.Graph.get((Object)Name).Incoming) {
            if (this.Params.get(incoming).IsChecked().booleanValue()) continue;
            canGenerate = false;
        }
        if (!canGenerate) {
            return false;
        }
        ClassWrapper wrap = new ClassWrapper(this.Params);
        wrap.Instantiate(((ObjectParameter)this.Params.get(Name)).GetClassName(), ((ObjectParameter)this.Params.get(Name)).GetConstructor());
        List<Method> meths = ((ObjectParameter)this.Params.get(Name)).GetMethods();
        for (Method m : meths) {
            wrap.Invoke(m);
        }
        if (((ObjectParameter)this.Params.get(Name)).GetConstructor() == null) {
            this.Params.get(Name).SetValue(wrap.ModuleClass);
        } else {
            this.Params.get(Name).SetValue(wrap.Instance);
        }
        this.Params.get(Name).Check();
        return true;
    }
}

