/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.bridge;

import com.google.common.collect.Sets;
import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.bridge.IRegistryProvider;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.execution.rr.bridge.BridgeHelper;
import org.gcube.execution.rr.bridge.FieldModel;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GCubeRepositoryProvider
implements IRegistryProvider {
    private static final Logger logger = LoggerFactory.getLogger(GCubeRepositoryProvider.class);
    public static String RRModelGenericResourceNameDef = "ResourceRegistryModel";
    public static String RRModelGenericResourceSecondaryTypeDef = "ResourceRegistryModel";
    public static String RRModelGenericResourceName = RRModelGenericResourceNameDef;
    public static String RRModelGenericResourceSecondaryType = RRModelGenericResourceSecondaryTypeDef;
    public Set<Class<?>> inMemoryTargets = new HashSet();

    public void readConfiguration(Properties config) {
        if (config == null) {
            return;
        }
        boolean defaultUsed = true;
        String value = null;
        value = config.getProperty("modelGenericResourceSecondaryType");
        if (value != null) {
            String secTypeValue = value;
            value = config.getProperty("modelGenericResourceName");
            if (value != null) {
                RRModelGenericResourceSecondaryType = secTypeValue;
                RRModelGenericResourceName = value;
                defaultUsed = false;
                logger.info("Using Model Generic Resource secondary type: " + RRModelGenericResourceSecondaryType);
                logger.info("Using Model Generic Resource name: " + RRModelGenericResourceName);
            }
        }
        if (defaultUsed) {
            logger.info("Using default Model Generic Resource secondary type: " + RRModelGenericResourceSecondaryType);
            logger.info("Using default Model Generic Resource name: " + RRModelGenericResourceName);
        }
        try {
            BridgeHelper.initializeIndexTypes(config);
        }
        catch (ResourceRegistryException e) {
            logger.warn("Could not initialize index types. Defaults will be used", (Throwable)e);
            BridgeHelper.initializeIndexTypes();
        }
    }

    public boolean isReadPolicySupported(RRContext.ReadPolicy policy) throws ResourceRegistryException {
        switch (policy) {
            case READ_LOCAL: {
                return false;
            }
            case READ_THROUGH: {
                return false;
            }
            case REFRESH_AHEAD: {
                return ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCAL) && ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCALBUFFER);
            }
        }
        return false;
    }

    public boolean isWritePolicySupported(RRContext.WritePolicy policy) throws ResourceRegistryException {
        switch (policy) {
            case WRITE_THROUGH: {
                return false;
            }
            case WRITE_LOCAL: {
                return false;
            }
            case WRITE_BEHIND: {
                return ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCAL) && ResourceRegistry.getContext().isDatastoreSupported(RRContext.DatastoreType.LOCALBUFFER);
            }
        }
        return false;
    }

    public void setInMemoryTargets(Set<Class<?>> items) {
        this.inMemoryTargets = items;
    }

    public void persistDirect(Class<?> item, String id) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void persistDirect(Class<?> items) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void persist(Set<Class<?>> items, Set<String> nonUpdateVOScopes) throws ResourceRegistryException {
        logger.info("starting aligning");
        this.alignOutgoing(items);
        logger.info("starting persisting");
        this.bridgeOutgoing(items, nonUpdateVOScopes);
        logger.info("finished persisting");
    }

    public void retrieve(Set<Class<?>> items) throws ResourceRegistryException {
        logger.info("starting retrieving");
        this.bridgeIncoming(items);
        logger.info("starting aligning");
        this.alignIncoming(items);
        logger.info("finished retrieving");
    }

    public void retrieveDirect(Class<?> item, String id) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void retrieveDirect(Class<?> item) throws ResourceRegistryException {
        throw new ResourceRegistryException("Operation not supported");
    }

    public void prefetchInMemoryItems() throws ResourceRegistryException {
        BridgeHelper.prefetchInMemoryItems(this.inMemoryTargets);
    }

    private void bridgeIncoming(Set<Class<?>> targets) throws ResourceRegistryException {
        try {
            BridgeHelper.retrieveScopes();
            FieldModel.retrieve();
            DatastoreHelper.clear((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, targets);
            for (Class<?> include : targets) {
                logger.info("retrieving info from IS for element " + include.getName());
                Set<IDaoElement> items = BridgeHelper.getElement(include);
                logger.info("buffering information retrieved for element " + include.getName());
                DatastoreHelper.bufferItems(items);
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not bridge incoming elements", (Throwable)ex);
        }
    }

    private void alignIncoming(Set<Class<?>> targets) throws ResourceRegistryException {
        boolean locked = false;
        Lock writeLock = ResourceRegistry.getContext().getExclusiveLock();
        try {
            boolean updateMode = !targets.contains(FieldDao.class) || !targets.contains(SearchableDao.class) || !targets.contains(PresentableDao.class);
            RRContext.DatastoreType datastoreType = ResourceRegistry.isInitialBridgingComplete() && updateMode ? RRContext.DatastoreType.LOCAL : RRContext.DatastoreType.LOCALBUFFER;
            logger.info("datastore type : " + datastoreType);
            List allFields = Field.getAll((boolean)true, (RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER);
            List allDataSources = DataSource.getAll((boolean)false, (RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER);
            writeLock.lock();
            locked = true;
            List updatedFieldsMetadata = ElementMetadata.getUpdatedFieldsMetadata((boolean)true);
            for (ElementMetadata m : updatedFieldsMetadata) {
                m.delete(true, RRContext.DatastoreType.LOCAL);
            }
            writeLock.unlock();
            locked = false;
            HashMap<String, Field> fieldIDs = new HashMap<String, Field>();
            HashMap<String, Field> fieldNames = new HashMap<String, Field>();
            logger.info("fields size : " + allFields.size());
            for (Field field : allFields) {
                fieldIDs.put(field.getID(), field);
                fieldNames.put(field.getName(), field);
            }
            logger.info("fieldIDs   : " + fieldIDs);
            logger.info("fieldNames : " + fieldNames);
            if (targets.contains(FieldIndexContainerDao.class)) {
                Set elems = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, FieldIndexContainerDao.class);
                HashSet purge = new HashSet();
                purge.add(FieldIndexContainerDao.class);
                DatastoreHelper.clear((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, (Set)purge);
                for (IDaoElement el : elems) {
                    Field f;
                    if (!(el instanceof FieldIndexContainerDao) || (f = (Field)fieldNames.get(((FieldIndexContainerDao)el).getField())) == null) continue;
                    ((FieldIndexContainerDao)el).setField(f.getID());
                }
                DatastoreHelper.bufferItems((Set)elems);
            }
            HashMap<String, DataSource> datasourcesMap = new HashMap<String, DataSource>();
            for (DataSource datasource : allDataSources) {
                if (datasourcesMap.get(datasource.getID()) != null) {
                    logger.warn(" datasource element " + datasource.getID() + " already in map");
                }
                datasourcesMap.put(datasource.getID(), datasource);
            }
            logger.info("will save searchables and presentables of " + allFields.size() + " fields");
            int i = 1;
            for (Field f : allFields) {
                Searchable item;
                DataSource ds;
                logger.info("will save searchables and presentables of the field # " + i);
                ++i;
                for (Searchable s : f.getSearchables()) {
                    ds = (DataSource)datasourcesMap.get(s.getLocator());
                    if (ds == null) {
                        logger.warn("no datasource for : " + s.getLocator());
                        continue;
                    }
                    logger.debug("### Datasource " + ds.getID() + " scopes : " + ds.getScopes() + " capabilities : " + ds.getCapabilities());
                    logger.debug("### Datasource : " + ds.deepToString());
                    if (ds.getScopes() != null) {
                        s.getDatasourceScopes().addAll(ds.getScopes());
                    }
                    item = new Searchable();
                    item.setID(s.getID());
                    item.setCollection(s.getCollection());
                    item.setField(s.getField());
                    item.setLocator(s.getLocator());
                    item.setExpression(s.getExpression());
                    item.setOrder(s.isOrder());
                    if (ds.getCapabilities() != null) {
                        item.getCapabilities().addAll(ds.getCapabilities());
                    }
                    item.setDatasourceScopes(s.getDatasourceScopes());
                    logger.debug("## will save searchable " + item.getID() + " from field : " + f.getID() + " , " + f.getName() + " from collection : " + s.getCollection() + " from locator : " + s.getLocator() + " scopes : " + ds.getScopes());
                    item.store(true, datastoreType);
                }
                for (Presentable p : f.getPresentables()) {
                    ds = (DataSource)datasourcesMap.get(p.getLocator());
                    if (ds == null) {
                        logger.warn("no datasource for : " + p.getLocator());
                        continue;
                    }
                    logger.debug("### Datasource " + ds.getID() + " scopes : " + ds.getScopes() + " capabilities : " + ds.getCapabilities());
                    logger.debug("### Datasource : " + ds.deepToString());
                    if (ds.getScopes() != null) {
                        p.getDatasourceScopes().addAll(ds.getScopes());
                    }
                    item = new Presentable();
                    item.setID(p.getID());
                    item.setCollection(p.getCollection());
                    item.setField(p.getField());
                    item.setLocator(p.getLocator());
                    item.setExpression(p.getExpression());
                    item.setOrder(p.isOrder());
                    item.setPresentationInfo(p.getPresentationInfo());
                    item.setDatasourceScopes(p.getDatasourceScopes());
                    logger.debug("## will save presentable " + item.getID() + " from field : " + f.getID() + " , " + f.getName() + "f rom collection : " + p.getCollection() + " from locator : " + p.getLocator() + " scopes : " + ds.getScopes());
                    item.store(true, datastoreType);
                }
            }
            logger.info("fininshed saving searchables and presentables of " + allFields.size() + " fields");
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not align incoming elements", (Throwable)ex);
        }
        finally {
            if (locked) {
                writeLock.unlock();
            }
        }
    }

    private void alignOutgoing(Set<Class<?>> targets) throws ResourceRegistryException {
    }

    /*
     * WARNING - void declaration
     */
    private void bridgeOutgoing(Set<Class<?>> targets, Set<String> nonUpdateVOScopes) throws ResourceRegistryException {
        try {
            String scopes;
            String serialization;
            String serialization2;
            Object scopes2;
            Resource resource;
            logger.info("retrieving field info from local");
            Set<IDaoElement> fields = new HashSet();
            Set<IDaoElement> searchables = new HashSet();
            Set<IDaoElement> presentables = new HashSet();
            Set<IDaoElement> metadata = new HashSet();
            IDaoElement staticConfig = null;
            boolean updateFields = false;
            boolean updateSearchables = false;
            boolean updatePresentables = false;
            boolean updateMetadata = false;
            boolean updateConfig = false;
            if (targets.contains(FieldDao.class)) {
                logger.info("retrieving info for " + FieldDao.class.getName());
                fields = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, FieldDao.class);
                logger.info("done retrieving info for " + fields.size() + " " + FieldDao.class.getName());
                updateFields = true;
            }
            if (targets.contains(SearchableDao.class)) {
                logger.info("retrieving info for " + SearchableDao.class.getName());
                searchables = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, SearchableDao.class);
                logger.info("done retrieving info for " + searchables.size() + " " + SearchableDao.class.getName());
                updateSearchables = true;
            }
            if (targets.contains(PresentableDao.class)) {
                logger.info("retrieving info for " + PresentableDao.class.getName());
                presentables = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, PresentableDao.class);
                logger.info("done retrieving info for " + presentables.size() + " " + PresentableDao.class.getName());
                updatePresentables = true;
            }
            if (targets.contains(ElementMetadataDao.class)) {
                logger.info("retrieving info for " + ElementMetadataDao.class.getName());
                metadata = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, ElementMetadataDao.class);
                logger.info("done retrieving info for " + metadata.size() + " " + ElementMetadataDao.class.getName());
                updateMetadata = true;
            }
            if (targets.contains(StaticConfigurationDao.class)) {
                logger.info("retrieving info for " + StaticConfigurationDao.class.getName());
                Set staticConfigs = DatastoreHelper.retrieveAll((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, StaticConfigurationDao.class);
                logger.info("done retrieving info for " + staticConfigs.size() + " " + StaticConfigurationDao.class.getName());
                if (staticConfigs.size() > 1) {
                    throw new ResourceRegistryException("Multiple static configuration elements were found");
                }
                if (!staticConfigs.isEmpty()) {
                    staticConfig = (IDaoElement)staticConfigs.iterator().next();
                }
                updateConfig = true;
            }
            Set datasourceIDs = DataSource.getAllIds();
            ArrayList<String> danglingPresentablesIDs = new ArrayList<String>();
            ArrayList<String> emptyScopePresentablesIDs = new ArrayList<String>();
            if (presentables != null) {
                for (IDaoElement pr : presentables) {
                    String datasourceID;
                    Iterator voScopes = BridgeHelper.getVOScopes(((PresentableDao)pr).getDatasourceScopes());
                    logger.info("presentable datasource scopes : " + voScopes);
                    if (nonUpdateVOScopes.containsAll((Collection<?>)((Object)voScopes))) {
                        logger.info("presentable : " + ((PresentableDao)pr).getID() + " has all its scopes in nonUpdateVOScopes");
                        emptyScopePresentablesIDs.add(((PresentableDao)pr).getID());
                    }
                    if (datasourceIDs.contains(datasourceID = ((PresentableDao)pr).getLocator())) continue;
                    danglingPresentablesIDs.add(((PresentableDao)pr).getID());
                }
            }
            logger.info("dangling presentables : " + danglingPresentablesIDs);
            logger.info("empty scope presentables : " + emptyScopePresentablesIDs);
            ArrayList<String> danglingSearchablesIDs = new ArrayList<String>();
            ArrayList<String> emptyScopeSearchablesIDs = new ArrayList<String>();
            if (searchables != null) {
                for (IDaoElement pr : searchables) {
                    String datasourceID;
                    Set<String> voScopes = BridgeHelper.getVOScopes(((SearchableDao)pr).getDatasourceScopes());
                    logger.info("searchable datasource scopes : " + voScopes);
                    if (nonUpdateVOScopes.containsAll(voScopes)) {
                        logger.info("searchable : " + ((SearchableDao)pr).getID() + " has all its scopes in nonUpdateVOScopes");
                        emptyScopeSearchablesIDs.add(((SearchableDao)pr).getID());
                    }
                    if (datasourceIDs.contains(datasourceID = ((SearchableDao)pr).getLocator())) continue;
                    danglingSearchablesIDs.add(((SearchableDao)pr).getID());
                }
            }
            logger.info("dangling searchables  : " + danglingSearchablesIDs);
            logger.info("empty scope searchables : " + emptyScopeSearchablesIDs);
            for (String danglingSearchableID : danglingSearchablesIDs) {
                Searchable s = new Searchable();
                s.setID(danglingSearchableID);
                s.load(true);
                s.delete(true);
            }
            for (String danglingPresentablesID : danglingPresentablesIDs) {
                Presentable p = new Presentable();
                p.setID(danglingPresentablesID);
                p.load(true);
                p.delete(true);
            }
            if (danglingPresentablesIDs.size() > 0) {
                updateMetadata = true;
                updateFields = true;
                updatePresentables = true;
                logger.info("will unmark deleted presentables");
                this.unmarkDeletedPresentables(danglingPresentablesIDs);
            }
            if (danglingSearchablesIDs.size() > 0) {
                updateMetadata = true;
                updateFields = true;
                updateSearchables = true;
                logger.info("will unmark deleted searchables");
                this.unmarkDeletedSearchables(danglingSearchablesIDs);
            }
            if (!(updateFields || updateSearchables || updatePresentables || updateMetadata || updateConfig)) {
                return;
            }
            logger.info("finished retrieving field info from local");
            ResourceRegistryException re = null;
            List<Resource> resources = null;
            if (updateFields) {
                logger.info("updating field directory gcube generic resource");
                try {
                    resources = BridgeHelper.getPublishedFieldResources();
                }
                catch (Exception ex) {
                    throw new ResourceRegistryException("could not retrieve remote field directory", (Throwable)ex);
                }
                logger.info("resources      : " + resources);
                if (resources != null) {
                    logger.info("resources size : " + resources.size());
                }
                if (resources.size() > 0) {
                    for (Resource resource2 : resources) {
                        void var24_32;
                        logger.info("updating field directory resource with id : " + resource2.getResourceID());
                        logger.info("---------------------------------------------------");
                        logger.info("Updating resource");
                        logger.info(resource2.getResourceID());
                        logger.info(resource2.getName());
                        logger.info(resource2.getDescription());
                        logger.info(resource2.getBodyAsString());
                        logger.info("---------------------------------------------------");
                        resource2.setDescription(Long.toString(new Date().getTime()));
                        logger.info("resource with id1 : " + resource2.getResourceID());
                        if (this.hasNonUpdaterVOScope(resource2, nonUpdateVOScopes)) {
                            logger.info("resource has a nonVOScope in : " + resource2.getScopes() + ". Creating new resource with id : " + resource2.getResourceID());
                            resource2 = GCubeRepositoryProvider.getResourceForNonUpdateScopes(nonUpdateVOScopes, RRModelGenericResourceName, RRModelGenericResourceSecondaryType);
                        }
                        logger.info("resource with id2 : " + resource2.getResourceID());
                        resource2.setDescription(Long.toString(new Date().getTime()));
                        Set<IDaoElement> updatedFields = BridgeHelper.updateFieldList(fields, searchables, presentables, emptyScopeSearchablesIDs, emptyScopePresentablesIDs);
                        if (updatedFields.size() == 0) {
                            logger.info("Updating resource");
                            logger.info(resource2.getResourceID());
                            logger.info(resource2.getName());
                            logger.info("skipping creation fields cause they have empty searchables and presentables");
                            continue;
                        }
                        String serialization3 = BridgeHelper.buildFieldDirectorySerialization(updatedFields);
                        String string = "(";
                        for (String s : BridgeHelper.getFieldModelScopes()) {
                            String string2 = (String)var24_32 + s + " ";
                        }
                        String string3 = (String)var24_32 + ")";
                        logger.trace("updating field directory resource serialization in scope " + string3 + " to :\n" + serialization3);
                        GCubeRepositoryProvider.addSerializationToResource(resource2, serialization3);
                        try {
                            BridgeHelper.publishFieldResource(resource2, false, nonUpdateVOScopes);
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                        }
                    }
                } else {
                    resource = new Resource();
                    logger.info("creating field directory resource. new id : " + resource.getResourceID());
                    resource.setName(RRModelGenericResourceName);
                    resource.setType(RRModelGenericResourceSecondaryType);
                    resource.setDescription(Long.toString(new Date().getTime()));
                    Set<IDaoElement> updatedFields = BridgeHelper.updateFieldList(fields, searchables, presentables, emptyScopeSearchablesIDs, emptyScopePresentablesIDs);
                    if (updatedFields.size() == 0) {
                        logger.info("Adding resource");
                        logger.info(resource.getResourceID());
                        logger.info(resource.getName());
                        logger.info("skipping creation fields cause they have empty searchables and presentables");
                    } else {
                        String serialization22 = BridgeHelper.buildFieldDirectorySerialization(updatedFields);
                        scopes2 = "(";
                        for (String s : BridgeHelper.getFieldModelScopes()) {
                            scopes2 = (String)scopes2 + s + " ";
                        }
                        scopes2 = (String)scopes2 + ")";
                        logger.trace("adding field directory resource serialization in scope " + (String)scopes2 + " to :\n" + (String)serialization22);
                        GCubeRepositoryProvider.addSerializationToResource(resource, serialization22);
                        try {
                            logger.info("Adding NEW resource : " + resource);
                            BridgeHelper.publishFieldResource(resource, true, nonUpdateVOScopes);
                            logger.info("Adding NEW resource done ");
                        }
                        catch (Exception exception) {
                            throw new ResourceRegistryException("could not publish remote field profile", (Throwable)exception);
                        }
                    }
                }
                logger.info("finished updating field directory gcube generic resource");
                List deletedFieldsMetadata = ElementMetadata.getDeletedFieldsMetadata((boolean)true);
                HashSet deletedFieldIds = new HashSet();
                for (ElementMetadata m : deletedFieldsMetadata) {
                    try {
                        resources = null;
                        try {
                            resources = BridgeHelper.getPublishedFieldResourcesForField((String)m.getProperties().get("id"));
                        }
                        catch (Exception exception) {
                            throw new ResourceRegistryException("could not retrieve remote field profile", (Throwable)exception);
                        }
                        if (resources.size() > 0) {
                            for (Resource resource3 : resources) {
                                String scopes4 = "(";
                                for (String s : BridgeHelper.getFieldModelScopes()) {
                                    scopes4 = scopes4 + s + " ";
                                }
                                scopes4 = scopes4 + ")";
                                logger.trace("deleting resource for field " + (String)m.getProperties().get("id") + " in scope " + scopes4);
                                try {
                                    BridgeHelper.deleteFieldResource(resource3, nonUpdateVOScopes);
                                    deletedFieldIds.add(m.getProperties().get("id"));
                                }
                                catch (Exception ex) {
                                    throw new ResourceRegistryException("could not delete remote field profile", (Throwable)ex);
                                }
                            }
                        }
                        m.delete(true, RRContext.DatastoreType.LOCAL);
                    }
                    catch (ResourceRegistryException resourceRegistryException) {
                        logger.warn("Could not delete remote field profiles");
                        re = resourceRegistryException;
                    }
                }
                List updatedFieldsMetadata = ElementMetadata.getUpdatedFieldsMetadata((boolean)true);
                HashSet updatedFieldIds = new HashSet();
                for (ElementMetadata m : updatedFieldsMetadata) {
                    updatedFieldIds.add(m.getProperties().get("id"));
                }
                logger.info("Updating fields");
                logger.info("updatedFieldIds " + updatedFieldIds);
                Set<String> set = this.getDeletedSearchables();
                set.addAll(danglingSearchablesIDs);
                set.addAll(emptyScopeSearchablesIDs);
                Set<String> deletedPresentables = this.getDeletedPresentables();
                deletedPresentables.addAll(danglingPresentablesIDs);
                deletedPresentables.addAll(emptyScopePresentablesIDs);
                for (IDaoElement f : fields) {
                    try {
                        FieldDao field = (FieldDao)f;
                        logger.info("1. updating gcube generic resource for field " + field.getName() + " (" + field.getID() + ")");
                        if (deletedFieldIds.contains(f.getID())) continue;
                        logger.info("2. updating gcube generic resource for field " + field.getName() + " (" + field.getID() + ")");
                        resources = null;
                        try {
                            resources = BridgeHelper.getPublishedFieldResourcesForField(field.getID());
                        }
                        catch (Exception ex) {
                            throw new ResourceRegistryException("could not retrieve remote field profile", (Throwable)ex);
                        }
                        logger.info("resources      : " + resources);
                        if (resources != null) {
                            logger.info("resources size : " + resources.size());
                        }
                        if (resources.size() > 0) {
                            for (Resource resource4 : resources) {
                                logger.info("updating field resource with id : " + resource4.getResourceID());
                                logger.info("resource with id1 : " + resource4.getResourceID());
                                Node bodyNode = resource4.getBody();
                                if (this.hasNonUpdaterVOScope(resource4, nonUpdateVOScopes)) {
                                    logger.info("resource has a nonVOScope in : " + resource4.getScopes() + ". Creating new resource with id : " + resource4.getResourceID());
                                    resource4 = GCubeRepositoryProvider.getResourceForNonUpdateScopes(nonUpdateVOScopes, RRModelGenericResourceName + "." + field.getID(), RRModelGenericResourceSecondaryType);
                                }
                                resource4.setDescription(Long.toString(new Date().getTime()));
                                logger.info("resource with id2 : " + resource4.getResourceID());
                                TransformerFactory transFactory = TransformerFactory.newInstance();
                                Transformer transformer = transFactory.newTransformer();
                                StringWriter buffer = new StringWriter();
                                transformer.setOutputProperty("omit-xml-declaration", "yes");
                                transformer.transform(new DOMSource(bodyNode), new StreamResult(buffer));
                                String bodySerialization = buffer.toString();
                                logger.trace("serialization1 : " + bodySerialization);
                                if (!BridgeHelper.shouldUpdateField((IDaoElement)field, searchables, presentables, emptyScopeSearchablesIDs, emptyScopePresentablesIDs)) {
                                    logger.info("1.####################################");
                                    logger.info("field ID   : " + field.getID());
                                    logger.info("field Name : " + field.getName());
                                    logger.info("field " + field.getID() + " - " + field.getName() + "has no presentables or searchable. skipping");
                                    logger.info("field will be emptied");
                                }
                                String serialization4 = BridgeHelper.updateFieldSerialization(bodySerialization, (IDaoElement)field, searchables, presentables, updateFields, updateSearchables, updatePresentables, set, deletedPresentables);
                                logger.info("1.####################################");
                                logger.info("field ID   : " + field.getID());
                                logger.info("field Name : " + field.getName());
                                logger.info(serialization4);
                                logger.info("field Searchables  : " + field.getSearchables());
                                logger.info("field Presentables : " + field.getPresentables());
                                logger.info("1.####################################");
                                String scopes5 = "(";
                                for (String s : BridgeHelper.getFieldModelScopes()) {
                                    scopes5 = scopes5 + s + " ";
                                }
                                scopes5 = scopes5 + ")";
                                logger.trace("updating resource serialization for field " + field.getName() + " (" + field.getID() + ") in scope " + scopes5 + " to :\n" + serialization4);
                                GCubeRepositoryProvider.addSerializationToResource(resource4, serialization4);
                                try {
                                    BridgeHelper.publishFieldResource(resource4, false, nonUpdateVOScopes);
                                }
                                catch (Exception ex) {
                                    throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                                }
                            }
                        } else {
                            Resource resource5 = new Resource();
                            logger.info("creating field resource. New  id : " + resource5.getResourceID());
                            resource5.setName(RRModelGenericResourceName + "." + field.getID());
                            resource5.setType(RRModelGenericResourceSecondaryType);
                            resource5.setDescription(Long.toString(new Date().getTime()));
                            if (!BridgeHelper.shouldUpdateField((IDaoElement)field, searchables, presentables, emptyScopeSearchablesIDs, emptyScopePresentablesIDs)) {
                                logger.info("2.####################################");
                                logger.info("field ID   : " + field.getID());
                                logger.info("field Name : " + field.getName());
                                logger.info("field " + field.getID() + " - " + field.getName() + "has no presentables or searchable. skipping");
                                continue;
                            }
                            String serialization5 = BridgeHelper.buildFieldSerialization((IDaoElement)field, searchables, presentables, set, deletedPresentables);
                            logger.info("2.####################################");
                            logger.info("field ID   : " + field.getID());
                            logger.info("field Name : " + field.getName());
                            logger.info(serialization5);
                            logger.info("field Searchables  : " + field.getSearchables());
                            logger.info("field Presentables : " + field.getPresentables());
                            logger.info("2.####################################");
                            String scopes6 = "(";
                            for (String s : BridgeHelper.getFieldModelScopes()) {
                                scopes6 = scopes6 + s + " ";
                            }
                            scopes6 = scopes6 + ")";
                            logger.trace("adding resource serialization for field " + field.getName() + " (" + field.getID() + ") in scope " + scopes6 + " to :\n" + serialization5);
                            GCubeRepositoryProvider.addSerializationToResource(resource5, serialization5);
                            try {
                                BridgeHelper.publishFieldResource(resource5, true, nonUpdateVOScopes);
                            }
                            catch (Exception ex) {
                                throw new ResourceRegistryException("could not publish remote field profile", (Throwable)ex);
                            }
                        }
                        logger.info("finished updating gcube generic resource");
                    }
                    catch (ResourceRegistryException e) {
                        re = e;
                        logger.warn("Error creating/updating gcube generic resource for field " + ((FieldDao)f).getName() + "(" + ((FieldDao)f).getID() + ")");
                    }
                }
            }
            if (updateMetadata) {
                logger.info("updating element metadata gcube generic resource");
                resources = null;
                try {
                    resources = BridgeHelper.getPublishedMetadataResources();
                }
                catch (Exception ex) {
                    throw new ResourceRegistryException("could not retrieve remote element metadata", (Throwable)ex);
                }
                if (resources.size() > 0) {
                    for (Resource resource2 : resources) {
                        logger.info("updating metadata resource. id : " + resource2.getResourceID());
                        logger.info("recource id1 : " + resource2.getResourceID());
                        if (this.hasNonUpdaterVOScope(resource2, nonUpdateVOScopes)) {
                            logger.info("resource has a nonVOScope in : " + resource2.getScopes() + ". Creating new resource with id : " + resource2.getResourceID());
                            resource2 = GCubeRepositoryProvider.getResourceForNonUpdateScopes(nonUpdateVOScopes, RRModelGenericResourceName + ".Metadata", RRModelGenericResourceSecondaryType);
                        }
                        logger.info("recource id2 : " + resource2.getResourceID());
                        resource2.setDescription(Long.toString(new Date().getTime()));
                        serialization2 = BridgeHelper.buildElementMetadataSerialization(metadata);
                        Object scopes22 = "(";
                        for (String s : BridgeHelper.getFieldModelScopes()) {
                            scopes22 = (String)scopes22 + s + " ";
                        }
                        scopes22 = (String)scopes22 + ")";
                        logger.trace("updating element metadata resource serialization in scope " + (String)scopes22 + " to :\n" + serialization2);
                        GCubeRepositoryProvider.addSerializationToResource(resource2, serialization2);
                        try {
                            BridgeHelper.publishFieldResource(resource2, false, nonUpdateVOScopes);
                        }
                        catch (Exception exception) {
                            throw new ResourceRegistryException("could not publish remote element metadata", (Throwable)exception);
                        }
                    }
                } else {
                    resource = new Resource();
                    logger.info("creating metadata resource. new id : " + resource.getResourceID());
                    resource.setName(RRModelGenericResourceName + ".Metadata");
                    resource.setType(RRModelGenericResourceSecondaryType);
                    resource.setDescription(Long.toString(new Date().getTime()));
                    serialization = BridgeHelper.buildElementMetadataSerialization(metadata);
                    scopes = "(";
                    for (String string : BridgeHelper.getFieldModelScopes()) {
                        scopes = scopes + string + " ";
                    }
                    scopes = scopes + ")";
                    logger.trace("adding element metadata resource serialization in scope " + scopes + " to :\n" + serialization);
                    GCubeRepositoryProvider.addSerializationToResource(resource, serialization);
                    try {
                        BridgeHelper.publishFieldResource(resource, true, nonUpdateVOScopes);
                    }
                    catch (Exception ex) {
                        throw new ResourceRegistryException("could not publish remote field profiles", (Throwable)ex);
                    }
                }
                logger.info("finished updating element metadata gcube generic resource");
            }
            if (updateConfig) {
                logger.info("updating static configuration gcube generic resource");
                resources = null;
                try {
                    resources = BridgeHelper.getPublishedStaticConfigResources();
                }
                catch (Exception ex) {
                    throw new ResourceRegistryException("could not retrieve remote static configuration", (Throwable)ex);
                }
                if (resources.size() > 0) {
                    for (Resource resource2 : resources) {
                        logger.info("updating static config resource. id : " + resource2.getResourceID());
                        logger.info("resource id1 :" + resource2.getResourceID());
                        if (this.hasNonUpdaterVOScope(resource2, nonUpdateVOScopes)) {
                            logger.info("resource has a nonVOScope in : " + resource2.getScopes() + ". Creating new resource with id : " + resource2.getResourceID());
                            resource2 = GCubeRepositoryProvider.getResourceForNonUpdateScopes(nonUpdateVOScopes, RRModelGenericResourceName + ".StaticConfig", RRModelGenericResourceSecondaryType);
                        }
                        logger.info("resource id2 :" + resource2.getResourceID());
                        resource2.setDescription(Long.toString(new Date().getTime()));
                        serialization2 = BridgeHelper.buildStaticConfigSerialization(staticConfig);
                        scopes2 = "(";
                        for (String s : BridgeHelper.getFieldModelScopes()) {
                            scopes2 = (String)scopes2 + s + " ";
                        }
                        scopes2 = (String)scopes2 + ")";
                        logger.trace("updating static configuration resource serialization in scope " + (String)scopes2 + " to :\n" + serialization2);
                        GCubeRepositoryProvider.addSerializationToResource(resource2, serialization2);
                        try {
                            BridgeHelper.publishFieldResource(resource2, false, nonUpdateVOScopes);
                        }
                        catch (Exception exception) {
                            throw new ResourceRegistryException("could not publish remote element metadata", (Throwable)exception);
                        }
                    }
                } else {
                    resource = new Resource();
                    logger.info("creating static config resource. new id : " + resource.getResourceID());
                    resource.setName(RRModelGenericResourceName + ".StaticConfig");
                    resource.setType(RRModelGenericResourceSecondaryType);
                    resource.setDescription(Long.toString(new Date().getTime()));
                    serialization = BridgeHelper.buildStaticConfigSerialization(staticConfig);
                    scopes = "(";
                    for (String string : BridgeHelper.getFieldModelScopes()) {
                        scopes = scopes + string + " ";
                    }
                    scopes = scopes + ")";
                    logger.trace("adding static configuration resource serialization in scope " + scopes + " to :\n" + serialization);
                    GCubeRepositoryProvider.addSerializationToResource(resource, serialization);
                    try {
                        BridgeHelper.publishFieldResource(resource, true, nonUpdateVOScopes);
                    }
                    catch (Exception ex) {
                        throw new ResourceRegistryException("could not publish remote static configuration", (Throwable)ex);
                    }
                }
                logger.info("finished updating static configuration gcube generic resource");
            }
            if (re != null) {
                throw re;
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not bridge outgoing elements", (Throwable)ex);
        }
    }

    private static void addSerializationToResource(Resource resource, String serialization) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        Node newBody = XMLConverter.stringToNode((String)serialization);
        resource.setBody(newBody);
    }

    boolean hasNonUpdaterVOScope(Resource resource, Set<String> nonUpdaterVOScopes) {
        logger.debug("resource scopes : " + resource.getScopes());
        logger.debug("scope           : " + nonUpdaterVOScopes);
        for (String scope : nonUpdaterVOScopes) {
            if (!resource.getScopes().contains(scope)) continue;
            return true;
        }
        return false;
    }

    void unmarkDeletedSearchables(List<String> searchables) {
        ArrayList<ElementMetadata> deletedMetadata = new ArrayList<ElementMetadata>();
        try {
            List deletedSearchables = ElementMetadata.getDeletedSearchablesMetadata((boolean)true);
            logger.info("deleted searchables elementes : " + deletedSearchables.size());
            for (ElementMetadata em : deletedSearchables) {
                if (em == null) continue;
                if (em.getProperties() == null) {
                    logger.warn("em : " + em.getID() + " has no properties");
                    continue;
                }
                if (em.getProperties().get("searchable_id") == null) {
                    logger.warn("em : " + em.getID() + " has no searchable_id in properties");
                    continue;
                }
                String[] valParts = ((String)em.getProperties().get("searchable_id")).split("#");
                if (valParts == null || valParts.length == 0) {
                    logger.warn("em : " + em.getID() + " searchable_id has no #");
                    continue;
                }
                String searchableID = valParts[valParts.length - 1];
                if (!searchables.contains(searchableID)) continue;
                deletedMetadata.add(em);
            }
            logger.warn("found : " + deletedMetadata.size() + " out of : " + searchables.size());
            for (ElementMetadata em : deletedMetadata) {
                try {
                    em.delete(true);
                }
                catch (Exception e) {
                    logger.warn("error deleting element metadata : " + em.getID());
                }
            }
        }
        catch (ResourceRegistryException e) {
            logger.warn("error in unmarking deleted searchables", (Throwable)e);
        }
    }

    Set<String> getDeletedSearchables() {
        HashSet<String> deleted = new HashSet<String>();
        try {
            List deletedSearchables = ElementMetadata.getDeletedSearchablesMetadata((boolean)true);
            logger.info("deleted searchables elementes : " + deletedSearchables.size());
            for (ElementMetadata em : deletedSearchables) {
                if (em == null) continue;
                if (em.getProperties() == null) {
                    logger.warn("em : " + em.getID() + " has no properties");
                    continue;
                }
                if (em.getProperties().get("searchable_id") == null) {
                    logger.warn("em : " + em.getID() + " has no searchable_id in properties");
                    continue;
                }
                String[] valParts = ((String)em.getProperties().get("searchable_id")).split("#");
                if (valParts == null || valParts.length == 0) {
                    logger.warn("em : " + em.getID() + " searchable_id has no #");
                    continue;
                }
                deleted.add(valParts[valParts.length - 1]);
            }
        }
        catch (ResourceRegistryException e) {
            logger.warn("error in deleted searchables", (Throwable)e);
        }
        logger.info("deleted searchables : " + deleted);
        return deleted;
    }

    void unmarkDeletedPresentables(List<String> presentables) {
        ArrayList<ElementMetadata> deletedMetadata = new ArrayList<ElementMetadata>();
        try {
            List deletedPresentables = ElementMetadata.getDeletedPresentablesMetadata((boolean)true);
            logger.info("deleted presentables elements : " + deletedPresentables.size());
            for (ElementMetadata em : deletedPresentables) {
                if (em == null) continue;
                if (em.getProperties() == null) {
                    logger.warn("em : " + em.getID() + " has no properties");
                    continue;
                }
                if (em.getProperties().get("presentable_id") == null) {
                    logger.warn("em : " + em.getID() + " has no presentable_id in properties");
                    continue;
                }
                String[] valParts = ((String)em.getProperties().get("presentable_id")).split("#");
                if (valParts == null || valParts.length == 0) {
                    logger.warn("em : " + em.getID() + " presentable_id has no #");
                    continue;
                }
                String presentableID = valParts[valParts.length - 1];
                if (!presentables.contains(presentableID)) continue;
                deletedMetadata.add(em);
            }
            logger.warn("found : " + deletedMetadata.size() + " out of : " + presentables.size());
            for (ElementMetadata em : deletedMetadata) {
                try {
                    em.delete(true);
                }
                catch (Exception e) {
                    logger.warn("error deleting element metadata : " + em.getID());
                }
            }
        }
        catch (ResourceRegistryException e) {
            logger.warn("error in unmarking deleted presentables", (Throwable)e);
        }
    }

    Set<String> getDeletedPresentables() {
        HashSet<String> deleted = new HashSet<String>();
        try {
            List deletedPresentables = ElementMetadata.getDeletedPresentablesMetadata((boolean)true);
            logger.info("deleted presentables elements : " + deletedPresentables.size());
            for (ElementMetadata em : deletedPresentables) {
                if (em == null) continue;
                if (em.getProperties() == null) {
                    logger.warn("em : " + em.getID() + " has no properties");
                    continue;
                }
                if (em.getProperties().get("presentable_id") == null) {
                    logger.warn("em : " + em.getID() + " has no presentable_id in properties");
                    continue;
                }
                String[] valParts = ((String)em.getProperties().get("presentable_id")).split("#");
                if (valParts == null || valParts.length == 0) {
                    logger.warn("em : " + em.getID() + " presentable_id has no #");
                    continue;
                }
                deleted.add(valParts[valParts.length - 1]);
            }
        }
        catch (ResourceRegistryException e) {
            logger.warn("error in deleted presentables", (Throwable)e);
        }
        logger.info("deleted presentables : " + deleted);
        return deleted;
    }

    static Set<String> difference(Set<String> set1, Set<String> set2) {
        HashSet newSet = Sets.newHashSet(set1);
        newSet.removeAll(set2);
        return newSet;
    }

    static boolean checkIfExists(String resourceName, String resourceType, Set<String> scopes) {
        return BridgeHelper.checkIfExists(resourceName, resourceType, scopes);
    }

    static Resource getResourceForNonUpdateScopes(Set<String> nonUpdateVOScopes, String resourceName, String resourceType) throws Exception {
        Resource resource = null;
        Set<String> tobeupdatedScopes = GCubeRepositoryProvider.difference(Sets.newHashSet(BridgeHelper.getFieldModelScopes()), nonUpdateVOScopes);
        if (GCubeRepositoryProvider.checkIfExists(resourceName, resourceType, tobeupdatedScopes)) {
            logger.info("resource has already been created for " + resourceName + " for scopes : " + tobeupdatedScopes);
            resource = BridgeHelper.getResourceByNameAndType(resourceName, resourceType, tobeupdatedScopes);
            resource.setDescription(Long.toString(new Date().getTime()));
        } else {
            logger.info("resource does not exist for scopes : " + tobeupdatedScopes);
            resource = new Resource();
            resource.setBody(null);
            resource.setName(resourceName);
            resource.setType(resourceType);
            resource.setDescription(Long.toString(new Date().getTime()));
        }
        return resource;
    }

    static {
        BridgeHelper.initializeIndexTypes();
    }
}

