/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.urlresolutionlibrary;

import gr.uoa.di.madgik.urlresolutionlibrary.ILocator;
import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.LocatorException;
import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.ParseException;
import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.URLResolverException;
import gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable.BittorrentLocator;
import gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable.GridFTPLocator;
import gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable.NonStreamable;
import gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable.StreamableDecorator;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.FTPLocator;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.HTTPLocator;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.LocalFileLocator;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.SFTPLocator;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.Streamable;

public class ResolveFactory {
    private static ILocator getLocator(String url) throws ParseException {
        if (url.toLowerCase().startsWith("ftp") || url.toLowerCase().startsWith("ftps")) {
            return new FTPLocator(url);
        }
        if (url.toLowerCase().startsWith("sftp")) {
            return new SFTPLocator(url);
        }
        if (url.toLowerCase().startsWith("https")) {
            return new HTTPLocator(url);
        }
        if (url.toLowerCase().startsWith("gridftp")) {
            return new GridFTPLocator(url);
        }
        if (url.toLowerCase().startsWith("bittorrent")) {
            return new BittorrentLocator(url);
        }
        if (url.toLowerCase().startsWith("file")) {
            return new LocalFileLocator(url);
        }
        return null;
    }

    public static Streamable getStreamableLocator(String url) throws URLResolverException {
        ILocator loc = ResolveFactory.getLocator(url);
        Streamable sloc = null;
        if (loc instanceof NonStreamable) {
            sloc = new StreamableDecorator((NonStreamable)loc);
        } else if (loc instanceof Streamable) {
            sloc = (Streamable)loc;
        } else {
            throw new LocatorException("this type of locator " + url + " cannot be converted to streamable");
        }
        return sloc;
    }
}

