/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.urlresolutionlibrary.streamable;

import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.ParseException;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.Streamable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;

public class HTTPSimpleLocator
implements Streamable {
    private static Logger logger = Logger.getLogger(HTTPSimpleLocator.class.getName());
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    private boolean isSecure = false;
    private String url;
    private InputStream is;

    public HTTPSimpleLocator(String url) throws ParseException {
        this.url = url;
        this.parseURL(url);
    }

    private void parseURL(String url) throws ParseException {
        String tmpUrl = url.trim();
        if (!tmpUrl.startsWith("http://")) {
            if (!tmpUrl.startsWith("https://")) {
                throw new ParseException("url is not in http(s) format");
            }
            this.isSecure = true;
        }
        logger.log(Level.INFO, "Parsing results for : " + url);
        logger.log(Level.INFO, "Secure \t : " + this.isSecure);
    }

    @Override
    public InputStream getInputStream() throws Exception {
        URL url = new URL(this.url);
        HttpURLConnection urlConnection = null;
        urlConnection = this.isSecure ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
        this.is = urlConnection.getInputStream();
        return this.is;
    }

    @Override
    public void close() {
        try {
            this.is.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "HTTPSimple Locator inputstream close failed", e);
        }
    }
}

