/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.workflowengine.service.test;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.gcube.execution.workflowengine.service.stubs.ExecutionEvent;
import org.gcube.execution.workflowengine.service.stubs.StatusReport;
import org.gcube.execution.workflowengine.service.stubs.StatusRequest;
import org.gcube.execution.workflowengine.service.stubs.WorkflowEngineServicePortType;
import org.gcube.execution.workflowengine.service.test.TestAdaptorBase;

public class TestJobStatus
extends TestAdaptorBase {
    private static final long SleepTime = 60000L;

    private static void PrintHelp() {
        StringBuilder buf = new StringBuilder();
        buf.append("Usage:\n");
        buf.append("Three arguments are needed\n");
        buf.append("1) the path of the file that containing the execution identifier\n");
        buf.append("2) true | false whether the execution plan should be retrieved\n");
        buf.append("3) true | false whether the program should continue monitoring the execution until it is completed\n");
        System.out.println(buf.toString());
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            TestJobStatus.PrintHelp();
            return;
        }
        boolean includePlan = false;
        try {
            includePlan = Boolean.parseBoolean(args[1]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        boolean persistStatus = false;
        try {
            persistStatus = Boolean.parseBoolean(args[2]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        String url = TestAdaptorBase.GetWorkflowEngineURL(args[0]);
        String execid = TestAdaptorBase.GetWorkflowEngineExecutionID(args[0]);
        String scope = TestAdaptorBase.GetWorkflowEngineExecutionScope(args[0]);
        System.out.println("Contacting : " + url);
        System.out.println("Execution identifier : " + execid);
        System.out.println("Scope : " + scope);
        WorkflowEngineServicePortType wf = TestAdaptorBase.GetWorkflowEnginePortType(scope, url);
        while (true) {
            StringBuilder buf;
            System.out.println("Sending Request");
            StatusRequest req = new StatusRequest();
            req.setExecutionID(execid);
            req.setIncludePlan(Boolean.valueOf(includePlan));
            StatusReport rep = wf.executionStatus(req);
            System.out.println("Processing Report");
            if (includePlan || rep.isIsCompleted()) {
                System.out.println("Written Execution plan to " + TestAdaptorBase.WritePlan(rep.getPlan(), rep.isIsCompleted()));
            }
            if (rep.getEvents() != null) {
                for (ExecutionEvent executionEvent : rep.getEvents()) {
                    buf = new StringBuilder();
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(executionEvent.getEventTimestamp());
                    SimpleDateFormat dformat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                    buf.append("At " + dformat.format(cal.getTime()) + " received " + executionEvent.getEventType());
                    if (executionEvent.getPerformanceEventInfo() != null) {
                        buf.append("from element '" + executionEvent.getPerformanceEventInfo().getEmiterID() + "' total time '" + executionEvent.getPerformanceEventInfo().getTotalTime() + "' (init:'" + executionEvent.getPerformanceEventInfo().getInitializationTime() + "' finalize:'" + executionEvent.getPerformanceEventInfo().getFinalizationTime() + "') children:'" + executionEvent.getPerformanceEventInfo().getChildrenTotalTime() + "' number of subcalls '" + executionEvent.getPerformanceEventInfo().getNumberOfSubcalls() + "' with total subcall time '" + executionEvent.getPerformanceEventInfo().getSubcallsTotalTime() + "'");
                    }
                    if (executionEvent.getProgressEventInfo() != null) {
                        buf.append("from element '" + executionEvent.getProgressEventInfo().getEmiterID());
                        if (executionEvent.getProgressEventInfo().isReportProgress()) {
                            buf.append(" progress : " + executionEvent.getProgressEventInfo().getCurrentStep() + "/" + executionEvent.getProgressEventInfo().getTotalStep());
                        }
                        if (executionEvent.getProgressEventInfo().isReportNodeProgress()) {
                            buf.append(" node : " + executionEvent.getProgressEventInfo().getNodeName() + " (" + executionEvent.getProgressEventInfo().getNodeHostName() + ":" + executionEvent.getProgressEventInfo().getNodePort() + ")");
                        }
                        if (executionEvent.getProgressEventInfo().getMessage() != null && executionEvent.getProgressEventInfo().getMessage().trim().length() > 0) {
                            buf.append(" message : " + executionEvent.getProgressEventInfo().getMessage());
                        }
                    }
                    if (executionEvent.getProgressExternalEventInfo() != null) {
                        buf.append("from element '" + executionEvent.getProgressExternalEventInfo().getEmiterID() + " (" + executionEvent.getProgressExternalEventInfo().getExternalEmiterName() + ")");
                        if (executionEvent.getProgressExternalEventInfo().isReportProgress()) {
                            buf.append(" progress : " + executionEvent.getProgressExternalEventInfo().getCurrentStep() + "/" + executionEvent.getProgressExternalEventInfo().getTotalStep());
                        }
                        if (executionEvent.getProgressExternalEventInfo().getMessage() != null && executionEvent.getProgressExternalEventInfo().getMessage().trim().length() > 0) {
                            buf.append(" message : " + executionEvent.getProgressExternalEventInfo().getMessage());
                        }
                    }
                    System.out.println(buf.toString());
                }
            } else {
                System.out.println("No new events");
            }
            if (rep.isIsCompleted()) {
                System.out.println("Execution has completed");
                if (rep.getError() != null && rep.getError().trim().length() > 0) {
                    System.out.println("Error reported : \n" + rep.getError());
                    System.out.println("Error details Retrieved : \n" + rep.getErrorDetails());
                }
                if (rep.getOutput() != null) {
                    System.out.println("Job output :");
                    for (ExecutionEvent executionEvent : rep.getOutput()) {
                        buf = new StringBuilder();
                        if (executionEvent.getKey() != null && executionEvent.getKey().trim().length() > 0) {
                            buf.append("key : " + executionEvent.getKey());
                        } else {
                            buf.append("key : Not available");
                        }
                        if (executionEvent.getSubKey() != null && executionEvent.getSubKey().trim().length() > 0) {
                            buf.append(" subkey : " + executionEvent.getSubKey());
                        } else {
                            buf.append(" subkey : Not available");
                        }
                        if (executionEvent.getStorageSystemID() != null && executionEvent.getStorageSystemID().trim().length() > 0) {
                            buf.append(" StorageSystem ID : " + executionEvent.getStorageSystemID());
                        } else {
                            buf.append(" StorageSystem ID : Not available");
                        }
                        System.out.println(buf.toString());
                    }
                }
            } else {
                System.out.println("Execution has not yet completed");
            }
            if (!persistStatus || rep.isIsCompleted()) break;
            includePlan = false;
            System.out.println("Sleeping for 60 seconds");
            try {
                Thread.sleep(60000L);
            }
            catch (Exception ex) {}
        }
    }
}

