/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.couchbase.entities;

import com.couchbase.client.CouchbaseClient;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.spy.memcached.internal.OperationFuture;
import org.gcube.couchbase.entities.ForwardIndexDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaIndex
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MetaIndex.class);
    private static Gson gson = new Gson();
    private static String META_INDEX_KEY = "METAINDEX";
    private Set<String> collections = new HashSet<String>();
    private Set<String> fields = new HashSet<String>();
    private Set<String> searchables = new HashSet<String>();
    private Set<String> presentables = new HashSet<String>();
    private Map<String, String> indexKeys = new HashMap<String, String>();

    public Set<String> getSearchables() {
        return this.searchables;
    }

    public Set<String> getPresentables() {
        return this.presentables;
    }

    public Set<String> getCollections() {
        return this.collections;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public Map<String, String> getIndexKeys() {
        return this.indexKeys;
    }

    public String toString() {
        return "MetaIndex [collections=" + this.collections + ", fields=" + this.fields + ", searchables=" + this.searchables + ", presentables=" + this.presentables + ", indexKeys=" + this.indexKeys + "]";
    }

    public Boolean saveToDatabase(CouchbaseClient client) {
        return MetaIndex.saveMetaIndexToDatabase(client, this);
    }

    public void updateFromDoc(ForwardIndexDocument doc) {
        MetaIndex.updateMetaFromDoc(this, doc);
    }

    public void loadFromDatabase(CouchbaseClient client) {
        MetaIndex meta = MetaIndex.loadMetaFromDatabase(client);
        this.collections = new HashSet<String>(meta.collections);
        this.searchables = new HashSet<String>(meta.searchables);
        this.presentables = new HashSet<String>(meta.presentables);
        this.fields = new HashSet<String>(meta.fields);
        this.indexKeys = new HashMap<String, String>(meta.indexKeys);
    }

    public static Boolean saveMetaIndexToDatabase(CouchbaseClient client, MetaIndex meta) {
        return MetaIndex.saveMetaIndexToDatabase(client, meta.collections, meta.fields, meta.searchables, meta.presentables, meta.indexKeys);
    }

    private static Boolean saveMetaIndexToDatabase(CouchbaseClient client, Set<String> collections, Set<String> fields, Set<String> searchables, Set<String> presentables, Map<String, String> indexKeys) {
        logger.info("The following will be added : ");
        logger.info("collections  : " + collections);
        logger.info("fields       : " + fields);
        logger.info("searchables  : " + searchables);
        logger.info("presentables : " + presentables);
        logger.info("index keys   : " + indexKeys);
        Object metaIndexValueObj = null;
        MetaIndex meta = null;
        try {
            metaIndexValueObj = client.get(META_INDEX_KEY);
            if (metaIndexValueObj != null) {
                String json = (String)metaIndexValueObj;
                meta = (MetaIndex)gson.fromJson(json, MetaIndex.class);
            } else {
                meta = new MetaIndex();
            }
        }
        catch (Exception e) {
            meta = new MetaIndex();
        }
        meta.collections.addAll(collections);
        meta.fields.addAll(fields);
        meta.searchables.addAll(searchables);
        meta.presentables.addAll(presentables);
        meta.indexKeys.putAll(indexKeys);
        String updatedValue = gson.toJson((Object)meta);
        OperationFuture res = null;
        int tries = 12;
        Exception ex = null;
        while (tries > 0) {
            res = client.set(META_INDEX_KEY, 0, (Object)updatedValue);
            try {
                Boolean result = (boolean)((Boolean)res.get());
                if (result.booleanValue()) {
                    logger.info("Meta Index successfully updated");
                } else {
                    logger.info("Meta Index NOT successfully updated");
                }
                return result;
            }
            catch (Exception e) {
                ex = e;
                logger.info("Waiting a bit (3 sec)");
                logger.info("tries left : " + --tries);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e2) {
                    logger.error("Error while sleeping: ", (Throwable)e2);
                }
            }
        }
        if (tries == 0) {
            logger.error("Error while updating the meta index: ", ex);
        }
        return false;
    }

    public static MetaIndex loadMetaFromDatabase(CouchbaseClient client) {
        Object metaIndexValueObj = client.get(META_INDEX_KEY);
        MetaIndex meta = null;
        if (metaIndexValueObj != null) {
            String json = (String)metaIndexValueObj;
            meta = (MetaIndex)gson.fromJson(json, MetaIndex.class);
            logger.info("Meta index loaded");
            logger.info(meta.toString());
        } else {
            meta = new MetaIndex();
            logger.info("New Meta index loaded");
        }
        return meta;
    }

    public static void updateMetaFromDoc(MetaIndex meta, ForwardIndexDocument doc) {
        String colId = doc.getColId();
        meta.collections.add(colId);
        meta.searchables.addAll(doc.getKeys().keySet());
        meta.presentables.addAll(doc.getFields().keySet());
        String fieldPrefix = colId + ":" + doc.getDocLang();
        for (String searchable : doc.getKeys().keySet()) {
            meta.fields.add(fieldPrefix + ":" + "s" + ":" + searchable);
        }
        for (String presentable : doc.getFields().keySet()) {
            meta.fields.add(fieldPrefix + ":" + "p" + ":" + presentable);
        }
    }
}

