/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.couchbase.helpers;

import com.google.gson.Gson;
import java.util.HashMap;
import org.gcube.indexmanagement.common.ForwardIndexField;

public class CouchBaseDataTypesHelper {
    private static Gson gson = new Gson();
    private static final String TYPE_ELEMENT = "type";
    private static final String VALUE_ELEMENT = "value";

    public static DataType getDataType(ForwardIndexField.DataType datatype) {
        DataType ret = null;
        switch (datatype) {
            case INT: {
                ret = DataType.INTEGER;
                break;
            }
            case DATE: {
                ret = DataType.DATE;
                break;
            }
            case FLOAT: {
                ret = DataType.FLOAT;
                break;
            }
            case STRING: {
                ret = DataType.STRING;
                break;
            }
        }
        return ret;
    }

    private static String toJSON(String type, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TYPE_ELEMENT, type);
        map.put(VALUE_ELEMENT, value);
        return gson.toJson(map);
    }

    public static String getIntegerDoc(String value) {
        return CouchBaseDataTypesHelper.toJSON(DataType.INTEGER.toString(), value);
    }

    public static String getFloatDoc(String value) {
        return CouchBaseDataTypesHelper.toJSON(DataType.FLOAT.toString(), value);
    }

    public static String getStringDoc(String value) {
        return CouchBaseDataTypesHelper.toJSON(DataType.STRING.toString(), value);
    }

    public static String getDateDoc(String value) {
        return CouchBaseDataTypesHelper.toJSON(DataType.DATE.toString(), value);
    }

    public static Object convertToObject(String value, DataType dataType) {
        Object obj = null;
        switch (dataType) {
            case INTEGER: {
                obj = Integer.valueOf(value);
                break;
            }
            case DATE: {
                obj = Long.valueOf(value);
                break;
            }
            case FLOAT: {
                obj = Float.valueOf(value);
                break;
            }
            case STRING: {
                obj = value;
                break;
            }
        }
        return obj;
    }

    public static String getDoc(String value, DataType dataType) {
        String doc = null;
        switch (dataType) {
            case INTEGER: {
                doc = CouchBaseDataTypesHelper.getIntegerDoc(value);
                break;
            }
            case DATE: {
                doc = CouchBaseDataTypesHelper.getDateDoc(value);
                break;
            }
            case FLOAT: {
                doc = CouchBaseDataTypesHelper.getFloatDoc(value);
                break;
            }
            case STRING: {
                doc = CouchBaseDataTypesHelper.getStringDoc(value);
                break;
            }
        }
        return doc;
    }

    public static enum DataType {
        INTEGER("integer"),
        FLOAT("float"),
        STRING("string"),
        DATE("date");

        private final String name;

        private DataType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

