package org.gcube.couchbase.helpers;

import java.util.HashMap;
import java.util.Map;

import com.google.gson.Gson;

/**
 * 
 * @author Alex Antoniadis
 * 
 */
public class CouchBaseDataTypesHelper {

	private static Gson gson = new Gson();

	private static final String TYPE_ELEMENT = "type";
	private static final String VALUE_ELEMENT = "value";

	public enum DataType {
		INTEGER("integer"), FLOAT("float"), STRING("string"), DATE("date");

		private DataType(String name) {
			this.name = name;
		}

		private final String name;

		@Override
		public String toString() {
			return name;
		}
	};

	// TODO: this should change so we will have only one datatype
	public static DataType getDataType(org.gcube.indexmanagement.common.ForwardIndexField.DataType datatype) {
		DataType ret = null;

		switch (datatype) {
		case INT:
			ret = DataType.INTEGER;
			break;
		case DATE:
			ret = DataType.DATE;
			break;
		case FLOAT:
			ret = DataType.FLOAT;
			break;
		case STRING:
			ret = DataType.STRING;
			break;
		default:
			break;
		}

		return ret;
	}

	private static String toJSON(String type, String value) {
		Map<String, String> map = new HashMap<String, String>();
		map.put(TYPE_ELEMENT, type);
		map.put(VALUE_ELEMENT, value);

		return gson.toJson(map);
	}

	public static String getIntegerDoc(String value) {
		return toJSON(DataType.INTEGER.toString(), value);
	}

	public static String getFloatDoc(String value) {
		return toJSON(DataType.FLOAT.toString(), value);
	}

	public static String getStringDoc(String value) {
		return toJSON(DataType.STRING.toString(), value);
	}

	public static String getDateDoc(String value) {
		return toJSON(DataType.DATE.toString(), value);
	}

	public static Object convertToObject(String value, DataType dataType) {
		Object obj = null;

		switch (dataType) {
		case INTEGER:
			obj = Integer.valueOf(value);
			break;
		case DATE:
			obj = Long.valueOf(value);
			break;
		case FLOAT:
			obj = Float.valueOf(value);
			break;
		case STRING:
			obj = value;
			break;
		default:
			break;
		}

		return obj;
	}

	public static String getDoc(String value, DataType dataType) {
		String doc = null;

		switch (dataType) {
		case INTEGER:
			doc = getIntegerDoc(value);
			break;
		case DATE:
			doc = getDateDoc(value);
			break;
		case FLOAT:
			doc = getFloatDoc(value);
			break;
		case STRING:
			doc = getStringDoc(value);
			break;
		default:
			break;
		}
		return doc;
	}
}
