/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gcube.elasticsearch.FullTextNode;
import org.gcube.rest.index.common.discover.IndexDiscovererAPI;
import org.gcube.rest.index.common.resources.IndexResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class IndexClientWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MAXIMUM_FRAGMENT_CNT = "maxFragmentCnt";
    private static final String MAXIMUM_FRAGMENT_SIZE = "maxFragmentSize";
    private static final String NO_REPLICAS = "noReplicas";
    private static final String NO_SHARDS = "noShards";
    private static final String ELASTICSEARCH_PORT = "elasticSearchPort";
    private static final String USE_RRADAPTOR = "useRRAdaptor";
    private static final String DATA_DIRECTORY = "dataDir";
    private static final String MAX_RESULTS = "maxResults";
    private static final String HOSTNAME = "hostname";
    private FullTextNode ftn;
    private static final Logger logger = LoggerFactory.getLogger(IndexClientWrapper.class);
    private IndexDiscovererAPI<IndexResource> indexDiscoverer;

    public IndexClientWrapper(IndexDiscovererAPI<IndexResource> indexDiscoverer) {
        logger.info("Creating a new FullTextNodeClient with indexDiscoverer : " + indexDiscoverer);
        this.indexDiscoverer = indexDiscoverer;
    }

    public void initialize(String transformedClusterName, String clusterID, String scope) throws ResourceRegistryException, InterruptedException {
        try {
            Properties properties = new Properties();
            try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
                properties.load(is);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("could not load property file  : deploy.properties");
            }
            Integer fragm_cnt = Integer.valueOf(properties.getProperty("maxFragmentCnt").trim());
            Integer fragm_size = Integer.valueOf(properties.getProperty("maxFragmentSize").trim());
            Integer noReplicas = Integer.valueOf(properties.getProperty("noReplicas").trim());
            Integer noShards = Integer.valueOf(properties.getProperty("noShards").trim());
            Integer esPort = Integer.valueOf(properties.getProperty("elasticSearchPort").trim());
            Integer maxResults = null;
            try {
                maxResults = Integer.valueOf(properties.getProperty("maxResults").trim());
            }
            catch (Exception e) {
                logger.info("maxResults not given");
            }
            String dataDirectory = properties.getProperty("dataDir");
            Boolean useRRAdaptor = Boolean.valueOf(properties.getProperty("useRRAdaptor"));
            String hostname = properties.getProperty("hostname");
            logger.info("Data read from jndi");
            logger.info("fragm_cnt           : " + fragm_cnt);
            logger.info("fragm_size          : " + fragm_size);
            logger.info("noReplicas          : " + noReplicas);
            logger.info("noShards            : " + noShards);
            logger.info("esPort              : " + esPort);
            logger.info("dataDirectory       : " + dataDirectory);
            logger.info("useRRAdaptor        : " + useRRAdaptor);
            logger.info("maxResults          : " + maxResults);
            logger.info("hostname            : " + hostname);
            String dataDir = "./indexData/elasticsearch/";
            if (dataDirectory != null) {
                dataDir = dataDirectory;
            }
            String configDir = IndexClientWrapper.getConfigDirectory();
            logger.info("configDir            :  " + configDir);
            logger.info("Setting index scope to " + scope);
            logger.info("initializing fulltextnode...");
            FullTextNode.Builder builder = new FullTextNode.Builder().scope(scope).hostname(hostname).dataDir(dataDir).configDir(configDir).clusterName(transformedClusterName).indexName("main-index").noOfReplicas(noReplicas).noOfShards(noShards).maxFragmentCnt(fragm_cnt).maxFragmentSize(fragm_size).useResourceRegistry(useRRAdaptor);
            if (maxResults != null) {
                builder.maxResults(maxResults);
            }
            this.ftn = builder.build();
            logger.info("initializing fulltextnode...OK");
            logger.info("discovering fulltextindex nodes...");
            Set resources = this.indexDiscoverer.discoverFulltextIndexNodeResources(clusterID, null, null, scope);
            HashSet knownNodes = Sets.newHashSet();
            if (resources == null || resources.size() == 0) {
                logger.warn("No other resources found. is this the first one?");
            } else {
                for (IndexResource resource : resources) {
                    if (resource.getEsTransportAddress() == null) continue;
                    knownNodes.add(resource.getEsTransportAddress());
                }
            }
            logger.info("discovering fulltextindex nodes...OK");
            logger.info("knownNodes : " + knownNodes);
            if (knownNodes.size() > 0) {
                this.ftn.joinCluster((List)Lists.newArrayList((Iterable)knownNodes));
            } else {
                this.ftn.createOrJoinCluster();
            }
            logger.info("recreating meta index from data to resolve inconsistencies");
            this.ftn.recreateMetaIndex();
            this.ftn.refreshIndexTypesOfIndex();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("error while initializing the index client", (Throwable)e);
        }
    }

    static String getConfigDirectory() {
        logger.info("getting config dir");
        URL url = Resources.getResource((String)"config/scripts");
        logger.info("config/scripts : " + url.toString());
        try {
            File f = new File(url.toURI());
            String configDir = f.getParent();
            logger.info("configDir : " + configDir);
            return configDir;
        }
        catch (URISyntaxException e) {
            logger.error("config/scripts not found. it should have been in the war");
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(IndexClientWrapper.getConfigDirectory());
    }

    public FullTextNode getFullTextNode() {
        return this.ftn;
    }

    public String getScope() {
        return this.ftn.getScope();
    }

    public String getClusterName() {
        return this.ftn.getClusterName();
    }
}

