package org.gcube.rest.index.service.ckan;
import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

import javax.swing.plaf.synth.SynthScrollPaneUI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.gcube.rest.index.service.ckan.beans.Resource;

import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GCoreEndpoint.Profile.Endpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.rest.index.common.Constants;
import org.gcube.rest.index.common.entities.CollectionInfo;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jayway.jsonpath.JsonPath;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;

import org.gcube.rest.index.service.ckan.beans.Group;
import org.gcube.rest.index.service.ckan.beans.Item;
import org.gcube.rest.index.service.ckan.beans.Licence;
import org.gcube.rest.index.service.ckan.beans.Organisation;
import org.gcube.rest.index.service.resources.ServiceProperties;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import net.minidev.json.JSONArray;




public class CKANBridge {

	static final Logger logger = LoggerFactory.getLogger(CKANBridge.class);
	
	
	private static String SERVICE_NAME = "Catalogue-WS";
	private static String SERVICE_CLASS = "Data-Catalogue";
	
	
	private Set<String> restEndpoints = null; 
	
	private String CKAN_TOKEN = null;
	private String CKAN_SCOPE = null;
	private String CKAN_ORGANISATION = null;
	private String CKAN_LICENCE_ID = null;
	private String CKAN_ITEM_PROFILE_NAME = null;
	
	private Client jerseyClient;
	
	
	private final Gson gson;
	
	public CKANBridge(){
		synchronized(this){
			ServiceProperties props = new ServiceProperties();
			CKAN_TOKEN = props.getCkanToken();
			CKAN_SCOPE = props.getCkanScope();
			CKAN_ORGANISATION = props.getCkanOrganisationNameOrID();
			CKAN_LICENCE_ID = props.getCkanLicenceID();
			CKAN_ITEM_PROFILE_NAME = props.getCkanItemProfileName();
		}
		restEndpoints = getEndpoints(CKAN_SCOPE);
		logger.info("Found the following "+restEndpoints.size()+": "+restEndpoints.toString()+" CKAN service endpoints on scope "+CKAN_SCOPE);
		jerseyClient = Client.create();
		gson = new Gson();
	}
	
	
	
	private Set<String> getEndpoints(String scope){
		
		ScopeProvider.instance.set(scope);
		
		SimpleQuery query = queryFor(GCoreEndpoint.class);
		
		query.addCondition("$resource/Profile/ServiceClass/text() eq '"+SERVICE_CLASS+"'")
		     .addCondition("$resource/Profile/ServiceName/text() eq '"+SERVICE_NAME+"'");
		
		DiscoveryClient<GCoreEndpoint> client = clientFor(GCoreEndpoint.class);
		
		List<GCoreEndpoint> eprs = client.submit(query);
		
		Set<String> clusterHosts = new HashSet<String>();
		for(GCoreEndpoint epr : eprs){
//			if(!epr.scopes().contains(scope))
//				continue;
			if(!"ready".equals(epr.profile().deploymentData().status().toLowerCase()))
				continue;
			for(Endpoint e : epr.profile().endpointMap().values().toArray(new Endpoint[epr.profile().endpointMap().values().size()]))
				if(!e.uri().toString().endsWith("/gcube/resource"))
					clusterHosts.add(e.uri().toString());
		}
		
		//TODO: this was added in order to avoid the problematic trash values (ghost instances) due to buggy IS discovery
//		Iterator<String> iter = clusterHosts.iterator();
//		while(iter.hasNext()){
//			String next = iter.next();
//			if(next.toLowerCase().contains("dl050.madgik.di.uoa.gr")||next.toLowerCase().contains("dl007.madgik.di.uoa.gr")||next.toLowerCase().contains("dionysus.di.uoa.gr"))
//				iter.remove();
//		}
		
		return clusterHosts;
		
	}
	
	
	
	
	public String createOrganisation(Organisation organisation){
		
		String listEP = "/api/organizations/create";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP);
			
			try{
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.type(MediaType.APPLICATION_JSON)
	//			    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.post(ClientResponse.class, gson.toJson(organisation));
				String json = resp.getEntity(String.class);
				return json;
			}
			catch(Exception ex){
				ex.printStackTrace();
			}
			
		}
		return "";
		
		
	}
	
	
	
	public String showOrganisation(String name){
		
		MultivaluedMap<String, String> params = new MultivaluedMapImpl();
		params.add("id", name);
		
		
		String listEP = "/api/organizations/show";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			
			try{
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP)
						.queryParams(params);
				
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
		//				.type(MediaType.APPLICATION_JSON)
		//		    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				String json = resp.getEntity(String.class);
				
				if(resp.getStatus()>199 && resp.getStatus()<300) 
					return json;
			}
			catch(Exception e){
				
			}
			
		}
		return "";
		
	}
	
	
	public List<String> getOrganisations(){
		
		String listEP = "/api/organizations/list";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			
			try{
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP);
		
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
				    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				
				String json = resp.getEntity(String.class);
				
				if(resp.getStatus()<200 || resp.getStatus()>299)
					continue;
				
				List<String> organisations = JsonPath.read(json, "$.result[*]"); 
				
				return organisations;
			}
			catch(Exception e){
				e.printStackTrace();
			}
		}
		return new ArrayList<String>();
	}
	
	
	public List<String> getDefaultOrganisationItemNames(){
		return getOrganisationItemNames(null);
	}
	
	public List<String> getOrganisationItemNames(String organisationName){
		
		MultivaluedMap<String, String> params = new MultivaluedMapImpl();
		if(organisationName==null || organisationName.isEmpty())
			params.add("id", CKAN_ORGANISATION);
		else
			params.add("id", organisationName);
		params.add("include_datasets", "true");
		
		
		String listEP = "/api/organizations/show";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP)
						.queryParams(params);
		
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
		//				.type(MediaType.APPLICATION_JSON)
		//		    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				String json = resp.getEntity(String.class);
				
//				Files.write(Paths.get("/tmp/aaa/"+organisationName+".json"), json.getBytes());
				
				List<String> groupNames = JsonPath.read(json, "$.result.packages[*].name");
				
				return groupNames;
				
			}catch(Exception e){}
		}
		return new ArrayList<String>();
		
		
	}
	
	
	
	public List<Licence> listLicences(){
		
		String listEP = "/api/licenses/list";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP);
				
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
		//		    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				String jsonResp = resp.getEntity(String.class);
				JSONArray licencesJsonArray = JsonPath.read(jsonResp, "$.result[*]");
				
				return licencesJsonArray.parallelStream()
						.map((jsonLicence) -> {
							return gson.fromJson(gson.toJson(jsonLicence), Licence.class);	
						})
						.collect(Collectors.toList());
				
			}
			catch(Exception e){}
			
		}
		return new ArrayList<Licence>();
	}
	
	
	public List<String> listGroups(){
		
		String listEP = "/api/groups/list";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP);
		
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
		//		    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				
				String json = resp.getEntity(String.class);
				List<String> groupNames = JsonPath.read(json, "$.result[*]");
				
				return groupNames;
				
			}catch(Exception e){
				e.printStackTrace();
			}
			
		}
		return new ArrayList<String>();
		
	}
	
	
	
	
	public String getGroup(String name){
		
		MultivaluedMap<String, String> params = new MultivaluedMapImpl();
		params.add("id", name);
		
		
		String listEP = "/api/groups/show";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP)
						.queryParams(params)
						;
		
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
		//				.type(MediaType.APPLICATION_JSON)
		//		    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				String json = resp.getEntity(String.class);
				
				return json;
				
			}catch(Exception e){}
		}
		return null;
		
	}
	
	
	
	public String createGroup(String groupName){
		
		String listEP = "/api/groups/create";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP);
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.type(MediaType.APPLICATION_JSON)
	//			    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.post(ClientResponse.class, "{\"name\":\""+groupName+"\"}");
				String json = resp.getEntity(String.class);
				return json;
			}
			catch(Exception ex){
				ex.printStackTrace();
				return "";
			}
		}
		return null;
		
	}
	

	
	public boolean deleteGroup(String name){
		
		String listEP = "/api/groups/delete";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP);
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.type(MediaType.APPLICATION_JSON)
	//			    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.post(ClientResponse.class, "{\"id\":\""+name+"\"}");
				String json = resp.getEntity(String.class);
				if(resp.getStatus()>199 && resp.getStatus()<300)
					return true;
			}
			catch(Exception ex){
				ex.printStackTrace();
			}
		}
		return false;
		
	}
	
	
	public List<String> getGroupItems(String groupName){
		
		MultivaluedMap<String, String> params = new MultivaluedMapImpl();
		params.add("id", groupName);
		params.add("include_datasets", "true");
		
		
		String listEP = "/api/groups/show";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP)
						.queryParams(params);
		
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
		//				.type(MediaType.APPLICATION_JSON)
		//		    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				String json = resp.getEntity(String.class);
				
//				Files.write(Paths.get("/tmp/biota.json"), json.getBytes());
				
				List<String> groupNames = JsonPath.read(json, "$.result.packages[*].name");
				
				return groupNames;
				
			}catch(Exception e){}
		}
		return new ArrayList<String>();
		
		
	}
	
	public String groupsFormer(List<String> groups){
		if(groups==null) groups = new ArrayList<String>();
		String g = "["+groups.parallelStream().map(groupName -> "{\"name\":\""+groupName+"\"}").collect(Collectors.joining(","))+"]";
		return g;
	}
	
	
	public List<String> listProfiles(){
		
		String listEP = "/api/profiles/profile_names";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP);
		
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
		//		    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				String json = resp.getEntity(String.class);
				List<String> profileNames = JsonPath.read(json, "$.result[*]");
				return profileNames;
				
			}catch(Exception e){
				e.printStackTrace();
			}
			
		}
		return new ArrayList<String>();
		
		
	}
	
	
	
	public String getProfile(String name){
		
		MultivaluedMap<String, String> params = new MultivaluedMapImpl();
		params.add("name", name);
		
		
		String listEP = "/api/profiles/profile";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP)
						.queryParams(params)
						;
		
				ClientResponse resp = tempWebResource
//						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.type(MediaType.APPLICATION_JSON)
		//		    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				String json = resp.getEntity(String.class);
				
				return json;
				
			}catch(Exception e){}
		}
		return null;
		
	}	
	
	
	
	/**
	 * Leave itm.owner_org -> unset (=null), to use the default for gCube which is parsed from the config file (recommended)
	 */
	@SuppressWarnings("unchecked")
	public Item createItem(Item itm, List<String> tags, String profileName){
		
		JSONObject item = new JSONObject();
		item.put("name", itm.getName()); // the name will be part of the uri.. it must be unique
		item.put("title", itm.getTitle());
		if(itm.getLicense_id()==null || itm.getLicense_id().isEmpty())
			item.put("license_id", CKAN_LICENCE_ID);
		else
			item.put("license_id", itm.getLicense_id());
		if(itm.getOwner_org() == null || itm.getOwner_org().isEmpty())
			item.put("owner_org", CKAN_ORGANISATION);
		else
			item.put("owner_org", itm.getOwner_org());
		if(tags!=null && !tags.isEmpty()){
			JSONArray tagsArray = new JSONArray();
			tags.stream().forEach(tag -> {
				JSONObject t = new JSONObject();
				t.put("name", tag);
				tagsArray.add(t);				
			});
			item.put("tags", tagsArray);
		}
		// Note: we have profiles, so we must set an extra with key system:type and a proper value(for instance, "EmptyType").
		JSONArray extras = new JSONArray();
		JSONObject sysTypeObject = new JSONObject();
		sysTypeObject.put("key","system:type");
		sysTypeObject.put("value", getProfileType(CKAN_ITEM_PROFILE_NAME));
		extras.add(sysTypeObject);
		item.put("extras", extras);
		
		System.out.println("Publishing item to CKAN: "+item.toJSONString());
		logger.info("Publishing item to CKAN: "+item.toJSONString());
		
		String restPath = "/api/items/create";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(restPath);
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.type(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
//				    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.post(ClientResponse.class, item.toJSONString());
				
				String json = resp.getEntity(String.class);

				try{
					String itemJson = gson.toJson((Object)JsonPath.read(json, "$.result"));
					return gson.fromJson(itemJson, Item.class);
				}
				catch(Exception ex){
					ex.printStackTrace();
					return null;
				}
				
			}
			catch(Exception ex){
				ex.printStackTrace();
			}
		}
		return null;
		
	}
	
	public boolean deleteItem(String nameOrId){
		
		JSONObject item = new JSONObject();
		item.put("id", nameOrId);
		
		String deleteResourceEP = "/api/items/delete";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(deleteResourceEP);
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.type(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.delete(ClientResponse.class, item.toJSONString());
				
				String json = resp.getEntity(String.class);
				
				System.out.println(json);
				
				try{
					return (boolean)JsonPath.read(json, "$.success");
				}
				catch(Exception ex){
					return false;
				}
				
			}
			catch(Exception ex){
				ex.printStackTrace();
			}
		}
		return false;
		
		
	}
	
	
	public Item getItem(String name){
		
		MultivaluedMap<String, String> params = new MultivaluedMapImpl();
		params.add("id", name);
		
		String listEP = "/api/items/show";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP)
						.queryParams(params);
		
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
		//				.type(MediaType.APPLICATION_JSON)
		//		    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				String json = resp.getEntity(String.class);
				
				try{
					String itemJson = gson.toJson((Object)JsonPath.read(json, "$.result"));
					return gson.fromJson(itemJson, Item.class);
				}
				catch(Exception ex){
					ex.printStackTrace();
					return null;
				}
				
			}catch(Exception e){}
		}
		return null;
		
	}
	
	
	public List<Resource> getItemResources(String name){
		
		MultivaluedMap<String, String> params = new MultivaluedMapImpl();
		params.add("id", name);
		
		String listEP = "/api/items/show";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP)
						.queryParams(params);
		
				ClientResponse resp = tempWebResource
//						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
//						.type(MediaType.APPLICATION_JSON)
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				String json = resp.getEntity(String.class);
				
				if(!(boolean)JsonPath.read(json, "$.success"))
					return new ArrayList<Resource>();
				
				JSONArray resources = JsonPath.read(json, "$.result.resources[*]");
				
				return resources.stream()
						.map(obj -> gson.toJson(obj))
						.map(resourceJson -> gson.fromJson(resourceJson, Resource.class))
						.collect(Collectors.toList());

			}catch(Exception e){e.printStackTrace();}
		}
		return null;
		
	}
	
	
	
	@SuppressWarnings("unchecked")
	public Resource createItemResource(Resource resource){
		
		
		JSONObject item = new JSONObject();
		item.put("package_id", resource.getPackage_id());
		item.put("url", resource.getUrl());
		item.put("description", resource.getDescription());
		item.put("name", resource.getName());
//		item.put("mimetype", "application/json");
		
		
		String createResourceEP = "/api/resources/create";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(createResourceEP);
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.type(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.post(ClientResponse.class, item.toJSONString());
				
				String json = resp.getEntity(String.class);

				try{
					String resourceJson = gson.toJson((Object)JsonPath.read(json, "$.result"));
					return gson.fromJson(resourceJson, Resource.class);
				}
				catch(Exception ex){
					ex.printStackTrace();
					return null;
				}
				
			}
			catch(Exception ex){
				ex.printStackTrace();
			}
		}
		return null;
		
		
	}
	
	
	
	@SuppressWarnings("unchecked")
	public String deleteItemResource(String resourceID){
		
		JSONObject item = new JSONObject();
		item.put("id", resourceID);
		
		String deleteResourceEP = "/api/resources/delete";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(deleteResourceEP);
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.type(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.delete(ClientResponse.class, item.toJSONString());
				
				String json = resp.getEntity(String.class);
				return json;
			}
			catch(Exception ex){
				ex.printStackTrace();
			}
		}
		return null;
		
		
	}
	
	
	public List<String> getItemResourcesIDs(String name){
		
		MultivaluedMap<String, String> params = new MultivaluedMapImpl();
		params.add("id", name);
		
		String listEP = "/api/items/show";
		
		Iterator<String> iter = restEndpoints.iterator();
		while(iter.hasNext()){
			String restEndpoint = iter.next();
			try {
				WebResource tempWebResource = jerseyClient.resource(restEndpoint).path(listEP)
						.queryParams(params);
		
				ClientResponse resp = tempWebResource
						.accept(MediaType.APPLICATION_JSON + "; " + "charset=UTF-8")
		//				.type(MediaType.APPLICATION_JSON)
		//		    	.type(MediaType.APPLICATION_FORM_URLENCODED + "; " + "charset=UTF-8")
						.header("gcube-token", CKAN_TOKEN)
						.get(ClientResponse.class);
				
				String json = resp.getEntity(String.class);
				
				List<String> resources = JsonPath.read(json, "$.result.resources[*].id");
				
				return resources;
				
			}catch(Exception e){}
		}
		return null;
	}
	
	
	private String getProfileType(String profileName) {
		try{
			String profileXML = getProfile(profileName);
			InputStream is = new ByteArrayInputStream(profileXML.getBytes(StandardCharsets.UTF_8.name()));
			DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = builderFactory.newDocumentBuilder();
			Document xmlDocument = builder.parse(is);
			XPath xPath = XPathFactory.newInstance().newXPath();
			String expression = "/metadataformat";
			NodeList nodeList = (NodeList) xPath.compile(expression).evaluate(xmlDocument, XPathConstants.NODESET);
			for(int i=0;i<nodeList.getLength();i++)
				if(nodeList.item(i).getNodeName().equals("metadataformat"))
					return nodeList.item(i).getAttributes().getNamedItem("type").getNodeValue();
			logger.info("COULD NOT FIND THE PROFILE TYPE FOR THE GIVEN PROFILE NAME: "+profileName+" Expect FAILURE of CKAN POSTING");
			return null;
		}
		catch(Exception ex){
			ex.printStackTrace();
			return null;
		}
	}
	

	
	public static void main(String [] args) throws Exception{
		
		CKANBridge bridge = new CKANBridge();
		
//		System.out.println(bridge.listGroups());
//		System.out.println(bridge.getGroup("mister-pink"));
		
		System.out.println(bridge.listProfiles());
//		System.out.println(bridge.listLicences().stream().map(l -> l.getId()).collect(Collectors.toList()));
		
//		System.out.println(bridge.getOrganisations());
//		System.out.println(bridge.showOrganisation("ices"));
//		System.out.println(bridge.showOrganisation("131d8f52-2566-458b-8bc4-04fb57f2580d"));
		
//		List<String> organisations = bridge.getOrganisations().parallelStream().map(organisationName -> bridge.showOrganisation(organisationName)).collect(Collectors.toList());
//		System.out.println("["+String.join(",", organisations)+"]");
		
//		Organisation organisation = new Organisation();
//		organisation.setName("devsec");
//		System.out.println(bridge.createOrganisation(organisation));
		
//		bridge.listLicences().forEach(licence -> System.out.println(bridge.gson.toJson(licence)) );
		
//		System.out.println(bridge.listGroups());
		
//		System.out.println(bridge.getGroup("AquaMaps1"));
		
//		System.out.println(bridge.getGroup("biota"));
		
//		Files.write(Paths.get("/tmp/res-"+System.currentTimeMillis()), bridge.getGroup("biota").getBytes());
		
//		System.out.println(bridge.createGroup("test1"));
		
		
//		groupName: AquaMaps1
		
//		System.out.println(bridge.getItem("testing_c49905a2-fd82-4e12-9124-591739a471fe"));
		
//		System.out.println(bridge.listProfiles());
//		System.out.println(bridge.getProfile("Empty Profile"));
		
		
//		List<Group> g = new ArrayList<Group>();
//		Group gr = new Group();
//		gr.setName("geoscientificinformation");
//		g.add(gr);
		
		
//		System.out.println(new Gson().toJson(bridge.listLicences()));
//		System.out.println(new Gson().toJson(bridge.listLicences().parallelStream().map(licence -> licence.getTitle()).collect(Collectors.toSet())));
		
		
		
//		List<String> organisations = bridge.getOrganisations();
//		System.out.println(organisations);
//		organisations.parallelStream().forEach(organisation -> {
//			Item item = new Item();
//			item.setName("test_"+UUID.randomUUID().toString());
//			item.setTitle("This is a sample for testing");
//			item.setNotes("blah blah"); //description
//			item.setLicense_id("MIT");
//			item.setOwner_org(organisation);
//			
//			System.out.println(bridge.createItem(item, null, "EmptyType"));
//		});
		
//		System.out.println(bridge.listProfiles());
		
		
//		System.out.println(bridge.getProfile("Empty Profile"));
//		System.out.println(bridge.getProfileType("Empty Profile"));
		
		
//		Item item = new Item();
//		item.setName("test_"+UUID.randomUUID().toString());
//		item.setTitle("This is a sample for testing");
//		item.setNotes("blah blah"); //description
//		item.setLicense_id("MIT");
//		item.setOwner_org("ices");
//		item = bridge.createItem(item, null, "Empty Profile");
//		System.out.println(item);
		
//		Item retrievedItem = bridge.getItem("test_a0eec5cb-23e9-4aad-b6d1-e6a5642e3685");
//		System.out.println(retrievedItem);
		
		
//		Resource resource = new Resource(retrievedItem.getId(), "resource-55", "Dummy resource", "http://abc.dfgafdg.com/fdgafgadfs/sdfadsf");
//		resource = bridge.createItemResource(resource);
//		System.out.println(resource);
		
//		List<Resource> retrievedResources = bridge.getItemResources("test_a0eec5cb-23e9-4aad-b6d1-e6a5642e3685");
//		System.out.println(retrievedResources);
		
		
//		System.out.println(bridge.deleteItemResource(retrievedResources.get(0).getId()));
//		
//		if(bridge.getItemResources("test_a0eec5cb-23e9-4aad-b6d1-e6a5642e3685").isEmpty())
//			bridge.deleteItem("test_a0eec5cb-23e9-4aad-b6d1-e6a5642e3685");
		
//		System.out.println(bridge.deleteItemResource("resource-55"));
		
		
//		System.out.println(bridge.deleteItem("test_d26e5147-2c9b-489a-9ff6-c5fe29321100"));
		
		
//		"name": "test_d26e5147-2c9b-489a-9ff6-c5fe29321100"
//		"id": "bd777796-5a2c-4f34-b5e9-4a29acf3867b"
		
		
		
		
//		System.out.println(bridge.getGroupItems("geoscientificinformation"));
		
//		bridge.listGroups().forEach(group -> {
//			bridge.getGroupItems(group).forEach(item -> {
//				List<Resource> resources = bridge.getItemResources(item);
//				if(resources!=null){
//					System.out.print(System.lineSeparator());
//					resources.stream().forEach(System.out::print);
//				}
//			});
//		});
		
//		System.out.println(bridge.getItem("a7576903-0117-4c09-b6e2-43751d864ff4"));
		
		
		
//		System.out.println(bridge.createItem("testing_12", "cc-by", "testing35635624562345", "ices" , null, null, null));

//		String url = "http://www.adsfsdfasdfg.gr";
//		Resource resource = new Resource("629c8b9c-c47f-4625-a2f4-cc50dfff7ffd", "sample-"+UUID.randomUUID().toString(), "testing", url);
//		System.out.println(bridge.createItemResource(resource));

//		System.out.println(bridge.getItem("testing_12"));
//		System.out.println(bridge.getItemResources("testing_12"));
		
//		bridge.getItemResources("testing_1").forEach(resource -> bridge.deleteItemResource(resource.getId()));
		
//		System.out.println(bridge.deleteItem("testing_1"));
		
		
		
//		System.out.println(bridge.getItem("north-irish-sea-habitats"));
		
//		bridge.getOrganisations().parallelStream().forEach(organisationName -> {
//			System.out.println(organisationName);
//			bridge.getOrganisationItems(organisationName);
//		});
		
		
//		List<Group> g = new ArrayList<Group>();
//		Group gr = new Group();
//		gr.setName("geoscientificinformation");
//		g.add(gr);
//		
//		System.out.println(bridge.createItem("testing35635624562345", "GPL-3.0", "ices", "testing35635624562345", "noone", "No description -- it's for test", g));
//		System.out.println(bridge.getOrganisationItems("ices"));
		
//		CollectionInfo collInfo = new CollectionInfo("", collectionDomain, datasourceType, title, description, date)
		
//		System.out.println(bridge.getItem("irish-sea-pilot-project-eunis-habitats"));
		
//		System.out.println(bridge.getGroupItems("biota"));
		
	}	
	
	
	
	
	
	
	
	
	
}



