/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.cache;

import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.gcube.rest.index.service.cache.IndexServiceCache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.guava.GuavaCache;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
public class CacheConfig
implements CachingConfigurer {
    public static final TimeUnit CACHE_TIME_UNIT = TimeUnit.SECONDS;
    public static final long CACHE_TIME = 60L;
    public static final String ENDPOINTS = "ENDPOINTS";
    public static final String COLLECTION_NAMES = "COLLECTION_NAMES";
    public static final String COLLECTIONS_FIELDS = "COLLECTIONS_FIELDS";
    public static final String COLLECTIONS_FIELDS_ALIASES = "COLLECTIONS_FIELDS_ALIASES";
    public static final String COLLECTION_DOC_COUNTS = "COLLECTION_DOC_COUNTS";
    public static final String COMPLETE_COLLECTION_INFOS = "COMPLETE_COLLECTION_INFOS";

    @Bean
    public IndexServiceCache indexServiceCache() {
        return new IndexServiceCache();
    }

    @Bean
    public CacheManager cacheManager() {
        SimpleCacheManager simpleCacheManager = new SimpleCacheManager();
        simpleCacheManager.setCaches(Arrays.asList(new GuavaCache(ENDPOINTS, CacheBuilder.newBuilder().expireAfterWrite(60L, CACHE_TIME_UNIT).build()), new GuavaCache(COLLECTION_NAMES, CacheBuilder.newBuilder().expireAfterWrite(60L, CACHE_TIME_UNIT).build()), new GuavaCache(COLLECTIONS_FIELDS, CacheBuilder.newBuilder().expireAfterWrite(60L, CACHE_TIME_UNIT).build()), new GuavaCache(COLLECTIONS_FIELDS_ALIASES, CacheBuilder.newBuilder().expireAfterWrite(60L, CACHE_TIME_UNIT).build()), new GuavaCache(COLLECTION_DOC_COUNTS, CacheBuilder.newBuilder().expireAfterWrite(60L, CACHE_TIME_UNIT).build()), new GuavaCache(COMPLETE_COLLECTION_INFOS, CacheBuilder.newBuilder().expireAfterWrite(60L, CACHE_TIME_UNIT).build())));
        return simpleCacheManager;
    }

    public CacheResolver cacheResolver() {
        return null;
    }

    public CacheErrorHandler errorHandler() {
        return null;
    }

    public KeyGenerator keyGenerator() {
        return null;
    }
}

