/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.gcube.rest.index.common.entities.CollectionInfo;
import org.gcube.rest.index.common.entities.fields.config.FacetType;
import org.gcube.rest.index.common.entities.fields.config.FieldConfig;
import org.gcube.rest.index.service.elements.IndexFacet;

public class IndexFacetFunctions {
    public static IndexFacet buildFacetRequest(Map<String, CollectionInfo> collectionInfoMap) {
        IndexFacet indexFacet = new IndexFacet();
        ArrayList<TermsBuilder> aggregation = new ArrayList<TermsBuilder>();
        HashSet<String> alreadyAdded = new HashSet<String>();
        boolean noneFacetType = true;
        for (CollectionInfo colInfo : collectionInfoMap.values()) {
            Map fieldsConfig = colInfo.getCollectionFieldsConfigs();
            for (Map.Entry entry : fieldsConfig.entrySet()) {
                FacetType fieldFacetType = ((FieldConfig)entry.getValue()).getFacetType();
                if (fieldFacetType == FacetType.NONE) continue;
                noneFacetType = false;
                String fieldName = (String)entry.getKey();
                if (alreadyAdded.contains(fieldName)) continue;
                aggregation.add(((TermsBuilder)AggregationBuilders.terms((String)(fieldName + "." + fieldFacetType.getText())).field(fieldName + "." + fieldFacetType.getText())).size(10));
                alreadyAdded.add(fieldName);
            }
        }
        indexFacet.setListOfAggregations(aggregation);
        indexFacet.setNoneFacetType(noneFacetType);
        return indexFacet;
    }
}

