package org.gcube.rest.index.service.ckan;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

import org.gcube.rest.index.common.discover.IndexDiscoverer;
import org.gcube.rest.index.common.entities.CollectionInfo;
import org.gcube.rest.index.common.entities.configuration.DatasourceType;
import org.gcube.rest.index.service.ckan.beans.Item;
import org.gcube.rest.index.service.ckan.beans.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CKANPublisher {
	
	static final Logger logger = LoggerFactory.getLogger(CKANPublisher.class);
	
	
	public static void main(String [] args){
		CollectionInfo collInfo = new CollectionInfo("collection-"+UUID.randomUUID().toString(),"/gcube/devNext/NextNext", DatasourceType.ELASTIC, "Dummy title alt", "Dummy Description alt", new Date());
		CKANPublisher.publishToCKAN(null, null, null, collInfo);
	}
	
	
	
	public static void publishToCKAN(String organisationName, String licenceID, String itemProfileName, CollectionInfo collInfo){
	
		
		
		Thread t = new Thread(new Runnable(){
			
			public void run(){
				
				
				// collInfo.getCollectionDomain() should actually have the scope
				Set<String> indexEndpoints = new IndexDiscoverer().discoverFulltextIndexNodes(collInfo.getCollectionDomain());
				
				if(indexEndpoints==null || indexEndpoints.isEmpty()){
					logger.info("No index endpoints available to add as a url on CKAN items. No changes made on CKAN...");
					return;
				}
				
				
				CKANBridge ckanBridge = new CKANBridge();
				
				
				Item item = new Item();
				item.setName(collInfo.getTitle());
				item.setTitle(collInfo.getTitle());
				item.setNotes(collInfo.getDescription()); //description
				item.setLicense_id(licenceID);
				item.setOwner_org(organisationName);
				
				
				
				if(ckanBridge.getItem(item.getName()) == null) //not found, so create it
					item = ckanBridge.createItem(item, null, itemProfileName);
				
				
				List<Resource> existingItemResources = ckanBridge.getItemResources(item.getName());
				
				Set<String> existingUrls = existingItemResources.stream().map(resource -> resource.getUrl()).collect(Collectors.toSet());
				
				Set<String> newResourceURLs = indexEndpoints.parallelStream()
					.map(ep -> ep+"/harvest?collectionDomain="+collInfo.getCollectionDomain()+"&colID="+collInfo.getId()+"&scrollId=")
					.collect(Collectors.toSet());
				
				//TODO: maybe add a logic for updating resource as well...
				
				final String itemID = item.getId();
				
				newResourceURLs.forEach(newURL -> {
					if(!existingUrls.contains(newURL)){
						Resource resource = new Resource(itemID, collInfo.getId(), collInfo.getDescription(), newURL);
						ckanBridge.createItemResource(resource);
					}
				});
				
			}
		});
		t.start();
		
	}
	
	public static void removeFromCKAN(CollectionInfo collInfo){
		
		Thread t = new Thread(new Runnable(){
			
			public void run(){
				CKANBridge ckanBridge = new CKANBridge();
				
				List<Resource> itemResources = ckanBridge.getItemResources(collInfo.getTitle());
				itemResources.stream()
							 .filter(resource -> resource.getName().equals(collInfo.getId()))
							 .collect(Collectors.toList()).stream().forEach(res -> {
								 ckanBridge.deleteItemResource(res.getId());
							 });
				if(ckanBridge.getItemResources(collInfo.getTitle()).isEmpty()) //delete also the item
					ckanBridge.deleteItem(collInfo.getTitle());
				
			}
			
		});
		t.start();
	}
	
}
