/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.sweeper;

import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.sweeper.ISSweeperPluginDeclaration;
import org.gcube.informationsystem.sweeper.Sweeper;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISSweeperPlugin
extends Plugin<ISSweeperPluginDeclaration> {
    public static final String EXPIRING_MINUTES_TIMEOUT = "expiringMinutesTimeout";
    public static final int DEFAULT_EXPIRING_MINUTES_TIMEOUT = 30;
    public static final String DEAD_DAYS_TIMEOUT = "deadDaysTimeout";
    public static final int DEFAULT_DEAD_DAYS_TIMEOUT = 15;
    private static Logger logger = LoggerFactory.getLogger(ISSweeperPlugin.class);

    public ISSweeperPlugin(ISSweeperPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
        logger.debug("contructor");
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        String scope = ScopeProvider.instance.get();
        logger.debug("Launching {} execution on scope {}", (Object)"ISSweeper", (Object)scope);
        int expiringMinutesTimeout = 30;
        int deadDaysTimeout = 15;
        if (inputs != null) {
            if (inputs.containsKey(EXPIRING_MINUTES_TIMEOUT)) {
                try {
                    expiringMinutesTimeout = new Integer(inputs.get(EXPIRING_MINUTES_TIMEOUT).toString());
                }
                catch (Exception e) {
                    logger.warn("The provided value {} for {} is not an int. Default value {} will be used", new Object[]{inputs.get(EXPIRING_MINUTES_TIMEOUT), EXPIRING_MINUTES_TIMEOUT, 30, e});
                }
            } else {
                logger.debug("No provided value for {}. Default value {} will be used", (Object)EXPIRING_MINUTES_TIMEOUT, (Object)30);
            }
            if (inputs.containsKey(DEAD_DAYS_TIMEOUT)) {
                try {
                    deadDaysTimeout = new Integer(inputs.get(DEAD_DAYS_TIMEOUT).toString());
                }
                catch (Exception e) {
                    logger.warn("The provided value {} for {} is not an int. Default value {} will be used", new Object[]{inputs.get(DEAD_DAYS_TIMEOUT), DEAD_DAYS_TIMEOUT, 15, e});
                }
            } else {
                logger.debug("No provided value for {}. Default value {} will be used", (Object)DEAD_DAYS_TIMEOUT, (Object)15);
            }
        }
        Sweeper sweeper = new Sweeper();
        try {
            sweeper.sweepDeadGHNs(6, -deadDaysTimeout);
        }
        catch (Exception e) {
            logger.error("Error removing Dead HostingNodes", (Throwable)e);
        }
        logger.trace("---------------------------------\n\n");
        try {
            sweeper.sweepExpiredGHNs(12, -expiringMinutesTimeout);
            logger.trace("---------------------------------\n\n");
        }
        catch (Exception e) {
            logger.error("Error sweeping Expired HostingNodes", (Throwable)e);
        }
        logger.trace("---------------------------------\n\n");
        Thread.sleep(90000L);
        try {
            sweeper.sweepOrphanRI();
            logger.trace("---------------------------------\n\n");
        }
        catch (Exception e) {
            logger.error("Error sweeping Orphan RunningInstances", (Throwable)e);
        }
        logger.debug("{} execution finished", (Object)"ISSweeper");
    }

    protected void onStop() throws Exception {
        logger.debug("onStop()");
        Thread.currentThread().interrupt();
    }
}

