/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.schema;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import org.gcube.informationsystem.model.reference.AccessType;
import org.gcube.informationsystem.model.reference.ISManageable;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.api.utils.Utility;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClient;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistrySchemaClientImpl
implements ResourceRegistrySchemaClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistrySchemaClientImpl.class);
    public static final String PATH_SEPARATOR = "/";
    protected final String address;
    protected HTTPCall httpCall;

    public ResourceRegistrySchemaClientImpl(String address) {
        this.address = address;
    }

    private HTTPCall getHTTPCall() throws MalformedURLException {
        if (this.httpCall == null) {
            this.httpCall = new HTTPCall(this.address, ResourceRegistrySchemaClient.class.getSimpleName());
        }
        return this.httpCall;
    }

    @Override
    public <ISM extends ISManageable> TypeBinder.TypeDefinition create(Class<ISM> clz) throws SchemaException, ResourceRegistryException {
        try {
            String typeDefinition = TypeBinder.serializeType(clz);
            String type = AccessType.getAccessType(clz).getName();
            String res = this.create(type, typeDefinition);
            return TypeBinder.deserializeTypeDefinition((String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String baseType, String typeDefinitition) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)typeDefinitition);
            TypeBinder.TypeDefinition typeDefinitionObj = TypeBinder.deserializeTypeDefinition((String)typeDefinitition);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("types");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(typeDefinitionObj.getName());
            HTTPCall httpCall = this.getHTTPCall();
            String c = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, typeDefinitition);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ISM extends ISManageable> List<TypeBinder.TypeDefinition> read(Class<ISM> clz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String type = Utility.getType(clz);
            String res = this.read(type, polymorphic);
            return TypeBinder.deserializeTypeDefinitions((String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String read(String type, Boolean polymorphic) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get {} schema", (Object)type);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("types");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (polymorphic != null) {
                parameters.put("polymorphic", polymorphic.toString());
            }
            HTTPCall httpCall = this.getHTTPCall();
            String json = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.GET, parameters);
            logger.debug("Got schema for {} is {}", (Object)type, (Object)json);
            return json;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

