/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.utils;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utility {
    private static final Logger logger = LoggerFactory.getLogger(Utility.class);

    public static JSONObject toJsonObject(OrientElement element, boolean raw) throws JSONException {
        return new JSONObject(Utility.toJsonString((OrientElement)element, (boolean)raw));
    }

    public static String toJsonString(OrientElement element, boolean raw) {
        ODocument oRecord = element.getRecord();
        if (raw) {
            return oRecord.toJSON();
        }
        return oRecord.toJSON("class");
    }

    public static JSONObject toJsonObject(Element element, boolean raw) throws JSONException {
        if (raw) {
            return GraphSONUtility.jsonFromElement((Element)element, (Set)element.getPropertyKeys(), (GraphSONMode)GraphSONMode.EXTENDED);
        }
        HashSet keys = new HashSet(element.getPropertyKeys());
        for (String key : element.getPropertyKeys()) {
            if (!key.startsWith("_")) continue;
            keys.remove(key);
        }
        return GraphSONUtility.jsonFromElement((Element)element, keys, (GraphSONMode)GraphSONMode.EXTENDED);
    }

    public static String toJsonString(Element element) {
        try {
            return Utility.toJsonObject((Element)element, (boolean)true).toString();
        }
        catch (Exception e) {
            return String.valueOf(element);
        }
    }

    public static Vertex getEntityByUUID(OrientGraph orientGraph, String entityType, String uuid) throws ResourceRegistryException {
        String select;
        OSQLSynchQuery osqlSynchQuery;
        Iterable vertexes;
        if (entityType == null) {
            entityType = "Entity";
        }
        if ((vertexes = (Iterable)orientGraph.command((OCommandRequest)(osqlSynchQuery = new OSQLSynchQuery(select = "SELECT FROM " + entityType + " WHERE " + "header" + "." + "uuid" + " = \"" + uuid + "\""))).execute(new Object[0])) == null || !vertexes.iterator().hasNext()) {
            String error = String.format("No %s with UUID %s was found", entityType, uuid);
            logger.info(error);
            throw new EntityException(error);
        }
        Iterator iterator = vertexes.iterator();
        Vertex entity = (Vertex)iterator.next();
        logger.trace("{} with {} is : {}", new Object[]{entityType, uuid, Utility.toJsonString((Element)entity)});
        if (iterator.hasNext()) {
            throw new ResourceRegistryException("Found more than one " + entityType + " with uuid " + uuid + ". This is a fatal error please contact Admnistrator");
        }
        return entity;
    }

    public static Edge getRelationByUUID(OrientGraph orientGraph, String relationType, String uuid) throws ResourceRegistryException {
        String select;
        OSQLSynchQuery osqlSynchQuery;
        Iterable edges;
        if (relationType == null) {
            relationType = Relation.class.getSimpleName();
        }
        if ((edges = (Iterable)orientGraph.command((OCommandRequest)(osqlSynchQuery = new OSQLSynchQuery(select = "SELECT FROM " + relationType + " WHERE " + "header" + "." + "uuid" + " = \"" + uuid + "\""))).execute(new Object[0])) == null || !edges.iterator().hasNext()) {
            String error = String.format("No %s with UUID %s was found", relationType, uuid);
            logger.info(error);
            throw new FacetNotFoundException(error);
        }
        Iterator iterator = edges.iterator();
        Edge relation = (Edge)iterator.next();
        logger.trace("{} with {} is : {}", new Object[]{relationType, uuid, Utility.toJsonString((Element)relation)});
        if (iterator.hasNext()) {
            throw new ResourceRegistryException("Found more than one " + relationType + " with uuid " + uuid + ". This is a fatal error please contact Admnistrator");
        }
        return relation;
    }
}

