/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.dbinitialization;

import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.dbinitialization.SecurityContextMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecurityContext {
    private static Logger logger = LoggerFactory.getLogger(SecurityContext.class);
    public static final String DEFAULT_WRITER_ROLE = "writer";
    public static final String DEFAULT_READER_ROLE = "reader";

    public static void addToSecurityContext(OrientGraph orientGraph, Vertex vertex, String contextID) {
        OSecurity oSecurity = orientGraph.getRawGraph().getMetadata().getSecurity();
        SecurityContext.addToSecurityContext((OSecurity)oSecurity, (Vertex)vertex, (String)contextID);
    }

    public static void addToSecurityContext(OSecurity oSecurity, Vertex vertex, String contextID) {
        OrientVertex orientVertex = (OrientVertex)vertex;
        SecurityContext.allowSecurityContextRoles((OSecurity)oSecurity, (ODocument)orientVertex.getRecord(), (String)contextID);
        Iterable iterable = vertex.getEdges(Direction.BOTH, new String[0]);
        for (OrientEdge edge : iterable) {
            SecurityContext.allowSecurityContextRoles((OSecurity)oSecurity, (ODocument)edge.getRecord(), (String)contextID);
        }
    }

    public static void addToSecurityContext(OrientGraph orientGraph, Edge edge, String contextID) {
        OSecurity oSecurity = orientGraph.getRawGraph().getMetadata().getSecurity();
        SecurityContext.addToSecurityContext((OSecurity)oSecurity, (Edge)edge, (String)contextID);
    }

    public static void addToSecurityContext(OSecurity oSecurity, Edge edge, String contextID) {
        OrientEdge orientEdge = (OrientEdge)edge;
        SecurityContext.allowSecurityContextRoles((OSecurity)oSecurity, (ODocument)orientEdge.getRecord(), (String)contextID);
    }

    protected static void allowSecurityContextRoles(OSecurity oSecurity, ODocument oDocument, String contextID) {
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_ALL, SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (String)contextID));
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_READ, SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (String)contextID));
    }

    public static void createSecurityContext(OrientGraph orientGraph, String contextID, boolean commit) {
        OSecurity oSecurity = orientGraph.getRawGraph().getMetadata().getSecurity();
        ORole writer = oSecurity.getRole("writer");
        ORole reader = oSecurity.getRole("reader");
        ORole writerRole = oSecurity.createRole(SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (String)contextID), writer, OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        ORole readerRole = oSecurity.createRole(SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (String)contextID), reader, OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        oSecurity.createUser(SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.USER, (String)contextID), (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(SecurityContextMapper.PermissionMode.WRITER), new ORole[]{writerRole});
        oSecurity.createUser(SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.USER, (String)contextID), (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(SecurityContextMapper.PermissionMode.READER), new ORole[]{readerRole});
        if (commit) {
            orientGraph.commit();
        }
        logger.trace("Security Context (roles and users) with UUID {} successfully created", (Object)contextID);
    }

    public static void deleteSecurityContext(OrientGraph orientGraph, String contextID, boolean commit) {
        logger.trace("Going to remove Security Context (roles and users) with UUID {}", (Object)contextID);
        OSecurity oSecurity = orientGraph.getRawGraph().getMetadata().getSecurity();
        oSecurity.dropUser(SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.USER, (String)contextID));
        oSecurity.dropUser(SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.USER, (String)contextID));
        oSecurity.dropRole(SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (String)contextID));
        oSecurity.dropRole(SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER, (SecurityContextMapper.SecurityType)SecurityContextMapper.SecurityType.ROLE, (String)contextID));
        if (commit) {
            orientGraph.commit();
        }
        logger.trace("Security Context (roles and users) with UUID {} successfully removed", (Object)contextID);
    }
}

