/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.utils;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import java.util.Iterator;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.model.orientdb.impl.entity.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.dbinitialization.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.resources.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextUtility {
    private static final Logger logger = LoggerFactory.getLogger(ContextUtility.class);

    public static void addToActualContext(OrientGraph orientGraph, Vertex vertex) throws ContextException {
        String contextID = ContextUtility.getActualContextUUID();
        SecurityContext.addToSecurityContext((OrientGraph)orientGraph, (Vertex)vertex, (String)contextID);
    }

    public static void addToActualContext(OSecurity oSecurity, Vertex vertex) throws ContextException {
        String contextID = ContextUtility.getActualContextUUID();
        SecurityContext.addToSecurityContext((OSecurity)oSecurity, (Vertex)vertex, (String)contextID);
    }

    public static void addToActualContext(OrientGraph orientGraph, Edge edge) throws ContextException {
        String contextID = ContextUtility.getActualContextUUID();
        SecurityContext.addToSecurityContext((OrientGraph)orientGraph, (Edge)edge, (String)contextID);
    }

    public static void addToActualContext(OSecurity oSecurity, Edge edge) throws ContextException {
        String contextID = ContextUtility.getActualContextUUID();
        SecurityContext.addToSecurityContext((OSecurity)oSecurity, (Edge)edge, (String)contextID);
    }

    protected static String getContextUUIDFromContextVertex(Vertex vertex) {
        ODocument header = (ODocument)vertex.getProperty("header");
        String contextID = (String)header.field("uuid");
        return contextID;
    }

    public static String getActualContextUUID() throws ContextException {
        try {
            String scope = ScopeProvider.instance.get();
            OrientGraphFactory factory = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            Vertex context = ContextUtility.getContextVertexByFullName((OrientGraph)factory.getTx(), (String)scope);
            return ContextUtility.getContextUUIDFromContextVertex((Vertex)context);
        }
        catch (Exception e) {
            throw new ContextException("Unable to restrive Context UUID from current Context");
        }
    }

    public static OrientGraph getActualSecurityContextGraph(SecurityContextMapper.PermissionMode permissionMode) throws ResourceRegistryException {
        try {
            String contextID = ContextUtility.getActualContextUUID();
            OrientGraphFactory factory = SecurityContextMapper.getSecurityContextFactory((String)contextID, (SecurityContextMapper.PermissionMode)permissionMode);
            return factory.getTx();
        }
        catch (ContextException ce) {
            logger.error("Unable to retrieve context.", (Throwable)ce);
            throw ce;
        }
        catch (Exception e) {
            logger.error("Unable to retrieve context.", (Throwable)e);
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static Vertex getContextVertexByFullName(OrientGraph orientGraph, String fullName) throws ContextNotFoundException {
        ScopeBean scopeBean = new ScopeBean(fullName);
        String name = scopeBean.name();
        String select = "SELECT FROM " + Context.class.getSimpleName() + " WHERE " + "name" + " = \"" + name + "\"";
        OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
        Iterable vertexes = (Iterable)orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
        if (vertexes == null || !vertexes.iterator().hasNext()) {
            throw new ContextNotFoundException("Error retrieving context with name " + fullName);
        }
        Iterator iterator = vertexes.iterator();
        Vertex context = (Vertex)iterator.next();
        logger.trace("Context Representing Vertex : {}", (Object)Utility.toJsonString((Element)context));
        if (iterator.hasNext()) {
            throw new ContextNotFoundException("Found more than one context with name " + name + "but required the one with path" + fullName + ". Please Reimplement the query");
        }
        return context;
    }

    public static String getActualSecurityRoleOrUserName(SecurityContextMapper.PermissionMode permissionMode, SecurityContextMapper.SecurityType securityType) throws ContextException {
        String contexUUID = ContextUtility.getActualContextUUID();
        return SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)permissionMode, (SecurityContextMapper.SecurityType)securityType, (String)contexUUID);
    }
}

