/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import com.tinkerpop.blueprints.Direction;
import java.util.Arrays;
import java.util.UUID;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.EntityManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.query.QueryImpl;
import org.gcube.informationsystem.resourceregistry.schema.SchemaManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="access")
public class Access {
    private static Logger logger = LoggerFactory.getLogger(Access.class);
    public static final String ID_PATH_PARAM = "id";
    public static final String TYPE_PATH_PARAM = "type";

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public String query(@QueryParam(value="query") String query, @QueryParam(value="limit") Integer limit, @QueryParam(value="fetchPlan") String fetchPlan) throws InvalidQueryException {
        logger.info("Requested query (fetch plan {}, limit : {}):\n{}", new Object[]{fetchPlan, limit, query});
        QueryImpl queryManager = new QueryImpl();
        return queryManager.query(query, limit, fetchPlan);
    }

    @HEAD
    @Path(value="instance/{type}/{id}")
    public Response exists(@PathParam(value="type") String type, @PathParam(value="id") String id) throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.HEAD.name() + " /" + "access" + "/" + "instance" + "/" + type + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested to check if {} with id {} exists", (Object)type, (Object)id);
        ERManagement erManagement = ERManagement.getERManagement((String)type);
        UUID uuid = null;
        try {
            uuid = UUID.fromString(id);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        erManagement.setUUID(uuid);
        try {
            boolean found = erManagement.exists();
            if (found) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ERNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ERAvailableInAnotherContextException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    @GET
    @Path(value="instance/{type}/{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getInstance(@PathParam(value="type") String type, @PathParam(value="id") String id) throws ERNotFoundException, ResourceRegistryException {
        CalledMethodProvider.instance.set(HTTPCall.HTTPMETHOD.GET.name() + " /" + "access" + "/" + "instance" + "/" + type + "/{" + ID_PATH_PARAM + "}");
        logger.info("Requested {} with id {}", (Object)type, (Object)id);
        ERManagement erManagement = ERManagement.getERManagement((String)type);
        UUID uuid = null;
        try {
            uuid = UUID.fromString(id);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        erManagement.setUUID(uuid);
        return erManagement.read();
    }

    @GET
    @Path(value="instances/{type}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getInstances(@PathParam(value="type") String type, @QueryParam(value="polymorphic") @DefaultValue(value="false") Boolean polymorphic, @QueryParam(value="reference") String reference, @QueryParam(value="direction") @DefaultValue(value="both") String direction) throws ResourceRegistryException {
        logger.info("Requested {} ({}={}) instances", new Object[]{type, "polymorphic", polymorphic});
        ERManagement erManagement = ERManagement.getERManagement((String)type);
        if (erManagement instanceof EntityManagement) {
            return erManagement.all(polymorphic.booleanValue());
        }
        if (erManagement instanceof RelationManagement) {
            if (reference != null) {
                Direction directionEnum;
                UUID uuid = null;
                try {
                    uuid = UUID.fromString(reference);
                }
                catch (Exception e) {
                    String errror = String.format("Provided %s (%s) is not a valid %s", "reference", reference, UUID.class.getSimpleName());
                    throw new ResourceRegistryException(errror);
                }
                if (direction == null) {
                    directionEnum = Direction.BOTH;
                } else {
                    try {
                        directionEnum = Enum.valueOf(Direction.class, direction.trim().toUpperCase());
                    }
                    catch (Exception e) {
                        String errror = String.format("Provided %s (%s) is not valid. Allowed values are %s", "direction", direction, Arrays.toString(Direction.values()).toLowerCase());
                        throw new ResourceRegistryException(errror);
                    }
                }
                return ((RelationManagement)erManagement).allFrom(uuid, directionEnum, polymorphic.booleanValue());
            }
            return erManagement.all(polymorphic.booleanValue());
        }
        throw new ResourceRegistryException("Invalid Request");
    }

    @GET
    @Path(value="schema/{type}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getSchema(@PathParam(value="type") String type, @QueryParam(value="polymorphic") @DefaultValue(value="false") Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        logger.info("Requested Schema for type {}", (Object)type);
        SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
        return schemaManagement.read(type, polymorphic.booleanValue());
    }
}

