/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.preprocessing.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.DefaultFilterExecutor;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.Filter;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.FilterExecutor;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.FilterReader;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.GHNFilterExecutor;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.RIFilterExecutor;

public class FilterManager {
    protected static GCUBELog logger = new GCUBELog(FilterManager.class);
    protected static Map<String, List<Filter>> filters = Collections.synchronizedMap(new HashMap());
    protected static FilterReader reader = null;

    public static FilterExecutor getExecutor(String resourceType) {
        FilterManager.initReader();
        logger.trace((Object)("Executor for " + resourceType + " requested"));
        logger.trace((Object)("Number of filters available: " + FilterManager.getFilters(resourceType).size()));
        if (resourceType.compareTo("GHN") == 0) {
            return new GHNFilterExecutor(FilterManager.getFilters(resourceType));
        }
        if (resourceType.compareTo("RunningInstance") == 0) {
            return new RIFilterExecutor(FilterManager.getFilters(resourceType));
        }
        return new DefaultFilterExecutor(FilterManager.getFilters(resourceType));
    }

    protected static synchronized List<Filter> getFilters(String resourceType) {
        if (!filters.containsKey(resourceType)) {
            filters.put(resourceType, new ArrayList());
        }
        return filters.get(resourceType);
    }

    private static synchronized void initReader() {
        if (reader == null) {
            reader = new FilterReader();
        }
    }
}

